/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JCSAssemblyPanel;
import org.geowidgets.crs.widgets.swing.JGeodeticDatumAssemblyPanel;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;

public class JGeographicCRSAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = -6435132214220446972L;
    int dim;
    protected JCSAssemblyPanel csPanel;
    protected JGeodeticDatumAssemblyPanel gdPanel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JGeographicCRSAssemblyPanel(Color c, int dim) {
        super("x.GCRS", "x.GCRS.Custom", c, GeographicCRS.class, String.valueOf(Integer.toString(dim)) + "D");
        this.dim = dim;
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC comboGBC = UI.getComboGBC();
        this.csPanel = new JCSAssemblyPanel(null, EllipsoidalCS.class, 2);
        this.csPanel.setBackground(this.customPanelColor);
        this.gdPanel = new JGeodeticDatumAssemblyPanel(null);
        this.gdPanel.setBackground(this.customPanelColor);
        custom.add((Component)this.csPanel, comboGBC.setPos(0, 0));
        custom.add((Component)this.gdPanel, comboGBC.setPos(0, 1));
    }

    public GeographicCRS getCRS() throws FactoryException {
        EPSGEntry entry;
        Object temp = this.dropdown.getSelectedItem();
        EPSGEntry ePSGEntry = entry = temp == null ? EPSGEntry.OTHER : (EPSGEntry)temp;
        if (this.isCustom) {
            EllipsoidalCS eCS = (EllipsoidalCS)this.csPanel.getCS();
            GeodeticDatum gd = this.gdPanel.getGeodeticDatum();
            return model.createGeographicCRS(entry.getName(), gd, eCS);
        }
        try {
            return model.createGeographicCRS(entry.getCode());
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCRS(GeographicCRS crs) {
        EPSGEntry entry = model.getEntryFor((IdentifiedObject)crs);
        super.setToObject(entry);
        this.csPanel.setCS(crs.getCoordinateSystem());
        this.gdPanel.setGeodeticDatum((GeodeticDatum)crs.getDatum());
    }
}

