/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import javax.units.Unit;
import org.MaBaUtils.C;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JUnitComboBox;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.validation.impl.BackgroundColorNotifier;
import org.geowidgets.framework.validation.impl.SimpleTextFieldValidator;
import org.geowidgets.framework.validation.swing.JValidatedTextComponent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.datum.PrimeMeridian;

public class JPrimeMeridianAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = 2487929851004322326L;
    protected static final String ERR_PARAMS = Res.get(Res.WIDGETS, "err.PMParam");
    protected JUnitComboBox cb_PMUnit;
    protected JTextField t_GWL;
    protected JValidatedTextComponent<JTextField> val_GWL;
    static /* synthetic */ Class class$0;

    public JPrimeMeridianAssemblyPanel(Color c) {
        super("x.PM", "x.PM.Custom", c, PrimeMeridian.class, null);
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC labelGBC = UI.getLabelGBC();
        ComfortGBC comboGBC = UI.getComboGBC();
        custom.add((Component)UI.createJLabel(Res.CRS, "x.UnitAngular"), labelGBC.setPos(0, 2));
        custom.add((Component)UI.createJLabel(Res.CRS, "x.GreenwichLong2"), labelGBC.setPos(0, 3));
        this.cb_PMUnit = new JUnitComboBox(1, true);
        NumberFormatter formatter = new NumberFormatter();
        this.t_GWL = UI.customize(new JFormattedTextField(formatter));
        custom.add((Component)this.cb_PMUnit, comboGBC.setPos(1, 2));
        custom.add((Component)this.t_GWL, comboGBC.setPos(1, 3));
        Color badColor = new Color(255, 50, 50);
        this.val_GWL = new JValidatedTextComponent<JTextField>(this.t_GWL, new SimpleTextFieldValidator(ERR_PARAMS, this.t_GWL, Double.MIN_VALUE, Double.MAX_VALUE), new BackgroundColorNotifier(this.t_GWL, badColor, null));
    }

    public PrimeMeridian getPrimeMeridian() throws FactoryException {
        EPSGEntry entry;
        Object temp = this.dropdown.getSelectedItem();
        EPSGEntry ePSGEntry = entry = temp == null ? EPSGEntry.OTHER : (EPSGEntry)temp;
        if (this.isCustom) {
            double lon = C.getdoubleX(this.t_GWL.getText(), 0.0);
            Unit aUnit = this.cb_PMUnit.getSelectedUnit();
            return model.createPrimeMeridian(entry.getName(), lon, aUnit);
        }
        try {
            return model.createPrimeMeridian(entry.getCode());
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setPrimeMeridian(PrimeMeridian pm) {
        EPSGEntry entry = model.getEntryFor((IdentifiedObject)pm);
        super.setToObject(entry);
        this.t_GWL.setText(Double.toString(pm.getGreenwichLongitude()));
        this.cb_PMUnit.setSelectedUnit(pm.getAngularUnit());
    }
}

