/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JCSAssemblyPanel;
import org.geowidgets.crs.widgets.swing.JGeographicCRSAssemblyPanel;
import org.geowidgets.crs.widgets.swing.JProjectionAssemblyPanel;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.Conversion;

public class JProjectedCRSAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = 3257005453816116276L;
    int dim;
    protected JCSAssemblyPanel csPanel;
    protected JGeographicCRSAssemblyPanel crsPanel;
    protected JProjectionAssemblyPanel proPanel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JProjectedCRSAssemblyPanel(Color c, int dim) {
        super("x.PCRS", "x.PCRS.Custom", c, ProjectedCRS.class, String.valueOf(Integer.toString(dim)) + "D");
        this.dim = dim;
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC comboGBC = UI.getComboGBC();
        this.csPanel = new JCSAssemblyPanel(null, CartesianCS.class, 2);
        this.csPanel.setBackground(this.customPanelColor);
        int h = this.csPanel.dropdown.getPreferredSize().height;
        this.csPanel.dropdown.setPreferredSize(new Dimension(300, h));
        this.proPanel = new JProjectionAssemblyPanel(null);
        this.proPanel.setBackground(this.customPanelColor);
        this.crsPanel = new JGeographicCRSAssemblyPanel(null, this.dim);
        this.crsPanel.setBackground(this.customPanelColor);
        custom.add((Component)this.csPanel, comboGBC.setPos(0, 0));
        custom.add((Component)this.proPanel, comboGBC.setPos(0, 1));
        custom.add((Component)this.crsPanel, comboGBC.setPos(0, 2));
    }

    public ProjectedCRS getCRS() throws FactoryException {
        EPSGEntry entry;
        Object temp = this.dropdown.getSelectedItem();
        EPSGEntry ePSGEntry = entry = temp == null ? EPSGEntry.OTHER : (EPSGEntry)temp;
        if (this.isCustom) {
            GeographicCRS gCRS = this.crsPanel.getCRS();
            CartesianCS cCS = (CartesianCS)this.csPanel.getCS();
            Conversion conv = this.proPanel.getConversion();
            return model.createProjectedCRS(entry.getName(), gCRS, cCS, conv);
        }
        try {
            return model.createProjectedCRS(entry.getCode());
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCRS(ProjectedCRS crs) {
        EPSGEntry entry = model.getEntryFor((IdentifiedObject)crs);
        super.setToObject(entry);
        Conversion conv = crs.getConversionFromBase();
        this.proPanel.setConversion(conv);
        this.csPanel.setCS(crs.getCoordinateSystem());
        this.crsPanel.setCRS((GeographicCRS)crs.getBaseCRS());
    }
}

