/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.units.Unit;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.ui.GeneralSwingUIFactory;
import org.geowidgets.units.model.IUnitModel;
import org.opengis.referencing.FactoryException;

public class JUnitComboBox
extends JComboBox {
    private static final long serialVersionUID = 3257854281171677235L;
    protected GeneralSwingUIFactory uiFactory = GWFactoryFinder.getGeneralSwingUIFactory();
    protected int unitType;
    protected boolean sorted;
    protected Unit customUnit;
    String customName;
    protected IUnitModel model = GWFactoryFinder.getUnitModel();

    public JUnitComboBox(int unitType, boolean sorted) {
        this.uiFactory.customize(this);
        List<String> l = this.model.getSupportedUnits(unitType);
        if (sorted) {
            Collections.sort(l);
        }
        super.setModel(new DefaultComboBoxModel<String>(new Vector<String>(l)));
        String def = this.model.getDefaultUnit(unitType);
        this.setSelectedItem(def);
        this.unitType = unitType;
        this.sorted = sorted;
    }

    public Unit getSelectedUnit() {
        String u = super.getSelectedItem().toString();
        if (u == this.customName) {
            return this.customUnit;
        }
        try {
            return this.model.getUnit(u);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setSelectedUnit(Unit u) {
        boolean success = false;
        try {
            int i = 0;
            while (i < this.getItemCount()) {
                if (this.model.getUnit((String)this.getItemAt(i)).equals((Object)u)) {
                    success = true;
                    this.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!success) {
            this.customName = u.toString();
            this.customUnit = u;
            ((DefaultComboBoxModel)this.getModel()).addElement(this.customName);
            super.setSelectedItem(this.customName);
        }
    }
}

