/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.model.GeoTools_CRSModel;
import org.geowidgets.crs.model.ICRSModel;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.ui.CRS_SwingUIFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _AssemblyPanel
extends JPanel {
    protected static final CRS_SwingUIFactory UI = GWFactoryFinder.getCRS_SwingUIFactory();
    protected static final Logger LOGGER = GWFactoryFinder.getLoggerFactory().getLogger();
    protected JComboBox dropdown;
    protected JScrollPane sc;
    protected JTextArea standard = UI.createInformationJTextArea();
    protected JPanel custom;
    protected JPanel p_Buttons = new JPanel(new GridBagLayout());
    public JButton b_OK = new JButton(Res.get("b.OK"));
    public JButton b_Cancel = new JButton(Res.get("b.Cancel"));
    protected boolean customPossible = true;
    protected boolean isCustom = true;
    protected int lastSelected = -1;
    protected static final ICRSModel model = GeoTools_CRSModel.getDefault();
    protected Color customPanelColor;
    protected Class<? extends IdentifiedObject> cl;
    protected String hints;

    public _AssemblyPanel(String labelText, String panelText, Color customPanelColor, Class<? extends IdentifiedObject> cl, String hints) {
        List<EPSGEntry> ddContent;
        try {
            ddContent = model.getSupportedObjects(cl, hints);
        }
        catch (FactoryException fe) {
            LOGGER.log(Level.WARNING, "err.GetSupportedObjects", fe);
            ddContent = new Vector<EPSGEntry>();
        }
        customPanelColor = customPanelColor == null ? UI.getCustomPanelColor(cl) : customPanelColor;
        this.initAssemblyWidget(labelText, panelText, ddContent, customPanelColor);
        this.customPanelColor = customPanelColor;
        this.cl = cl;
        this.hints = hints;
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                _AssemblyPanel.this.invalidate();
            }
        });
    }

    protected boolean updateInformationLabel(JTextArea standard, String epsgCode) {
        try {
            standard.setText(model.getFormattedDescription(this.cl, epsgCode));
            return true;
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void initAssemblyWidget(String labelText, String panelText, List<EPSGEntry> ddContent, Color customPanelColor) {
        this.setLayout(new GridBagLayout());
        ComfortGBC labelGBC = UI.getLabelGBC();
        ComfortGBC comboGBC = UI.getComboGBC();
        ComfortGBC panelGBC = UI.getPanelGBC();
        ComfortGBC buttonGBC = new ComfortGBC(0, 0).anchorNE().fillY().setSize(2, 1);
        this.b_OK.setDefaultCapable(true);
        this.p_Buttons.setOpaque(false);
        this.p_Buttons.add((Component)this.b_OK, comboGBC.setPos(0, 0));
        this.p_Buttons.add((Component)this.b_Cancel, comboGBC.setPos(1, 0));
        this.p_Buttons.setVisible(false);
        this.add((Component)this.p_Buttons, buttonGBC);
        this.add((Component)UI.createJLabel(Res.CRS, labelText), labelGBC.setPos(0, 1));
        if (ddContent == null) {
            ddContent = new ArrayList<EPSGEntry>();
        }
        Collections.sort(ddContent);
        ddContent.add(0, EPSGEntry.OTHER);
        this.dropdown = UI.customize(new JComboBox<EPSGEntry>(new Vector<EPSGEntry>(ddContent)));
        this.dropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object o = _AssemblyPanel.this.dropdown.getSelectedItem();
                boolean custom = o == null || ((EPSGEntry)o).equals(EPSGEntry.OTHER);
                _AssemblyPanel.this.setCustomInternal(custom);
            }
        });
        this.dropdown.setEditable(true);
        this.add((Component)this.dropdown, comboGBC.setPos(1, 1));
        this.standard.setOpaque(false);
        this.add((Component)this.standard, panelGBC.setPos(0, 2));
        this.custom = UI.createCustomPanel(panelText, customPanelColor);
        this.add((Component)this.custom, panelGBC.setPos(0, 2));
    }

    public void setCustomPossible(boolean customPossible) {
        this.customPossible = customPossible;
        if (this.isCustom && !customPossible) {
            this.setCustom(false);
        }
        if (!customPossible) {
            this.dropdown.removeItemAt(0);
        } else {
            this.dropdown.insertItemAt(EPSGEntry.OTHER, 0);
        }
    }

    public boolean isCustomPossible() {
        return this.customPossible;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    protected void setCustomInternal(boolean custom) {
        String code;
        Object o;
        this.isCustom = custom;
        if (!custom && (o = this.dropdown.getSelectedItem()) != null && (code = ((EPSGEntry)o).getCode()) != null) {
            this.updateInformationLabel(this.standard, code);
        }
        this.standard.setVisible(!custom);
        this.custom.setVisible(custom);
        this.validate();
    }

    public void setCustom(boolean custom) {
        if (custom && this.customPossible) {
            this.lastSelected = this.dropdown.getSelectedIndex();
            this.isCustom = true;
        } else {
            if (this.lastSelected == -1) {
                this.setToDefault();
            } else {
                this.dropdown.setSelectedIndex(this.lastSelected);
            }
            this.isCustom = false;
        }
    }

    protected void setToDefault() {
        EPSGEntry entry = model.getDefaultEntry(this.cl, this.hints);
        this.dropdown.setSelectedItem(entry);
    }

    public boolean setToObject(EPSGEntry entry) {
        this.dropdown.setSelectedItem(entry);
        try {
            if (((EPSGEntry)this.dropdown.getSelectedItem()).equals(entry)) {
                this.dropdown.setToolTipText(entry.getName());
                return true;
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public EPSGEntry findEntry(String name) {
        int i = 0;
        while (i < this.dropdown.getItemCount()) {
            try {
                EPSGEntry entry = (EPSGEntry)this.dropdown.getItemAt(i);
                if (entry.getName().equals(name)) {
                    return entry;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public void setButtonsVisible(boolean visible) {
        this.p_Buttons.setVisible(visible);
    }

    @Override
    public void setBackground(Color backColor) {
        super.setBackground(backColor);
        if (this.standard != null) {
            this.standard.setBackground(backColor);
        }
    }

    public void addActionListener(ActionListener al) {
        if (al != null) {
            this.b_OK.addActionListener(al);
            this.b_Cancel.addActionListener(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al != null) {
            this.b_OK.removeActionListener(al);
            this.b_Cancel.removeActionListener(al);
        }
    }
}

