/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swt;

import java.util.Collections;
import java.util.List;
import javax.units.Unit;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.ui.GeneralSWTUIFactory;
import org.geowidgets.units.model.IUnitModel;
import org.opengis.referencing.FactoryException;

public class UnitComboBox {
    protected GeneralSWTUIFactory uiFactory = GWFactoryFinder.getGeneralSWTUIFactory();
    protected Combo combo;
    protected int unitType;
    protected boolean sorted;
    protected Unit customUnit;
    String customName;
    protected IUnitModel model = GWFactoryFinder.getUnitModel();

    public UnitComboBox(Composite parent, int unitType, boolean sorted) {
        this.combo = new Combo(parent, 4);
        this.uiFactory.customizeJCombo(this.combo);
        String def = this.model.getDefaultUnit(unitType);
        List<String> units = this.model.getSupportedUnits(unitType);
        if (sorted) {
            Collections.sort(units);
        }
        int i = 0;
        for (String unit : units) {
            this.combo.add(unit);
            if (unit.equals(def)) {
                this.combo.select(i);
            }
            ++i;
        }
        this.unitType = unitType;
        this.sorted = sorted;
    }

    public Unit getSelectedUnit() {
        String u = this.combo.getItem(this.combo.getSelectionIndex());
        if (u == this.customName) {
            return this.customUnit;
        }
        try {
            return this.model.getUnit(u);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setSelectedUnit(Unit u) {
        boolean success = false;
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.getSelectedUnit().equals((Object)u)) {
                success = true;
                this.combo.select(i);
                break;
            }
            ++i;
        }
        if (!success) {
            this.customName = u.toString();
            this.customUnit = u;
            this.combo.add(this.customName);
            this.combo.select(this.combo.getItemCount());
        }
    }

    public Combo getCombo() {
        return this.combo;
    }
}

