/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.basewidgets.propertysheet;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.FloatingPointCellEditor;

public class FloatingPointPropertyDescriptor
extends TextPropertyDescriptor {
    public FloatingPointPropertyDescriptor(Object id, String displayName, final double minValue, final double maxValue) {
        super(id, displayName);
        this.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Double d = new Double((String)value);
                    if (d >= minValue && d <= maxValue) {
                        return null;
                    }
                    return Res.get("err.PositiveNumberExpected");
                }
                catch (Exception e) {
                    return Res.get("err.PositiveNumberExpected");
                }
            }
        });
    }

    public CellEditor createPropertyEditor(Composite parent) {
        FloatingPointCellEditor editor = new FloatingPointCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }
}

