/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.basewidgets.propertysheet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralComboCellEditor<T>
extends CellEditor {
    private static final int STYLE_DEFAULT = 0;
    protected CCombo comboBox;
    protected List<T> objects;
    protected ILabelProvider labelProvider;

    public GeneralComboCellEditor(Composite parent, List<T> items, boolean editable) {
        this(parent, items, editable, (ILabelProvider)new GeneralComboLabelProvider());
    }

    public GeneralComboCellEditor(Composite parent, List<T> items, boolean editable, ILabelProvider labelProvider) {
        this(parent, items, labelProvider, editable ? 0 : 8);
    }

    public GeneralComboCellEditor(Composite parent, List<T> items, ILabelProvider labelProvider, int style) {
        super(parent, style);
        this.objects = items;
        this.labelProvider = labelProvider;
        if (this.comboBox != null) {
            this.comboBox.setItems(this.getStrings(items, labelProvider));
        }
    }

    protected String[] getStrings(List<T> items, ILabelProvider labelProvider) {
        if (items == null) {
            throw new NullPointerException(Res.get("err.NullPointerItems"));
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < items.size()) {
            String label = labelProvider.getText(items.get(i));
            list.add(i, label);
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    protected Object doGetValue() {
        if (this.comboBox == null) {
            return null;
        }
        int i = this.comboBox.getSelectionIndex();
        if (i > -1) {
            return this.objects.get(i);
        }
        return this.comboBox.getText();
    }

    protected void doSetValue(Object value) {
        if (value == null || this.comboBox == null) {
            return;
        }
        String valueLabel = this.labelProvider.getText(value);
        int i = 0;
        while (i < this.objects.size()) {
            if (this.labelProvider.getText(this.objects.get(i)).equals(valueLabel)) {
                this.comboBox.select(i);
            }
            ++i;
        }
        this.comboBox.setText(valueLabel);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.deactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.deactivate();
        }
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setVisibleItemCount(10);
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                GeneralComboCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GeneralComboCellEditor.this.fireApplyEditorValue();
                GeneralComboCellEditor.this.deactivate();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (GeneralComboCellEditor.this.comboBox.getSelectionIndex() == -1) {
                    String[] items = GeneralComboCellEditor.this.comboBox.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(GeneralComboCellEditor.this.comboBox.getText())) {
                            GeneralComboCellEditor.this.comboBox.select(i);
                            break;
                        }
                        ++i;
                    }
                }
                GeneralComboCellEditor.this.fireApplyEditorValue();
                GeneralComboCellEditor.this.deactivate();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GeneralComboCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }
}

