/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralSwingUIFactory {
    protected static GeneralSwingUIFactory me = new GeneralSwingUIFactory();
    protected GridBagLayout defaultLayout = new GridBagLayout();
    protected Insets defaultInsets = new Insets(2, 2, 2, 2);
    protected ComfortGBC GBC_DEFAULT = new ComfortGBC(0, 0).fillX().anchorNW().setInsets(this.getInsets());
    protected ComfortGBC GBC_LABEL = new ComfortGBC(0, 0).fillX().anchorW().setInsets(this.getInsets());
    protected ComfortGBC GBC_COMBO = new ComfortGBC(0, 0).fillX().anchorW().setInsets(this.getInsets()).setWeight(1.0, 0.0);
    protected ComfortGBC GBC_PANEL = new ComfortGBC(0, 0).fillX().anchorNW().setInsets(this.getInsets()).setWeight(1.0, 1.0).setSize(2, 1);
    protected final Color backColor = new JPanel().getBackground();
    protected final Color textBackColor = new JTextField().getBackground();
    protected final Color foreColor = new JPanel().getForeground();
    protected final Color labelColor = new Color(0, 0, 0);
    protected final Color textColor = new Color(0, 0, 0);
    protected final Color descColor = new Color(0, 0, 128);
    protected final Border panelBorder = new EtchedBorder();
    protected final Border textBorder = new JTextField().getBorder();
    protected int textFieldHeight;
    public static final int MESSAGE_PLAIN = -1;
    public static final int MESSAGE_QUESTION = 3;
    public static final int MESSAGE_INFO = 1;
    public static final int MESSAGE_WARNING = 2;
    public static final int MESSAGE_ERROR = 0;
    public static final int OPTION_YES_NO_CANCEL = 1;
    public static final int OPTION_YES_NO = 0;
    public static final int OPTION_OK_CANCEL = 2;
    public static final int RESULT_CANCEL = 2;
    public static final int RESULT_NO = 1;
    public static final int RESULT_YES = 0;
    public static final int RESULT_OK = 0;
    protected final String CAUSE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    protected GeneralSwingUIFactory() {
        this.textFieldHeight = new JTextField().getPreferredSize().height;
        this.CAUSE = Res.get(Res.WIDGETS, "err.Cause");
    }

    public static GeneralSwingUIFactory getDefault() {
        return me;
    }

    public LayoutManager2 getDefaultLayout() {
        return this.defaultLayout;
    }

    public Insets getInsets() {
        return this.defaultInsets;
    }

    public int getInsetWidth() {
        return 2;
    }

    public ComfortGBC getDefaultGBC() {
        return (ComfortGBC)this.GBC_DEFAULT.clone();
    }

    public ComfortGBC getLabelGBC() {
        return (ComfortGBC)this.GBC_LABEL.clone();
    }

    public ComfortGBC getComboGBC() {
        return (ComfortGBC)this.GBC_COMBO.clone();
    }

    public ComfortGBC getPanelGBC() {
        return (ComfortGBC)this.GBC_PANEL.clone();
    }

    public final Color getBackgroundColor() {
        return this.backColor;
    }

    public final Color getTextBackgroundColor() {
        return this.textBackColor;
    }

    public final Color getForegroundColor() {
        return this.foreColor;
    }

    public final Color getLabelColor() {
        return this.descColor;
    }

    public final Color getTextColor() {
        return this.textColor;
    }

    public final Color getDescriptionColor() {
        return this.descColor;
    }

    public final Border getDefaultPanelBorder() {
        return this.panelBorder;
    }

    public final Border getDefaultTextComponentBorder() {
        return this.textBorder;
    }

    public Dimension getMinTextFieldSize() {
        return new Dimension(60, 18);
    }

    public void showMessage(Component parent, String msg, String title, int msgTypeConst) {
        JOptionPane.showMessageDialog(parent, msg, title, msgTypeConst);
    }

    public void showInfo(Component parent, String msg, String title) {
        JOptionPane.showMessageDialog(parent, msg, title, 1);
    }

    public void showWarning(Component parent, String msg, String title) {
        JOptionPane.showMessageDialog(parent, msg, title, 2);
    }

    public void showError(Component parent, String msg, String title, Throwable e) {
        String message = String.valueOf(e.getLocalizedMessage()) + "\n";
        if (e.getCause() != null) {
            message = String.valueOf(message) + this.CAUSE + e.getCause().getLocalizedMessage() + "\n";
        }
        message = String.valueOf(message) + msg;
        JOptionPane.showMessageDialog(parent, msg, title, 2);
    }

    public int showConfirmDialog(Component parent, String msg, String title, int msgTypeConst, int optionTypeConst) {
        int result = JOptionPane.showConfirmDialog(parent, msg, title, optionTypeConst, msgTypeConst);
        if (result == -1 || result == 1) {
            result = 2;
        }
        return result;
    }

    public JLabel customizeJLabel(JLabel label) {
        label.setForeground(this.labelColor);
        label.setOpaque(false);
        label.setMinimumSize(this.getMinTextFieldSize());
        return label;
    }

    public JLabel createJLabel(ResourceBundle rb, String textResource) {
        return this.customize(new JLabel(Res.get(rb, textResource)));
    }

    public JTextField customizeJTextField(JTextField textField) {
        textField.setForeground(this.textColor);
        textField.setMinimumSize(this.getMinTextFieldSize());
        return textField;
    }

    public JTextField createJTextField(ResourceBundle rb, String textResource) {
        return this.customize(new JTextField(Res.get(rb, textResource)));
    }

    protected JComboBox customizeJCombo(JComboBox combo) {
        combo.setForeground(this.textColor);
        combo.setMinimumSize(this.getMinTextFieldSize());
        combo.setPreferredSize(new Dimension(combo.getPreferredSize().width, this.textFieldHeight));
        combo.setBorder(this.getDefaultTextComponentBorder());
        combo.setMaximumRowCount(10);
        if (combo.getSelectedItem() != null) {
            combo.setToolTipText(combo.getSelectedItem().toString());
        }
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                if (source.getSelectedItem() != null) {
                    source.setToolTipText(source.getSelectedItem().toString());
                }
            }
        });
        return combo;
    }

    protected JList customizeJList(JList list) {
        list.setForeground(this.textColor);
        list.setMinimumSize(this.getMinTextFieldSize());
        list.setPreferredSize(new Dimension(list.getPreferredSize().width, this.textFieldHeight));
        list.setBorder(this.getDefaultTextComponentBorder());
        list.setLayoutOrientation(0);
        list.setSelectionMode(0);
        if (list.getSelectedValue() != null) {
            list.setToolTipText(list.getSelectedValue().toString());
        }
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JList source = (JList)e.getSource();
                if (source.getSelectedValue() != null) {
                    source.setToolTipText(source.getSelectedValue().toString());
                }
            }
        });
        return list;
    }

    public JTextArea createInformationJTextArea() {
        JTextArea textArea = new JTextArea();
        this.customize(textArea);
        textArea.setEditable(false);
        textArea.setForeground(this.descColor);
        textArea.setFont(new JLabel().getFont());
        textArea.setBorder(new EmptyBorder(this.getInsets()));
        return textArea;
    }

    public JPanel customizeJPanel(JPanel panel) {
        panel.setLayout(this.defaultLayout);
        return panel;
    }

    public JPanel createJPanel() {
        return this.customize(new JPanel());
    }

    public JPanel createJPanel(ResourceBundle rb, String titleResource) {
        JPanel panel = this.createJPanel();
        if (Util.ensureNotEmpty(titleResource)) {
            panel.setBorder(new TitledBorder(new EtchedBorder(), Res.get(rb, titleResource)));
        }
        return this.customize(panel);
    }

    public <SomeJComponent extends JComponent> SomeJComponent customize(SomeJComponent c) {
        Class<?> cl = c.getClass();
        c.setBackground(this.getBackgroundColor());
        c.setForeground(this.getForegroundColor());
        if (JTextComponent.class.isAssignableFrom(cl)) {
            JTextComponent c2 = (JTextComponent)c;
            c2.setBackground(this.getTextBackgroundColor());
            c2.setForeground(this.getTextColor());
            if (JTextField.class.isAssignableFrom(cl)) {
                JTextField textField = (JTextField)c;
                textField.setMinimumSize(this.getMinTextFieldSize());
            } else if (JTextArea.class.isAssignableFrom(cl)) {
                JTextArea textArea = (JTextArea)c;
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
            }
        } else if (JTree.class.isAssignableFrom(cl) || JComboBox.class.isAssignableFrom(cl) || JList.class.isAssignableFrom(cl)) {
            c.setBackground(this.getTextBackgroundColor());
            c.setBorder(this.getDefaultTextComponentBorder());
            if (JComboBox.class.isAssignableFrom(cl)) {
                this.customizeJCombo((JComboBox)c);
            } else if (JList.class.isAssignableFrom(cl)) {
                this.customizeJList((JList)c);
            }
        } else if (JLabel.class.isAssignableFrom(cl)) {
            JLabel c2 = (JLabel)c;
            c2.setForeground(this.getTextColor());
            c2.setOpaque(false);
        } else if (JPanel.class.isAssignableFrom(cl)) {
            JPanel c2 = (JPanel)c;
            c2.setLayout(this.getDefaultLayout());
        } else if (JTabbedPane.class.isAssignableFrom(cl)) {
            JTabbedPane c2 = (JTabbedPane)c;
            c2.setTabPlacement(1);
        }
        return c;
    }
}

