/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.validation.impl;

import java.util.HashSet;
import java.util.Set;
import org.geowidgets.framework.validation.IValidationListener;
import org.geowidgets.framework.validation.IValidator;
import org.geowidgets.framework.validation.ValidationEvent;
import org.geowidgets.framework.validation.impl._Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedValidator
extends _Validator
implements IValidationListener {
    public static int COMBINE_AND = 0;
    public static int COMBINE_OR = 1;
    protected String errMsg = null;
    protected int bool;
    Set<IValidator> validators;

    public CombinedValidator(String errMsg, int bool, Set<IValidator> validators) {
        this.errMsg = errMsg;
        this.bool = bool;
        this.validators = validators;
        for (IValidator val : validators) {
            val.validate();
            val.addValidationListener(this);
        }
    }

    public CombinedValidator(String errMsg, int bool, IValidator val1, IValidator val2) {
        this(errMsg, bool, CombinedValidator.createSet(val1, val2));
    }

    private static Set<IValidator> createSet(IValidator val1, IValidator val2) {
        HashSet<IValidator> set = new HashSet<IValidator>();
        set.add(val1);
        set.add(val2);
        return set;
    }

    @Override
    public ValidationEvent validateInternal() {
        ValidationEvent ev = new ValidationEvent();
        if (this.bool == COMBINE_AND) {
            ev.validationPassed = true;
            for (IValidator val : this.validators) {
                if (val.getPreviousResult()) continue;
                ev.validationPassed = false;
                ev.problemMessage = this.errMsg;
                break;
            }
        } else if (this.bool == COMBINE_OR) {
            ev.validationPassed = false;
            ev.problemMessage = this.errMsg;
            for (IValidator val : this.validators) {
                if (!val.getPreviousResult()) continue;
                ev.validationPassed = true;
                ev.problemMessage = null;
                break;
            }
        } else {
            return null;
        }
        return ev;
    }

    @Override
    public void validationPerformed(ValidationEvent ev) {
        this.validate();
    }
}

