/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.validation.impl;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.geowidgets.framework.Util;
import org.geowidgets.framework.validation.ValidationEvent;
import org.geowidgets.framework.validation.impl._Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTextFieldValidator
extends _Validator
implements DocumentListener {
    protected static final int TYPE_NONNULL = 0;
    protected static final int TYPE_VALUE_RANGE = 1;
    protected static final int TYPE_VALUE_TEXTVALUES = 2;
    protected JTextComponent textComp;
    protected int type = 0;
    protected double minValue = Double.MIN_VALUE;
    protected double maxValue = Double.MAX_VALUE;
    protected Set<String> values = new HashSet<String>();
    protected String msg = null;

    public SimpleTextFieldValidator(String errMsg, JTextComponent textComp) {
        this.msg = errMsg;
        this.textComp = textComp;
        this.textComp.getDocument().addDocumentListener(this);
    }

    public SimpleTextFieldValidator(String errMsg, JTextComponent textComp, double minValue, double maxValue) {
        this(errMsg, textComp);
        this.type = 1;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public SimpleTextFieldValidator(String errMsg, JTextComponent textComp, Set<String> values) {
        this(errMsg, textComp);
        this.type = 1;
        this.values = values;
    }

    @Override
    public ValidationEvent validateInternal() {
        String text = this.textComp.getText();
        ValidationEvent ev = new ValidationEvent();
        if (this.type == 0) {
            boolean bl = ev.validationPassed = !Util.isEmpty(text);
            if (!ev.validationPassed) {
                ev.problemMessage = this.msg;
            }
        } else if (this.type == 1) {
            try {
                double value = Double.parseDouble(text);
                ev.validationPassed = value >= this.minValue && value <= this.maxValue;
            }
            catch (NumberFormatException e) {
                ev.validationPassed = false;
            }
            if (!ev.validationPassed) {
                ev.problemMessage = this.msg;
            }
        } else if (this.type == 2) {
            ev.validationPassed = false;
            for (String value : this.values) {
                if (!value.equals(text)) continue;
                ev.validationPassed = true;
                break;
            }
            if (!ev.validationPassed) {
                ev.problemMessage = this.msg;
            }
        }
        return ev;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validate();
    }
}

