/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.validation.impl;

import java.util.HashSet;
import java.util.Set;
import org.geowidgets.framework.validation.IValidationListener;
import org.geowidgets.framework.validation.IValidator;
import org.geowidgets.framework.validation.ValidationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _Validator
implements IValidator {
    protected Set<IValidationListener> listeners = new HashSet<IValidationListener>();
    protected boolean lastResult = true;

    @Override
    public void addValidationListener(IValidationListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeValidationListener(IValidationListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public abstract ValidationEvent validateInternal();

    @Override
    public boolean validate() {
        ValidationEvent ev = this.validateInternal();
        if (ev == null) {
            return false;
        }
        ev.validationPassedBefore = this.lastResult;
        this.lastResult = ev.validationPassed;
        this.notifyListeners(ev);
        return ev.validationPassed;
    }

    @Override
    public boolean getPreviousResult() {
        return this.lastResult;
    }

    protected void notifyListeners(ValidationEvent ev) {
        for (IValidationListener listener : this.listeners) {
            listener.validationPerformed(ev);
        }
    }

    @Override
    public Set<IValidationListener> getValidationListeners() {
        return this.listeners;
    }
}

