/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.framework.validation.swing;

import javax.swing.text.JTextComponent;
import org.geowidgets.framework.validation.IValidationListener;
import org.geowidgets.framework.validation.IValidationNotifier;
import org.geowidgets.framework.validation.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JValidatedTextComponent<T extends JTextComponent> {
    protected T component;
    IValidator validator = null;
    IValidationNotifier notifier = null;

    public JValidatedTextComponent(T textComp) {
        this.component = textComp;
    }

    public JValidatedTextComponent(T textComp, IValidator validator, IValidationNotifier notifier) {
        this.component = textComp;
        this.setValidator(validator, false);
        this.setNotifier(notifier);
        validator.validate();
    }

    public T getTextComponent() {
        return this.component;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IValidator validator, boolean keepNotifiers) {
        if (keepNotifiers) {
            for (IValidationListener l : this.validator.getValidationListeners()) {
                if (!(l instanceof IValidationNotifier)) continue;
                validator.addValidationListener(l);
            }
        }
        this.validator = validator;
    }

    public IValidationNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(IValidationNotifier notifier) {
        if (this.validator != null) {
            this.validator.removeValidationListener(this.notifier);
        }
        this.notifier = notifier;
        if (this.validator != null) {
            this.validator.addValidationListener(this.notifier);
        }
    }
}

