/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.units.model;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.units.Unit;
import org.geotools.referencing.FactoryFinder;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.Res;
import org.geowidgets.units.model.IUnitModel;
import org.geowidgets.units.model._UnitCombiBoxModel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.cs.CSAuthorityFactory;

public class EPSG_UnitModel
extends _UnitCombiBoxModel {
    protected static final Logger LOGGER = GWFactoryFinder.getLoggerFactory().getLogger();
    protected CSAuthorityFactory csFactory = FactoryFinder.getCSAuthorityFactory((String)"EPSG", null);
    protected static EPSG_UnitModel me = new EPSG_UnitModel();
    static /* synthetic */ Class class$0;

    public static IUnitModel getDefault() {
        return me;
    }

    protected EPSG_UnitModel() {
        this.fillUnits();
    }

    protected void fillUnits() {
        try {
            Set codes = this.csFactory.getAuthorityCodes(Unit.class);
            for (String code : codes) {
                try {
                    Unit unit = this.csFactory.createUnit(code);
                    String name = this.csFactory.getDescriptionText(code).toString();
                    int c = new Integer(code);
                    if (c < 9100) {
                        this.lUnits.put(name, unit);
                        continue;
                    }
                    if (c <= 9100 || c >= 9200) continue;
                    this.aUnits.put(name, unit);
                }
                catch (Exception e) {
                    String msg = Res.get(Res.WIDGETS, "err.CreateUnit", code);
                    LOGGER.log(Level.FINE, msg);
                }
            }
        }
        catch (FactoryException fe) {
            LOGGER.log(Level.WARNING, "err.UnitCodes", fe);
        }
    }

    public String getDefaultUnit(int unitType) {
        try {
            String u = unitType == 1 ? "9101" : "9001";
            return this.csFactory.getDescriptionText(u).toString();
        }
        catch (FactoryException fe) {
            LOGGER.log(Level.WARNING, "err.UnitCodes", fe);
            return null;
        }
    }
}

