/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.units.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.units.Unit;
import org.geowidgets.units.model.IUnitModel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _UnitCombiBoxModel
implements IUnitModel {
    protected static _UnitCombiBoxModel me;
    protected Map<String, Unit> lUnits = new HashMap<String, Unit>();
    protected Map<String, Unit> aUnits = new HashMap<String, Unit>();

    protected abstract void fillUnits();

    @Override
    public abstract String getDefaultUnit(int var1);

    @Override
    public List<String> getSupportedUnits(int unitType) {
        ArrayList<String> l = new ArrayList<String>();
        if (unitType == -1 || unitType == 0) {
            l.addAll((Collection)this.lUnits.keySet());
        }
        if (unitType == -1 || unitType == 1) {
            l.addAll((Collection<String>)this.aUnits.keySet());
        }
        return l;
    }

    @Override
    public Unit getUnit(String name) throws NoSuchAuthorityCodeException {
        try {
            Unit u = this.lUnits.get(name);
            return u == null ? this.aUnits.get(name) : u;
        }
        catch (Exception e) {
            throw new NoSuchAuthorityCodeException(e.getMessage(), "GeoTools", name);
        }
    }

    @Override
    public String getUnitName(Unit u) throws FactoryException {
        boolean isLUnit = this.lUnits.containsValue(u);
        boolean isAUnit = this.aUnits.containsValue(u);
        if (!isLUnit && !isAUnit) {
            return u.toString();
        }
        Map<String, Unit> m = isLUnit ? this.lUnits : this.aUnits;
        for (String s : m.keySet()) {
            if (!m.get(s).equals((Object)u)) continue;
            return s;
        }
        return null;
    }
}

