/*
 * Decompiled with CFR 0.152.
 */
package test.crs;

import java.util.List;
import javax.units.Unit;
import junit.framework.TestCase;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.model.GeoTools_CRSModel;
import org.geowidgets.crs.model.ICRSModel;
import org.geowidgets.units.model.IUnitModel;
import org.geowidgets.units.model.Units_UnitModel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;

public class JUnit_CRSModel
extends TestCase {
    ICRSModel model;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("************************************");
        this.model = GeoTools_CRSModel.getDefault();
    }

    public void testGetDefault() {
        JUnit_CRSModel.assertNotNull((String)"CRS model is null.", (Object)this.model);
    }

    public void testGetSupportedObjects() {
        this.checkEPSGEntries(Ellipsoid.class, null);
        this.checkEPSGEntries(PrimeMeridian.class, null);
        this.checkEPSGEntries(GeodeticDatum.class, null);
        this.checkEPSGEntries(EllipsoidalCS.class, null);
        this.checkEPSGEntries(EllipsoidalCS.class, "3D");
        this.checkEPSGEntries(CartesianCS.class, null);
        this.checkEPSGEntries(CartesianCS.class, "3D");
        this.checkEPSGEntries(Conversion.class, null);
        this.checkEPSGEntries(GeographicCRS.class, null);
        this.checkEPSGEntries(GeographicCRS.class, "3D");
        this.checkEPSGEntries(ProjectedCRS.class, null);
    }

    protected void checkEPSGEntries(Class cl, String hints) {
        EPSGEntry entry = this.model.getDefaultEntry(cl, hints);
        String classString = "Default entry for class " + cl.getName();
        JUnit_CRSModel.assertNotNull((String)(String.valueOf(classString) + "is null."), (Object)entry);
        System.out.println(String.valueOf(classString) + " is: (" + entry.getCode() + "): " + entry.getName());
        try {
            List<EPSGEntry> list = this.model.getSupportedObjects(cl, hints);
            classString = "List of default objects for class " + cl.getName();
            JUnit_CRSModel.assertNotNull((String)(String.valueOf(classString) + "is null."), list);
            System.out.println(String.valueOf(classString) + " contains " + list.size() + " entries.");
        }
        catch (FactoryException e) {
            e.printStackTrace();
            JUnit_CRSModel.fail((String)("Factory exception thrown when trying to get supported objects for \n  " + cl.getName()));
        }
    }

    public void testGetFormattedDescription() {
        this.checkDescription(Ellipsoid.class);
        this.checkDescription(PrimeMeridian.class);
        this.checkDescription(GeodeticDatum.class);
        this.checkDescription(EllipsoidalCS.class);
        this.checkDescription(CartesianCS.class);
        this.checkDescription(Conversion.class);
        this.checkDescription(GeographicCRS.class);
        this.checkDescription(ProjectedCRS.class);
    }

    protected void checkDescription(Class cl) {
        String code = "[not yet determined]";
        try {
            EPSGEntry entry = this.model.getDefaultEntry(cl, null);
            String desc = this.model.getFormattedDescription(cl, entry.getCode());
            System.out.println("Description for \"" + entry.getName() + "\":");
            System.out.println(desc);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            JUnit_CRSModel.fail((String)("Factory exception thrown when trying to get description for \n  " + code + " of class " + cl.getName()));
        }
    }

    public void testGetEntryFor() {
        System.out.println();
        System.out.println("\"getEntryFor(IdentifiedObject)\" is not yet tested.");
    }

    public void testCreateFromCode() {
        Class<Object> cl = Object.class;
        try {
            cl = Ellipsoid.class;
            this.checkObject((IdentifiedObject)this.model.createEllipsoid(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = PrimeMeridian.class;
            this.checkObject((IdentifiedObject)this.model.createPrimeMeridian(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = GeodeticDatum.class;
            this.checkObject((IdentifiedObject)this.model.createGeodeticDatum(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = EllipsoidalCS.class;
            this.checkObject((IdentifiedObject)this.model.createEllipsoidalCS(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = CartesianCS.class;
            this.checkObject((IdentifiedObject)this.model.createCartesianCS(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = GeographicCRS.class;
            this.checkObject((IdentifiedObject)this.model.createGeographicCRS(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = ProjectedCRS.class;
            this.checkObject((IdentifiedObject)this.model.createProjectedCRS(this.model.getDefaultEntry(cl, null).getCode()), cl);
            cl = Conversion.class;
            this.checkObject((IdentifiedObject)this.model.createConversion(this.model.getDefaultEntry(cl, null).getCode()), cl);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            JUnit_CRSModel.fail((String)("Factory exception thrown creating " + cl.getName() + " from code."));
        }
    }

    protected void checkObject(IdentifiedObject o, Class cl) {
        String classString = "Instantiated object for class" + cl.getName();
        JUnit_CRSModel.assertNotNull((String)(String.valueOf(classString) + "is null."), (Object)o);
        System.out.println(String.valueOf(classString) + " is: " + o.getName().getCode());
    }

    public void testCreate() {
        EllipsoidalCS cs;
        GeodeticDatum o;
        Ellipsoid o2;
        Unit lin = null;
        Unit ang = null;
        try {
            IUnitModel m = Units_UnitModel.getDefault();
            lin = m.getUnit(m.getDefaultUnit(0));
            ang = m.getUnit(m.getDefaultUnit(1));
        }
        catch (FactoryException e) {
            e.printStackTrace();
            JUnit_CRSModel.fail((String)"Failing to create the units needed to build CRS objects.");
        }
        try {
            o2 = this.model.createEllipsoid("Custom", "65432", "54321", null, lin);
            System.out.println(o2.getSemiMinorAxis());
        }
        catch (FactoryException e) {
            this.fail((Exception)((Object)e), "ellipsoid");
        }
        try {
            o2 = this.model.createPrimeMeridian("Custom", 12.0, ang);
            System.out.println(o2.getGreenwichLongitude());
        }
        catch (FactoryException e) {
            this.fail((Exception)((Object)e), "prime meridian");
        }
        try {
            Ellipsoid el = this.model.getDefaultObject(Ellipsoid.class, null);
            PrimeMeridian pm = this.model.getDefaultObject(PrimeMeridian.class, null);
            o = this.model.createGeodeticDatum("Custom", el, pm);
            System.out.println(o.getEllipsoid().getName().getCode());
        }
        catch (FactoryException e) {
            this.fail((Exception)((Object)e), "geodetic datum");
        }
        try {
            GeodeticDatum gd = this.model.getDefaultObject(GeodeticDatum.class, null);
            cs = this.model.getDefaultObject(EllipsoidalCS.class, null);
            o = this.model.createGeographicCRS("Custom", gd, cs);
            System.out.println(o.toWKT());
        }
        catch (FactoryException e) {
            this.fail((Exception)((Object)e), "geographic CRS");
        }
        try {
            CoordinateSystemAxis axis1 = this.model.createCoordinateSystemAxis("Custom", "EAST", AxisDirection.EAST, ang);
            CoordinateSystemAxis axis2 = this.model.createCoordinateSystemAxis("Custom", "NORTH", AxisDirection.NORTH, ang);
            EllipsoidalCS eCS = this.model.createEllipsoidalCS("Custom", axis1, axis2);
            axis1 = this.model.createCoordinateSystemAxis("Custom", "Right", AxisDirection.DISPLAY_RIGHT, lin);
            axis2 = this.model.createCoordinateSystemAxis("Custom", "Up", AxisDirection.DISPLAY_UP, lin);
            CartesianCS cCS = this.model.createCartesianCS("Custom", axis1, axis2);
            System.out.println(eCS.getAxis(1).getDirection().name());
            System.out.println(cCS.getAxis(1).getDirection().name());
        }
        catch (FactoryException e) {
            this.fail((Exception)((Object)e), "coordinate system or axis");
        }
        try {
            GeographicCRS crs = this.model.getDefaultObject(GeographicCRS.class, null);
            cs = this.model.getDefaultObject(CartesianCS.class, null);
            Conversion conv = this.model.getDefaultObject(Conversion.class, null);
            ProjectedCRS o3 = this.model.createProjectedCRS("Custom", crs, (CartesianCS)cs, conv);
            System.out.println(o3.toWKT());
        }
        catch (FactoryException e) {
            this.fail((Exception)((Object)e), "projected CRS");
        }
    }

    protected void fail(Exception e, String className) {
        e.printStackTrace();
        JUnit_CRSModel.fail((String)("Factory exception thrown creating " + className + " from parameters."));
    }
}

