/*
 * Decompiled with CFR 0.152.
 */
package test.crs;

import java.util.List;
import javax.units.Unit;
import junit.framework.TestCase;
import org.geowidgets.units.model.EPSG_UnitModel;
import org.geowidgets.units.model.IUnitModel;
import org.geowidgets.units.model.Units_UnitModel;

public class JUnit_UnitModels
extends TestCase {
    IUnitModel epsgModel;
    IUnitModel unitModel;

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("************************************");
        try {
            this.epsgModel = EPSG_UnitModel.getDefault();
            this.unitModel = Units_UnitModel.getDefault();
        }
        catch (Exception e) {
            JUnit_UnitModels.fail((String)"Error creating models");
        }
    }

    public void testGetDefault() {
        JUnit_UnitModels.assertNotNull((String)"EPSG unit model is null.", (Object)this.epsgModel);
        JUnit_UnitModels.assertNotNull((String)"Units unit model is null.", (Object)this.unitModel);
    }

    public void testGetSupportedUnits() {
        List<String> epsglist1 = this.epsgModel.getSupportedUnits(-1);
        List<String> epsglist2 = this.epsgModel.getSupportedUnits(0);
        List<String> epsglist3 = this.epsgModel.getSupportedUnits(1);
        List<String> unitslist1 = this.unitModel.getSupportedUnits(-1);
        List<String> unitslist2 = this.unitModel.getSupportedUnits(0);
        List<String> unitslist3 = this.unitModel.getSupportedUnits(1);
        String err = "List of supported units cannot be null or empty.";
        JUnit_UnitModels.assertTrue((String)err, (boolean)(epsglist1 != null & epsglist1.size() != 0));
        JUnit_UnitModels.assertTrue((String)err, (boolean)(epsglist2 != null & epsglist2.size() != 0));
        JUnit_UnitModels.assertTrue((String)err, (boolean)(epsglist3 != null & epsglist3.size() != 0));
        JUnit_UnitModels.assertTrue((String)err, (boolean)(unitslist1 != null & unitslist1.size() != 0));
        JUnit_UnitModels.assertTrue((String)err, (boolean)(unitslist2 != null & unitslist2.size() != 0));
        JUnit_UnitModels.assertTrue((String)err, (boolean)(unitslist3 != null & unitslist3.size() != 0));
        JUnit_UnitModels.assertTrue((String)"Total units >= Angular + Linear units", (epsglist1.size() >= epsglist2.size() + epsglist3.size() ? 1 : 0) != 0);
        JUnit_UnitModels.assertTrue((String)"Total units >= Angular + Linear units", (unitslist1.size() >= unitslist2.size() + unitslist3.size() ? 1 : 0) != 0);
        System.out.println("Supported objects returned (all/linear/angular):");
        System.out.println("  EPSG: " + epsglist1.size() + "/" + epsglist2.size() + "/" + epsglist3.size());
        System.out.println("  Units: " + unitslist1.size() + "/" + unitslist2.size() + "/" + unitslist3.size());
    }

    public void testGetDefaultUnit() {
        String defEPSG = this.epsgModel.getDefaultUnit(-1);
        String defEPSG_L = this.epsgModel.getDefaultUnit(0);
        String defEPSG_A = this.epsgModel.getDefaultUnit(1);
        String defUnits = this.unitModel.getDefaultUnit(-1);
        String defUnits_L = this.unitModel.getDefaultUnit(0);
        String defUnits_A = this.unitModel.getDefaultUnit(1);
        String err = "Default unit must not be null or empty.";
        JUnit_UnitModels.assertTrue((String)err, (defEPSG != null && !defEPSG.equals("") ? 1 : 0) != 0);
        JUnit_UnitModels.assertTrue((String)err, (defEPSG_L != null && !defEPSG_L.equals("") ? 1 : 0) != 0);
        JUnit_UnitModels.assertTrue((String)err, (defEPSG_A != null && !defEPSG_A.equals("") ? 1 : 0) != 0);
        JUnit_UnitModels.assertTrue((String)err, (defUnits != null && !defUnits.equals("") ? 1 : 0) != 0);
        JUnit_UnitModels.assertTrue((String)err, (defUnits_L != null && !defUnits_L.equals("") ? 1 : 0) != 0);
        JUnit_UnitModels.assertTrue((String)err, (defUnits_A != null && !defUnits_A.equals("") ? 1 : 0) != 0);
        System.out.println("Default unit's names (all/linear/angular):");
        System.out.println("  EPSG: " + defEPSG + "/" + defEPSG_L + "/" + defEPSG_A);
        System.out.println("  Units: " + defUnits + "/" + defUnits_L + "/" + defUnits_A);
    }

    public void testGetUnit() {
        try {
            Unit u1 = this.epsgModel.getUnit(this.epsgModel.getDefaultUnit(-1));
            Unit u2 = this.epsgModel.getUnit(this.epsgModel.getDefaultUnit(0));
            Unit u3 = this.epsgModel.getUnit(this.epsgModel.getDefaultUnit(1));
            Unit u4 = this.unitModel.getUnit(this.unitModel.getDefaultUnit(-1));
            Unit u5 = this.unitModel.getUnit(this.unitModel.getDefaultUnit(0));
            Unit u6 = this.unitModel.getUnit(this.unitModel.getDefaultUnit(1));
            String err = "Default unit was not instantiated.";
            JUnit_UnitModels.assertNotNull((String)err, (Object)u1);
            JUnit_UnitModels.assertNotNull((String)err, (Object)u2);
            JUnit_UnitModels.assertNotNull((String)err, (Object)u3);
            JUnit_UnitModels.assertNotNull((String)err, (Object)u4);
            JUnit_UnitModels.assertNotNull((String)err, (Object)u5);
            JUnit_UnitModels.assertNotNull((String)err, (Object)u6);
            System.out.println("Default created unit's abbreviations (all/linear/angular):");
            System.out.println("  EPSG: " + u1 + "/" + u2 + "/" + u3);
            System.out.println("  Units: " + u4 + "/" + u5 + "/" + u6);
        }
        catch (Exception e) {
            e.printStackTrace();
            JUnit_UnitModels.fail();
        }
    }
}

