/*
 * Decompiled with CFR 0.152.
 */
package test.crs;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geowidgets.crs.model.ICRSModel;
import org.geowidgets.crs.widgets.propertysheet.CRSElementPropertyViewer;
import org.geowidgets.framework.GWFactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.ProjectedCRS;

public class Test_PropertyCRSElementWidget
extends Window {
    static /* synthetic */ Class class$0;

    public Test_PropertyCRSElementWidget() {
        super(new Shell());
    }

    public static void main(String[] args) {
        Test_PropertyCRSElementWidget test = new Test_PropertyCRSElementWidget();
        test.setBlockOnOpen(true);
        test.open();
        Display.getCurrent().dispose();
    }

    public Control createContents(Composite parent) {
        parent.getShell().setSize(300, 500);
        parent.getShell().setLocation(10, 100);
        parent.getShell().setText("CRS property view test");
        parent.setLayout((Layout)new FillLayout());
        try {
            this.checkPCRS(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parent;
    }

    protected void checkEllipsoid(Composite parent) {
        DefaultEllipsoid el = DefaultEllipsoid.WGS84;
        CRSElementPropertyViewer<DefaultEllipsoid> tree = new CRSElementPropertyViewer<DefaultEllipsoid>(parent, 0, el);
    }

    protected void checkPrimeMeridian(Composite parent) {
        DefaultPrimeMeridian pm = DefaultPrimeMeridian.GREENWICH;
        CRSElementPropertyViewer<DefaultPrimeMeridian> tree = new CRSElementPropertyViewer<DefaultPrimeMeridian>(parent, 0, pm);
    }

    protected void checkDatum(Composite parent) {
        DefaultGeodeticDatum gd = DefaultGeodeticDatum.WGS84;
        CRSElementPropertyViewer<DefaultGeodeticDatum> tree = new CRSElementPropertyViewer<DefaultGeodeticDatum>(parent, 0, gd);
    }

    protected void checkGCRS(Composite parent) {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        CRSElementPropertyViewer<DefaultGeographicCRS> tree = new CRSElementPropertyViewer<DefaultGeographicCRS>(parent, 0, crs);
    }

    protected void checkPCRS(Composite parent) {
        try {
            ICRSModel crsModel = GWFactoryFinder.getCRSModel();
            ProjectedCRS crs = crsModel.getDefaultObject(ProjectedCRS.class, "2D");
            CRSElementPropertyViewer<ProjectedCRS> tree = new CRSElementPropertyViewer<ProjectedCRS>(parent, 0, crs);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }
}

