/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.util.Range;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.Decimator;
import org.geotools.renderer.lite.FIDFilterFinder;
import org.geotools.renderer.lite.IndexedFeatureResults;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheDefault;
import org.geotools.renderer.lite.ListenerList;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.SymbolizerAssociation;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.CRSUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public final class StreamingRenderer
implements GTRenderer {
    private static final int defaultMaxFiltersToSendToDatastore = 5;
    public static final String SCALE_ACCURATE = "ACCURATE";
    public static final String SCALE_OGC = "OGC";
    public IdentityHashMap symbolizerAssociationHT = new IdentityHashMap();
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER;
    int error = 0;
    private static final FilterFactory filterFactory;
    private MapContext context;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private ReferencedEnvelope mapExtent;
    private Rectangle screenSize;
    private boolean renderingStopRequested = false;
    private double scaleDenominator;
    private double generalizationDistance = 1.0;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    protected LabelCache labelCache = new LabelCacheDefault();
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private IndexedFeatureResults indexedFeatureResults;
    private ListenerList renderListeners = new ListenerList();
    private RenderingHints java2dHints;
    private boolean optimizedDataLoadingEnabledDEFAULT = false;
    private boolean memoryPreloadingEnabledDEFAULT = false;
    private int renderingBufferDEFAULT = 0;
    private String scaleComputationMethodDEFAULT = "OGC";
    private Map rendererHints = null;
    private AffineTransform worldToScreenTransform = null;
    private CoordinateReferenceSystem destinationCrs;
    private boolean canTransform;
    private HashMap decimators = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Feature feature) {
        Object[] objects = this.renderListeners.getListeners();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.featureRenderer(feature);
        }
    }

    private void fireErrorEvent(Exception e) {
        Object[] objects = this.renderListeners.getListeners();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.errorOccurred(e);
        }
    }

    public void stopRendering() {
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            Envelope mapArea = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.fireErrorEvent(new Exception("Can't create pixel to world transform", e));
        }
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea, AffineTransform worldToScreen) {
        if (this.context == null) {
            throw new IllegalStateException("Cannot perform paint, no map context has been assigned to the renderer.");
        }
        if (graphics == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        if (mapArea == null && paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        if (mapArea == null) {
            try {
                mapArea = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
            }
            catch (NoninvertibleTransformException e) {
                LOGGER.info("renderer passed null arguments");
                return;
            }
        } else if (worldToScreen == null) {
            worldToScreen = RendererUtilities.worldToScreenTransform(mapArea, paintArea);
        }
        this.error = 0;
        if (this.java2dHints != null) {
            graphics.setRenderingHints(this.java2dHints);
        }
        this.renderingStopRequested = false;
        AffineTransform at = worldToScreen;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Affine Transform is " + at);
        }
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(at);
            at = atg;
        }
        CoordinateReferenceSystem destinationCrs = this.context.getCoordinateReferenceSystem();
        this.mapExtent = new ReferencedEnvelope(mapArea, destinationCrs);
        this.scaleDenominator = this.computeScale(this.mapExtent, paintArea, this.rendererHints);
        int buffer = this.getRenderingBuffer();
        if (buffer > 0) {
            this.mapExtent = new ReferencedEnvelope(this.expandEnvelope(this.mapExtent, worldToScreen, buffer), this.mapExtent.getCoordinateReferenceSystem());
        }
        this.labelCache.start();
        MapLayer[] layers = this.context.getLayers();
        int layersNumber = layers.length;
        for (int i = 0; i < layersNumber; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.renderingStopRequested) {
                return;
            }
            this.labelCache.startLayer();
            try {
                this.screenSize = paintArea;
                this.processStylers(graphics, currLayer, at, destinationCrs, mapArea, paintArea);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                this.fireErrorEvent(new Exception("Exception rendering layer " + currLayer, t));
            }
            this.labelCache.endLayer(graphics, this.screenSize);
        }
        this.labelCache.end(graphics, paintArea);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Style cache hit ratio: " + this.styleFactory.getHitRatio() + " , hits " + this.styleFactory.getHits() + ", requests " + this.styleFactory.getRequests());
        }
        if (this.error > 0) {
            LOGGER.warning("Number of Errors during paint(Graphics2D, AffineTransform) = " + this.error);
        }
    }

    private double computeScale(ReferencedEnvelope envelope, Rectangle paintArea, Map hints) {
        if (this.getScaleComputationMethod().equals(SCALE_ACCURATE)) {
            try {
                return RendererUtilities.calculateScale(envelope, paintArea.width, paintArea.height, hints);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return RendererUtilities.calculateOGCScale(envelope, paintArea.width, hints);
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea, AffineTransform worldToScreen) {
        if (graphics == null || paintArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (mapArea == null && paintArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (mapArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (worldToScreen == null && (worldToScreen = RendererUtilities.worldToScreenTransform(mapArea, paintArea)) == null) {
            return;
        }
        this.destinationCrs = mapArea.getCoordinateReferenceSystem();
        this.mapExtent = new ReferencedEnvelope(mapArea);
        this.screenSize = paintArea;
        this.worldToScreenTransform = worldToScreen;
        this.error = 0;
        if (this.java2dHints != null) {
            graphics.setRenderingHints(this.java2dHints);
        }
        this.renderingStopRequested = false;
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(this.worldToScreenTransform);
            this.worldToScreenTransform = atg;
            graphics.setTransform(this.worldToScreenTransform);
        }
        this.scaleDenominator = this.computeScale(mapArea, paintArea, this.rendererHints);
        int buffer = this.getRenderingBuffer();
        if (buffer > 0) {
            this.mapExtent = new ReferencedEnvelope(this.expandEnvelope(this.mapExtent, worldToScreen, buffer), this.mapExtent.getCoordinateReferenceSystem());
        }
        MapLayer[] layers = this.context.getLayers();
        this.labelCache.start();
        int layersNumber = layers.length;
        for (int i = 0; i < layersNumber; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.renderingStopRequested) {
                return;
            }
            this.labelCache.startLayer();
            try {
                this.processStylers(graphics, currLayer, this.worldToScreenTransform, this.destinationCrs, this.mapExtent, this.screenSize);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                this.fireErrorEvent(new Exception("Exception rendering layer " + currLayer, t));
            }
            this.labelCache.endLayer(graphics, this.screenSize);
        }
        this.labelCache.end(graphics, paintArea);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Style cache hit ratio: " + this.styleFactory.getHitRatio() + " , hits " + this.styleFactory.getHits() + ", requests " + this.styleFactory.getRequests());
        }
        if (this.error > 0) {
            LOGGER.warning("Number of Errors during paint(Graphics2D, AffineTransform) = " + this.error);
        }
    }

    private Envelope expandEnvelope(Envelope envelope, AffineTransform worldToScreen, int buffer) {
        if (!$assertionsDisabled && buffer <= 0) {
            throw new AssertionError();
        }
        double bufferX = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleX0((AffineTransform)worldToScreen));
        double bufferY = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleY0((AffineTransform)worldToScreen));
        return new Envelope(envelope.getMinX() - bufferX, envelope.getMaxX() + bufferX, envelope.getMinY() - bufferY, envelope.getMaxY() + bufferY);
    }

    FeatureResults queryLayer(MapLayer currLayer, FeatureSource source, FeatureType schema, LiteFeatureTypeStyle[] styles, Envelope mapArea, CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem featCrs, Rectangle screenSize, GeometryAttributeType geometryAttribute, AffineTransform worldToScreenTransform) throws IllegalFilterException, IOException, IllegalAttributeException {
        Query definitionQuery;
        int buffer;
        Object results = null;
        DefaultQuery query = new DefaultQuery(DefaultQuery.ALL);
        MathTransform transform = null;
        Filter filter = null;
        if (this.getRenderingBuffer() == 0 && (buffer = this.findRenderingBuffer(styles)) > 0) {
            mapArea = this.expandEnvelope(mapArea, worldToScreenTransform, buffer);
            LOGGER.fine("Expanding rendering area by " + buffer + " pixels to consider stroke width");
        }
        ReferencedEnvelope envelope = new ReferencedEnvelope(mapArea, mapCRS);
        if (this.isOptimizedDataLoadingEnabled()) {
            String[] attributes;
            if (styles == null) {
                AttributeType[] ats = schema.getAttributeTypes();
                int length = ats.length;
                attributes = new String[length];
                for (int t = 0; t < length; ++t) {
                    attributes[t] = ats[t].getName();
                }
            } else {
                attributes = this.findStyleAttributes(styles, schema);
            }
            try {
                if (mapCRS != null && featCrs != null && !CRSUtilities.equalsIgnoreMetadata((Object)featCrs, (Object)mapCRS)) {
                    transform = StreamingRenderer.getMathTransform(mapCRS, featCrs);
                    if (transform != null && !transform.isIdentity()) {
                        envelope = new ReferencedEnvelope(JTS.transform(mapArea, null, transform, 10), featCrs);
                    } else {
                        transform = null;
                    }
                }
                if (!this.isMemoryPreloadingEnabled()) {
                    BBoxExpression rightBBox = filterFactory.createBBoxExpression((Envelope)envelope);
                    filter = this.createBBoxFilters(schema, attributes, rightBBox);
                } else {
                    filter = Filter.NONE;
                }
                query = new DefaultQuery(schema.getTypeName());
                query.setFilter(filter);
                query.setPropertyNames(attributes);
                this.processRuleForQuery(styles, query);
            }
            catch (Exception e) {
                this.fireErrorEvent(new Exception("Error transforming bbox", e));
                this.canTransform = false;
                query = new DefaultQuery(schema.getTypeName());
                query.setPropertyNames(attributes);
                Envelope bounds = source.getBounds();
                if (bounds != null && envelope.intersects(bounds)) {
                    LOGGER.fine("Got a tranform exception while trying to de-project the current " + "envelope, bboxs intersect therefore using envelope)");
                    filter = null;
                    BBoxExpression rightBBox = filterFactory.createBBoxExpression((Envelope)envelope);
                    filter = this.createBBoxFilters(schema, attributes, rightBBox);
                    query.setFilter(filter);
                } else {
                    LOGGER.fine("Got a tranform exception while trying to de-project the current " + "envelope, falling back on full data loading (no bbox query)");
                    query.setFilter(Filter.NONE);
                }
                this.processRuleForQuery(styles, query);
            }
        }
        if ((definitionQuery = currLayer.getQuery()) != Query.ALL) {
            query = query == Query.ALL ? new DefaultQuery(definitionQuery) : new DefaultQuery(DataUtilities.mixQueries(definitionQuery, query, "liteRenderer"));
        }
        query.setCoordinateSystem(featCrs);
        if (this.isMemoryPreloadingEnabled()) {
            if (this.indexedFeatureResults == null) {
                this.indexedFeatureResults = new IndexedFeatureResults((FeatureResults)source.getFeatures((Query)query));
            }
            this.indexedFeatureResults.setQueryBounds(envelope);
            results = this.indexedFeatureResults;
        } else {
            results = source.getFeatures((Query)query);
        }
        return results;
    }

    private boolean doesntHaveFIDFilter(Query query) {
        FIDFilterFinder finder = new FIDFilterFinder();
        finder.visit(query.getFilter());
        return !finder.hasFIDFilter;
    }

    private void processRuleForQuery(LiteFeatureTypeStyle[] styles, DefaultQuery q) {
        block11: {
            try {
                Filter ruleFiltersCombined;
                int maxFilters = this.getMaxFiltersToSendToDatastore();
                ArrayList<Filter> filtersToDS = new ArrayList<Filter>();
                boolean actualFilters = false;
                int stylesLength = styles.length;
                int u = 0;
                if (stylesLength > maxFilters) {
                    return;
                }
                for (int t = 0; t < stylesLength; ++t) {
                    LiteFeatureTypeStyle style = styles[t];
                    int styleElseRulesLength = style.elseRules.length;
                    int styleRulesLength = style.ruleList.length;
                    if (styleElseRulesLength > 0) {
                        return;
                    }
                    for (u = 0; u < styleRulesLength; ++u) {
                        Rule r = style.ruleList[u];
                        if (r.getFilter() == null) {
                            return;
                        }
                        filtersToDS.add(r.getFilter());
                    }
                }
                if (0 > maxFilters) {
                    return;
                }
                if (filtersToDS.size() == 1) {
                    ruleFiltersCombined = (Filter)filtersToDS.get(0);
                } else {
                    ruleFiltersCombined = (Filter)filtersToDS.get(0);
                    int size = filtersToDS.size();
                    for (int t = 1; t < size; ++t) {
                        Filter newFilter = (Filter)filtersToDS.get(t);
                        ruleFiltersCombined = filterFactory.createLogicFilter(ruleFiltersCombined, newFilter, (short)1);
                    }
                }
                ruleFiltersCombined = filterFactory.createLogicFilter(q.getFilter(), ruleFiltersCombined, (short)2);
                q.setFilter(ruleFiltersCombined);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block11;
                LOGGER.log(Level.SEVERE, "Could not send rules to datastore due to: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private int getMaxFiltersToSendToDatastore() {
        try {
            Integer result = (Integer)this.rendererHints.get("maxFiltersToSendToDatastore");
            if (result == null) {
                return 5;
            }
            return result;
        }
        catch (Exception e) {
            return 5;
        }
    }

    private boolean isMemoryPreloadingEnabled() {
        if (this.rendererHints == null) {
            return this.memoryPreloadingEnabledDEFAULT;
        }
        Object result = null;
        try {
            result = this.rendererHints.get("memoryPreloadingEnabled");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (result == null) {
            return this.memoryPreloadingEnabledDEFAULT;
        }
        return result;
    }

    private int findRenderingBuffer(LiteFeatureTypeStyle[] styles) {
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        for (int t = 0; t < styles.length; ++t) {
            int j;
            LiteFeatureTypeStyle lfts = styles[t];
            Rule[] rules = lfts.elseRules;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
            rules = lfts.ruleList;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
        }
        if (!rbe.isEstimateAccurate()) {
            LOGGER.warning("Assuming rendering buffer = " + rbe.getBuffer() + ", but estimation is not accurate, you may want to set a buffer manually");
        }
        return rbe.getBuffer();
    }

    private String[] findStyleAttributes(LiteFeatureTypeStyle[] styles, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        int length = styles.length;
        for (int t = 0; t < length; ++t) {
            int j;
            LiteFeatureTypeStyle lfts = styles[t];
            Rule[] rules = lfts.elseRules;
            int rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
            rules = lfts.ruleList;
            rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
        }
        String[] ftsAttributes = sae.getAttributeNames();
        LinkedList<String> atts = new LinkedList<String>(Arrays.asList(ftsAttributes));
        AttributeType[] attTypes = schema.getAttributeTypes();
        int attTypesLength = attTypes.length;
        for (int i = 0; i < attTypesLength; ++i) {
            String attName = attTypes[i].getName();
            if ((!attName.equalsIgnoreCase("grid") || atts.contains(attName)) && (!attName.equalsIgnoreCase("params") || atts.contains(attName))) continue;
            atts.add(attName);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("added attribute " + attName);
        }
        try {
            if (sae.getDefaultGeometryUsed() && !atts.contains(schema.getDefaultGeometry().getName())) {
                atts.add(schema.getDefaultGeometry().getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ftsAttributes = new String[atts.size()];
        atts.toArray(ftsAttributes);
        return ftsAttributes;
    }

    private Filter createBBoxFilters(FeatureType schema, String[] attributes, BBoxExpression bbox) throws IllegalFilterException {
        Object filter = null;
        int length = attributes.length;
        for (int j = 0; j < length; ++j) {
            AttributeType attType = schema.getAttributeType(attributes[j]);
            if (attType == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Could not find '" + attributes[j] + "' in the FeatureType (" + schema.getTypeName() + ")");
                }
                throw new IllegalFilterException("Could not find '" + (attributes[j] + "' in the FeatureType (") + schema.getTypeName() + ")");
            }
            if (!(attType instanceof GeometryAttributeType)) continue;
            GeometryFilter gfilter = filterFactory.createGeometryFilter((short)4);
            AttributeExpression left = filterFactory.createAttributeExpression(schema, attType.getName());
            gfilter.addLeftGeometry((Expression)left);
            gfilter.addRightGeometry((Expression)bbox);
            filter = filter == null ? gfilter : filter.or((Filter)gfilter);
        }
        return filter;
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    private ArrayList createLiteFeatureTypeStyles(FeatureTypeStyle[] featureStyles, FeatureType ftype, Graphics2D graphics) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("creating rules for scale denominator - " + NumberFormat.getNumberInstance().format(this.scaleDenominator));
        }
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        int itemNumber = 0;
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        String typeName = ftype.getTypeName();
        int length = featureStyles.length;
        for (int i = 0; i < length; ++i) {
            LiteFeatureTypeStyle lfts;
            FeatureTypeStyle fts = featureStyles[i];
            if (typeName == null || !ftype.isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ruleList = new ArrayList();
            elseRuleList = new ArrayList();
            int numOfRules = rules.length;
            for (int j = 0; j < numOfRules; ++j) {
                Rule r = rules[j];
                if (!this.isWithInScale(r)) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
            if (itemNumber == 0) {
                lfts = new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList);
            } else {
                BufferedImage image = graphics.getDeviceConfiguration().createCompatibleImage(this.screenSize.width, this.screenSize.height, 3);
                lfts = new LiteFeatureTypeStyle(image, graphics.getTransform(), ruleList, elseRuleList, this.java2dHints);
            }
            result.add(lfts);
            ++itemNumber;
        }
        return result;
    }

    private FeatureReader getReader(FeatureResults features, CoordinateReferenceSystem sourceCrs) throws IOException {
        FeatureReader reader = features.reader();
        CoordinateReferenceSystem rCS = reader.getFeatureType().getDefaultGeometry().getCoordinateSystem();
        if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && rCS.equals(sourceCrs))) {
            try {
                reader = new ForceCoordinateSystemFeatureReader(reader, sourceCrs);
            }
            catch (Exception ee) {
                LOGGER.log(Level.WARNING, ee.getLocalizedMessage(), ee);
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processStylers(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, Envelope mapArea, Rectangle screenSize) throws IllegalFilterException, IOException, IllegalAttributeException {
        LiteFeatureTypeStyle[] fts_array;
        int n_lfts;
        block14: {
            FeatureTypeStyle[] featureStylers = currLayer.getStyle().getFeatureTypeStyles();
            FeatureSource source = currLayer.getFeatureSource();
            FeatureType schema = source.getSchema();
            GeometryAttributeType geometryAttribute = schema.getDefaultGeometry();
            CoordinateReferenceSystem sourceCrs = geometryAttribute.getCoordinateSystem();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("processing " + featureStylers.length + " stylers for " + currLayer.getFeatureSource().getSchema().getTypeName());
            }
            NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
            this.symbolizerAssociationHT = new IdentityHashMap();
            ArrayList lfts = this.createLiteFeatureTypeStyles(featureStylers, schema, graphics);
            if (lfts.size() == 0) {
                return;
            }
            FeatureResults features = this.queryLayer(currLayer, source, schema, lfts.toArray(new LiteFeatureTypeStyle[lfts.size()]), mapArea, destinationCrs, sourceCrs, screenSize, geometryAttribute, at);
            FeatureReader reader = this.getReader(features, sourceCrs);
            n_lfts = lfts.size();
            fts_array = lfts.toArray(new LiteFeatureTypeStyle[n_lfts]);
            try {
                int t = 0;
                while (true) {
                    try {
                        block7: while (true) {
                            if (this.renderingStopRequested) {
                                break block14;
                            }
                            if (!reader.hasNext()) {
                                break block14;
                            }
                            Feature feature = reader.next();
                            t = 0;
                            while (true) {
                                if (t >= n_lfts) continue block7;
                                this.process(feature, fts_array[t], (Range)scaleRange, at, destinationCrs);
                                ++t;
                            }
                            break;
                        }
                    }
                    catch (OutOfMemoryError oom) {
                        throw oom;
                    }
                    catch (Throwable tr) {
                        LOGGER.log(Level.SEVERE, tr.getLocalizedMessage(), tr);
                        this.fireErrorEvent(new Exception("Error rendering feature", tr));
                        continue;
                    }
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        for (int t = 0; t < n_lfts; ++t) {
            if (fts_array[t].myImage == null) continue;
            graphics.drawImage((Image)fts_array[t].myImage, 0, 0, null);
            fts_array[t].myImage.flush();
            fts_array[t].graphics.dispose();
        }
    }

    private final void process(Feature feature, LiteFeatureTypeStyle style, Range scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs) throws TransformException, FactoryException {
        Symbolizer[] symbolizers;
        Rule r;
        boolean doElse = true;
        Rule[] elseRuleList = style.elseRules;
        Rule[] ruleList = style.ruleList;
        Graphics2D graphics = style.graphics;
        int length = ruleList.length;
        for (int t = 0; t < length; ++t) {
            r = ruleList[t];
            Filter filter = r.getFilter();
            if (filter != null && !filter.contains(feature)) continue;
            doElse = false;
            symbolizers = r.getSymbolizers();
            this.processSymbolizers(graphics, feature, symbolizers, scaleRange, at, destinationCrs);
        }
        if (doElse) {
            int elseLength = elseRuleList.length;
            for (int tt = 0; tt < elseLength; ++tt) {
                r = elseRuleList[tt];
                symbolizers = r.getSymbolizers();
                this.processSymbolizers(graphics, feature, symbolizers, scaleRange, at, destinationCrs);
            }
        }
    }

    private final void processSymbolizers(Graphics2D graphics, Feature feature, Symbolizer[] symbolizers, Range scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs) throws TransformException, FactoryException {
        MathTransform2D transform = null;
        int length = symbolizers.length;
        for (int m = 0; m < length; ++m) {
            LiteShape2 shape;
            if (symbolizers[m] instanceof RasterSymbolizer) {
                this.renderRaster(graphics, feature, (RasterSymbolizer)symbolizers[m], destinationCrs, scaleRange);
                continue;
            }
            Geometry g = this.findGeometry(feature, symbolizers[m]);
            SymbolizerAssociation sa = (SymbolizerAssociation)this.symbolizerAssociationHT.get(symbolizers[m]);
            if (sa == null) {
                sa = new SymbolizerAssociation();
                sa.setCRS(this.findGeometryCS(feature, symbolizers[m]));
                try {
                    transform = sa.crs == null || CRSUtilities.equalsIgnoreMetadata((Object)sa.crs, (Object)destinationCrs) ? null : (MathTransform2D)StreamingRenderer.getMathTransform(sa.crs, destinationCrs);
                    transform = transform != null && !transform.isIdentity() ? (MathTransform2D)ConcatenatedTransform.create((MathTransform)transform, (MathTransform)ProjectiveTransform.create((AffineTransform)at)) : (MathTransform2D)ProjectiveTransform.create((AffineTransform)at);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                sa.setXform(transform);
                this.symbolizerAssociationHT.put(symbolizers[m], sa);
            }
            try {
                shape = this.getTransformedShape(g, sa.getXform());
            }
            catch (TransformException te) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                this.fireErrorEvent((Exception)((Object)te));
                continue;
            }
            catch (AssertionError ae) {
                LOGGER.log(Level.FINE, ((Throwable)((Object)ae)).getLocalizedMessage(), (Throwable)((Object)ae));
                this.fireErrorEvent(new RuntimeException((Throwable)((Object)ae)));
                continue;
            }
            if (symbolizers[m] instanceof TextSymbolizer) {
                this.labelCache.put((TextSymbolizer)symbolizers[m], feature, shape, scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
            this.painter.paint(graphics, shape, style, this.scaleDenominator);
        }
        this.fireFeatureRenderedEvent(feature);
    }

    private final LiteShape2 getTransformedShape(Geometry g, MathTransform2D transform) throws TransformException, FactoryException {
        return new LiteShape2(g, (MathTransform)transform, this.getDecimator(transform), false);
    }

    private Decimator getDecimator(MathTransform2D mathTransform) throws org.opengis.referencing.operation.NoninvertibleTransformException {
        Decimator decimator = (Decimator)this.decimators.get(mathTransform);
        if (decimator == null) {
            decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator(mathTransform.inverse(), this.screenSize) : new Decimator(null, this.screenSize);
            this.decimators.put(mathTransform, decimator);
        }
        return decimator;
    }

    private void renderRaster(Graphics2D graphics, Feature feature, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS, Range scaleRange) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("rendering Raster for feature " + feature.toString() + " - " + feature.getAttribute("grid"));
        }
        try {
            Object grid = feature.getAttribute("grid");
            GridCoverageRenderer gcr = new GridCoverageRenderer(destinationCRS, this.mapExtent, this.screenSize, this.java2dHints);
            if (grid instanceof GridCoverage) {
                gcr.paint(graphics, (GridCoverage2D)grid, symbolizer);
            } else if (grid instanceof AbstractGridCoverage2DReader) {
                GridCoverage2D coverage;
                Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
                readGG.setValue((Object)new GridGeometry2D((GridRange)new GeneralGridRange(this.screenSize), (org.opengis.spatialschema.geometry.Envelope)this.mapExtent));
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)grid;
                Object params = feature.getAttribute("params");
                if (params != null) {
                    GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
                    int length = readParams.length;
                    if (length > 0) {
                        int i;
                        String name = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
                        for (i = 0; i < length && !readParams[i].getDescriptor().getName().toString().equalsIgnoreCase(name); ++i) {
                        }
                        if (i < length) {
                            ((Parameter)readParams[i]).setValue((Object)readGG);
                            coverage = (GridCoverage2D)reader.read(readParams);
                        } else {
                            GeneralParameterValue[] readParams2 = new GeneralParameterValue[length + 1];
                            System.arraycopy(readParams, 0, readParams2, 0, length);
                            readParams2[length] = readGG;
                            coverage = (GridCoverage2D)reader.read(readParams2);
                        }
                    } else {
                        coverage = (GridCoverage2D)reader.read(new GeneralParameterValue[]{readGG});
                    }
                } else {
                    coverage = (GridCoverage2D)reader.read(new GeneralParameterValue[]{readGG});
                }
                gcr.paint(graphics, coverage, symbolizer);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Raster rendered");
            }
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent((Exception)((Object)e));
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent((Exception)((Object)e));
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent(e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent(e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.fireErrorEvent(e);
        }
    }

    private GeneralEnvelope handleTileBordersArtifacts(ReferencedEnvelope mapExtent, RenderingHints java2dHints, AffineTransform worldToScreen) {
        if (!java2dHints.containsKey(JAI.KEY_INTERPOLATION)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find interpolation for this request.");
            }
            return new GeneralEnvelope((org.opengis.spatialschema.geometry.Envelope)mapExtent);
        }
        Interpolation interp = (Interpolation)java2dHints.get(JAI.KEY_INTERPOLATION);
        int buffer = 0;
        if (interp instanceof InterpolationNearest) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Interpolation Nearest no need for extending.");
            }
            return new GeneralEnvelope((org.opengis.spatialschema.geometry.Envelope)mapExtent);
        }
        if (interp instanceof InterpolationBilinear) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Interpolation Bilinear  extending.by 1 pixel at least");
            }
            buffer = 10;
        } else if (interp instanceof InterpolationBicubic) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Interpolation Bicubic  extending.by 2 pixel at least");
            }
            buffer = 30;
        }
        if (buffer <= 0) {
            return new GeneralEnvelope((org.opengis.spatialschema.geometry.Envelope)mapExtent);
        }
        Envelope tempEnv = this.expandEnvelope(mapExtent, worldToScreen, buffer);
        GeneralEnvelope newEnv = new GeneralEnvelope(new double[]{tempEnv.getMinX(), tempEnv.getMinY()}, new double[]{tempEnv.getMaxX(), tempEnv.getMaxY()});
        newEnv.setCoordinateReferenceSystem(mapExtent.getCoordinateReferenceSystem());
        return newEnv;
    }

    private Geometry findGeometry(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        Geometry geom = geomName == null ? f.getDefaultGeometry() : (Geometry)f.getAttribute(geomName);
        if (s instanceof PointSymbolizer) {
            geom = this.getCentroid(geom);
        }
        return geom;
    }

    private Geometry getCentroid(Geometry g) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            int length = gc.getNumGeometries();
            for (int t = 0; t < length; ++t) {
                pts[t] = gc.getGeometryN(t).getCentroid().getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        return g.getCentroid();
    }

    private CoordinateReferenceSystem findGeometryCS(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        if (geomName != null) {
            return ((GeometryAttributeType)f.getFeatureType().getAttributeType(geomName)).getCoordinateSystem();
        }
        return f.getFeatureType().getDefaultGeometry().getCoordinateSystem();
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private boolean isOptimizedDataLoadingEnabled() {
        if (this.rendererHints == null) {
            return this.optimizedDataLoadingEnabledDEFAULT;
        }
        Object result = null;
        try {
            result = this.rendererHints.get("optimizedDataLoadingEnabled");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (result == null) {
            return this.optimizedDataLoadingEnabledDEFAULT;
        }
        return result;
    }

    private int getRenderingBuffer() {
        if (this.rendererHints == null) {
            return this.renderingBufferDEFAULT;
        }
        Number result = (Number)this.rendererHints.get("renderingBuffer");
        if (result == null) {
            return this.renderingBufferDEFAULT;
        }
        return result.intValue();
    }

    private String getScaleComputationMethod() {
        if (this.rendererHints == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        String result = (String)this.rendererHints.get("scaleComputationMethod");
        if (result == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        return result;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    public void setJava2DHints(RenderingHints hints) {
        this.java2dHints = hints;
    }

    public RenderingHints getJava2DHints() {
        return this.java2dHints;
    }

    public void setRendererHints(Map hints) {
        this.rendererHints = hints;
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    public void setContext(MapContext context) {
        this.context = context;
    }

    public MapContext getContext() {
        return this.context;
    }

    public boolean isCanTransform() {
        return this.canTransform;
    }

    public static MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) {
        try {
            return CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        }
        catch (OperationNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    static {
        $assertionsDisabled = !StreamingRenderer.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.rendering");
        filterFactory = FilterFactoryFinder.createFilterFactory();
    }
}

