/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.DataSource;
import org.geotools.referencing.factory.epsg.FactoryUsingHSQL;
import org.geotools.resources.Utilities;
import org.hsqldb.jdbc.jdbcDataSource;

public class HSQLDataSource
extends jdbcDataSource
implements DataSource {
    private static final String VERSION = "6.12.0";
    public static final String DIRECTORY_KEY = "EPSG-HSQL.directory";
    public static final String DATABASE_NAME = "EPSG";
    private static final String LOGGER = "org.geotools.referencing.factory.epsg";
    private File directory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HSQLDataSource() {
        this(HSQLDataSource.getDirectory());
    }

    public HSQLDataSource(File directory) {
        this.directory = directory;
        if (directory != null) {
            StringBuffer url = new StringBuffer("jdbc:hsqldb:file:");
            String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            url.append(DATABASE_NAME);
            this.setDatabase(url.toString());
            this.directory = directory;
        }
        this.setUser("SA");
    }

    public int getPriority() {
        return 20;
    }

    private static File getDirectory() {
        try {
            File directory;
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && ((directory = new File(property)).isDirectory() || directory.mkdir())) {
                return directory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return HSQLDataSource.getTemporaryDirectory();
    }

    private static File getTemporaryDirectory() {
        File directory = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Databases/HSQL")).isDirectory() || directory.mkdirs())) {
            return directory;
        }
        return null;
    }

    private static boolean dataExists(Connection connection) throws SQLException {
        ResultSet tables = connection.getMetaData().getTables(null, null, "EPSG_%", new String[]{"TABLE"});
        boolean exists = tables.next();
        tables.close();
        return exists;
    }

    private static void deleteIfOutdated(File directory, File propertyFile) {
        if (directory == null || !directory.equals(HSQLDataSource.getTemporaryDirectory())) {
            return;
        }
        if (propertyFile.isFile()) {
            try {
                FileInputStream propertyIn = new FileInputStream(propertyFile);
                Properties properties = new Properties();
                properties.load(propertyIn);
                ((InputStream)propertyIn).close();
                String version = properties.getProperty("epsg.version");
                if (version != null && version.compareTo(VERSION) >= 0) {
                    return;
                }
            }
            catch (IOException exception) {
                Utilities.unexpectedException(LOGGER, "HSQLDataSource", "createBackingStore", exception);
            }
        }
        HSQLDataSource.delete(directory);
    }

    private static void delete(File directory) {
        if (directory != null) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    HSQLDataSource.delete(files[i]);
                }
            }
            directory.delete();
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        String database = this.getDatabase();
        if (database == null || database.trim().length() == 0) {
            throw new SQLException("Can't write to the database directory.");
        }
        if (this.directory != null) {
            File file = new File(this.directory, "EPSG.properties");
            HSQLDataSource.deleteIfOutdated(this.directory, file);
        }
        if (!HSQLDataSource.dataExists(connection = super.getConnection())) {
            Logger.getLogger(LOGGER).info("Creating cached EPSG database. It may take a few minutes.");
            Statement statement = connection.createStatement();
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(HSQLDataSource.class.getResourceAsStream("EPSG.sql"), "ISO-8859-1"));
                StringBuffer insertStatement = null;
                while ((line = in.readLine()) != null) {
                    int length = (line = line.trim()).length();
                    if (length == 0) continue;
                    if (line.startsWith("INSERT INTO")) {
                        insertStatement = new StringBuffer(line);
                        continue;
                    }
                    if (insertStatement != null) {
                        boolean hasMore;
                        int values = insertStatement.length();
                        insertStatement.append(line);
                        boolean bl = hasMore = line.charAt(length - 1) == ',';
                        if (hasMore) {
                            insertStatement.setLength(insertStatement.length() - 1);
                        }
                        line = insertStatement.toString();
                        insertStatement.setLength(values);
                        if (!hasMore) {
                            insertStatement = null;
                        }
                    }
                    statement.execute(line);
                }
                in.close();
                if (this.directory != null) {
                    File file = new File(this.directory, "EPSG.properties");
                    FileInputStream propertyIn = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(propertyIn);
                    ((InputStream)propertyIn).close();
                    properties.put("epsg.version", VERSION.toString());
                    properties.put("readonly", "true");
                    FileOutputStream out = new FileOutputStream(file);
                    properties.store(out, "EPSG database on HSQL");
                    ((OutputStream)out).close();
                    File backup = new File(this.directory, "EPSG.backup");
                    if (backup.exists()) {
                        backup.delete();
                    }
                }
            }
            catch (IOException exception) {
                statement.close();
                SQLException e = new SQLException("Can't read the SQL script.");
                e.initCause(exception);
                throw e;
            }
            statement.close();
            connection.close();
            connection = super.getConnection();
            if (!$assertionsDisabled && !HSQLDataSource.dataExists(connection)) {
                throw new AssertionError();
            }
        }
        return connection;
    }

    public AbstractAuthorityFactory createFactory(Hints hints) throws SQLException {
        return new FactoryUsingHSQL(hints, this.getConnection());
    }

    static {
        $assertionsDisabled = !HSQLDataSource.class.desiredAssertionStatus();
    }
}

