/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.coveragescaler;

import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import it.geosolutions.utils.progress.ProgressManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.geotools.coverage.processing.operation.FilteredSubsample;
import org.geotools.coverage.processing.operation.Scale;
import org.geotools.coverage.processing.operation.SubsampleAverage;
import org.geotools.factory.Hints;

public class CoverageScaler
extends ProgressManager
implements Runnable,
ProcessingEventListener {
    private static final Hints LENIENT_HINT = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
    private static final FilteredSubsample filteredSubsampleFactory = new FilteredSubsample();
    private static final SubsampleAverage subsampleAvgFactory = new SubsampleAverage();
    private static final Scale scaleFactory = new Scale();
    private static List scalingAlgorithms = new ArrayList(4);
    private static List outputFormats;
    private int numberOfLevels;
    private double[][] resolutionLevels;
    private int numFiles;
    private static final Logger LOG;
    private static final String versionNumber = "0.2";
    private static final double EPS = 1.0E-6;
    private final DefaultOption locationOpt;
    private String locationPath;
    private final DefaultOption wildcardOpt;
    private String wildcardString = "*.*";
    private String indexName = "index";
    private DefaultOption scaleAlgorithmOpt;
    private DefaultOption tileCacheSizeOpt;
    private DefaultOption scaleFactorOpt;
    private int scaleFactor;
    private String scaleAlgorithm;

    public void run() {
        StringBuffer message;
        try {
            boolean append = true;
            FileHandler handler = new FileHandler(this.locationPath + "/error.txt", append);
            handler.setLevel(Level.SEVERE);
            LOG.addHandler(handler);
        }
        catch (SecurityException el) {
            LOG.severe(el.getLocalizedMessage());
        }
        catch (IOException el) {
            LOG.severe(el.getLocalizedMessage());
        }
        Object defaultCRS = null;
        Object actualCRS = null;
        Object globEnvelope = null;
        boolean skipFeature = false;
        double resX = 0.0;
        double resY = 0.0;
        File dir = new File(this.locationPath);
        WildcardFilter fileFilter = new WildcardFilter(this.wildcardString);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        this.numFiles = files.length;
        for (int i = 0; i < this.numFiles; ++i) {
            if (this.getStopThread()) {
                message = new StringBuffer("Stopping requested at file  ").append(i).append(" of ").append(this.numFiles).append(" files");
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles - 1.0);
                return;
            }
            message = new StringBuffer("Now scaling file ").append(files[i]);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(message.toString());
            }
            this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
        }
        if (this.numFiles <= 0) {
            message = new StringBuffer("No file to process!!!");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        }
    }

    public CoverageScaler() {
        this.helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").create();
        this.versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").create();
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.arguments.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where files are located").withRequired(true).create();
        this.wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.arguments.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.arguments.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
                if (factor == 1) {
                    LOG.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.arguments.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.arguments.withName("priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.tileCacheSizeOpt = this.optionBuilder.withShortName("c").withLongName("cache_size").withArgument(this.arguments.withName("c").withMinimum(0).withMaximum(1).create()).withDescription("tile cache sized").withRequired(false).create();
        this.cmdOpts.add(this.helpOpt);
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.locationOpt);
        this.cmdOpts.add(this.wildcardOpt);
        this.cmdOpts.add(this.priorityOpt);
        this.cmdOpts.add(this.scaleAlgorithmOpt);
        this.cmdOpts.add(this.scaleFactorOpt);
        this.cmdOpts.add(this.tileCacheSizeOpt);
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 1, 10);
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand("CoverageScaler");
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter("CoverageScaler - GeoSolutions S.a.s (C) 2006 - v " + versionNumber);
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption(this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    public static void main(String[] args) {
        CoverageScaler coverageScaler = new CoverageScaler();
        coverageScaler.addProcessingEventListener(coverageScaler);
        if (coverageScaler.parseArgs(args)) {
            Thread t = new Thread((Runnable)coverageScaler, "CoverageScaler");
            t.setPriority(coverageScaler.priority);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOG.fine("Exiting...");
        }
    }

    private boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine != null && this.cmdLine.hasOption((Option)this.versionOpt)) {
            System.out.print("CoverageScaler - GeoSolutions S.a.s (C) 2006 - v" + versionNumber);
            System.exit(1);
        } else if (this.cmdLine != null) {
            this.locationPath = (String)this.cmdLine.getValue((Option)this.locationOpt);
            File inDir = new File(this.locationPath);
            if (!inDir.isDirectory()) {
                LOG.severe("Provided input dir does not exist or is not a dir!");
                return false;
            }
            if (this.cmdLine.hasOption((Option)this.wildcardOpt)) {
                this.wildcardString = (String)this.cmdLine.getValue((Option)this.wildcardOpt);
            }
            String scaleF = (String)this.cmdLine.getValue((Option)this.scaleFactorOpt);
            this.scaleFactor = Integer.parseInt(scaleF);
            this.scaleAlgorithm = (String)this.cmdLine.getValue((Option)this.scaleAlgorithmOpt);
            if (this.cmdLine.hasOption((Option)this.priorityOpt)) {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue((Option)this.priorityOpt));
            }
            return true;
        }
        return false;
    }

    public void getNotification(ProcessingEvent event) {
        LOG.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOG.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        outputFormats = new ArrayList(6);
        outputFormats.add("tiff");
        outputFormats.add("tif");
        outputFormats.add("gtiff");
        outputFormats.add("gtif");
        outputFormats.add("png");
        outputFormats.add("jpeg");
        LOG = Logger.getLogger(CoverageScaler.class.toString());
    }
}

