/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.coveragetiler;

import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import it.geosolutions.utils.progress.ProgressManager;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFinder;
import org.geotools.data.coverage.grid.UnknownFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.spatialschema.geometry.Envelope;

public class CoverageTiler
extends ProgressManager
implements ProcessingEventListener,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(CoverageTiler.class.toString());
    private static final String versionNumber = "0.2";
    protected final DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
    private DefaultOption helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").create();
    private DefaultOption versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").create();
    private DefaultOption inputLocationOpt = this.optionBuilder.withShortName("s").withLongName("src_coverage").withArgument(this.arguments.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where the source code is located").withRequired(true).create();
    private DefaultOption outputLocationOpt = this.optionBuilder.withShortName("d").withLongName("dest_directory").withArgument(this.arguments.withName("destination").withMinimum(0).withMaximum(1).create()).withDescription("output directory, if none is provided, the \"tiled\" directory will be used").withRequired(false).create();
    private File inputLocation;
    private File outputLocation;
    private DefaultOption tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.arguments.withName("t").withMinimum(1).withMaximum(1).create()).withDescription("number or rows and columns used to split the image as a couple rows,cols").withRequired(true).create();
    private int numTileX;
    private int numTileY;

    public CoverageTiler() {
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.arguments.withName("priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.cmdOpts.add(this.helpOpt);
        this.cmdOpts.add(this.tileDimOpt);
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.inputLocationOpt);
        this.cmdOpts.add(this.outputLocationOpt);
        this.cmdOpts.add(this.priorityOpt);
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 1, 10);
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand("CoverageTiler");
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter("CoverageTiler - GeoSolutions S.a.s (C) 2006 - v " + versionNumber);
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption((Option)this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    public static void main(String[] args) throws MalformedURLException, InterruptedException {
        CoverageTiler coverageTiler = new CoverageTiler();
        coverageTiler.addProcessingEventListener(coverageTiler);
        if (coverageTiler.parseArgs(args)) {
            Thread t = new Thread((Runnable)coverageTiler, "MosaicIndexBuilder");
            t.setPriority(coverageTiler.priority);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.fine("Exiting...");
        }
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public void run() {
        AbstractGridFormat format;
        StringBuffer message = new StringBuffer("Acquiring a mosaic reader to mosaic ").append(this.inputLocation);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        if ((format = (AbstractGridFormat)GridFormatFinder.findFormat((Object)this.inputLocation)) == null || format instanceof UnknownFormat) {
            this.fireException("Unable to decide format for this coverage", 0.0, new IOException("Could not find a format for this coverage"));
            return;
        }
        AbstractGridCoverage2DReader inReader = (AbstractGridCoverage2DReader)format.getReader((Object)this.inputLocation);
        if (inReader == null) {
            message = new StringBuffer("Unable to instantiate a reader for this coverage");
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.fine(message.toString());
            }
            return;
        }
        if (!this.outputLocation.exists()) {
            this.outputLocation.mkdir();
        }
        GeneralEnvelope envelope = inReader.getOriginalEnvelope();
        message = new StringBuffer("Original envelope is ").append(envelope.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        GeneralGridRange range = inReader.getOriginalGridRange();
        message = new StringBuffer("Original range is ").append(range.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        message = new StringBuffer("New matrix dimension is (cols,rows)==(").append(this.numTileX).append(",").append(this.numTileY).append(")");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        int[] uppers = range.getUppers();
        double[] newRange = new double[]{uppers[0] / this.numTileX, uppers[1] / this.numTileY};
        double minx = envelope.getMinimum(0);
        double miny = envelope.getMinimum(1);
        double maxx = envelope.getMaximum(0);
        double maxy = envelope.getMaximum(1);
        double dx = envelope.getLength(0) / (double)this.numTileX;
        double dy = envelope.getLength(1) / (double)this.numTileY;
        double _maxx = 0.0;
        double _maxy = 0.0;
        double _minx = 0.0;
        double _miny = 0.0;
        DefaultProcessor processor = new DefaultProcessor(null);
        GridCoverage2D gc = null;
        for (int i = 0; i < this.numTileY; ++i) {
            for (int j = 0; j < this.numTileX; ++j) {
                _maxx = minx + (double)(j + 1) * dx;
                _minx = minx + (double)j * dx;
                _maxy = miny + (double)(i + 1) * dy;
                _miny = miny + (double)i * dy;
                if (_maxx > maxx) {
                    _maxx = maxx;
                }
                if (_maxy > maxy) {
                    _maxy = maxy;
                }
                ParameterValue gg = (ParameterValue)ImageMosaicFormat.READ_GRIDGEOMETRY2D.createValue();
                GeneralEnvelope cropEnvelope = new GeneralEnvelope(new double[]{_minx, _miny}, new double[]{_maxx, _maxy});
                cropEnvelope.setCoordinateReferenceSystem(inReader.getCrs());
                gg.setValue((Object)new GridGeometry2D((GridRange)new GeneralGridRange(new Rectangle(0, 0, 800, 800)), (Envelope)cropEnvelope));
                message = new StringBuffer("Reading with grid envelope ").append(cropEnvelope.toString());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                try {
                    gc = (GridCoverage2D)inReader.read(new GeneralParameterValue[]{gg});
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    this.fireEvent(e.getLocalizedMessage(), 0.0);
                    return;
                }
                File fileOut = new File(this.outputLocation, "mosaic" + "_" + Integer.toString(i * this.numTileX + j) + "." + "tiff");
                if (fileOut.exists()) {
                    fileOut.delete();
                }
                message = new StringBuffer("Preparing tile (col,row)==(").append(j).append(",").append(i).append(") to file ").append(fileOut);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
                param.parameter("Source").setValue((Object)gc);
                param.parameter("ConserveEnvelope").setValue(true);
                param.parameter("Envelope").setValue((Object)cropEnvelope);
                GridCoverage2D cropped = (GridCoverage2D)processor.doOperation(param);
                GeneralGridRange newGridrange = new GeneralGridRange(new Rectangle2D.Double(0.0, 0.0, newRange[0], newRange[1]).getBounds());
                GridGeometry2D scaledGridGeometry = new GridGeometry2D((GridRange)newGridrange, (Envelope)cropEnvelope);
                param = processor.getOperation("Resample").getParameters();
                param.parameter("Source").setValue((Object)cropped);
                param.parameter("CoordinateReferenceSystem").setValue((Object)inReader.getCrs());
                param.parameter("GridGeometry").setValue((Object)scaledGridGeometry);
                param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
                GridCoverage2D scaled = (GridCoverage2D)processor.doOperation(param);
                message = new StringBuffer("Writing out...");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                try {
                    GeoTiffFormat geoTiffFormat = new GeoTiffFormat();
                    GeoTiffWriteParams wp = new GeoTiffWriteParams();
                    wp.setCompressionMode(2);
                    wp.setCompressionType("JPEG");
                    wp.setCompressionQuality(1.0f);
                    wp.setTilingMode(2);
                    wp.setTiling(256, 256);
                    ParameterValueGroup params = geoTiffFormat.getWriteParameters();
                    params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
                    GeoTiffWriter writerWI = new GeoTiffWriter((Object)fileOut);
                    writerWI.write((GridCoverage)scaled, params.values().toArray(new GeneralParameterValue[1]));
                    continue;
                }
                catch (IOException e) {
                    this.fireException(e);
                    return;
                }
            }
        }
        message = new StringBuffer("Done...");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
    }

    private boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine != null && this.cmdLine.hasOption((Option)this.versionOpt)) {
            System.out.print("MosaicIndexBuilder - GeoSolutions S.a.s (C) 2006 - v" + versionNumber);
            System.exit(1);
        } else if (this.cmdLine != null) {
            this.inputLocation = new File((String)this.cmdLine.getValue((Option)this.inputLocationOpt));
            this.outputLocation = this.cmdLine.hasOption((Option)this.outputLocationOpt) ? new File((String)this.cmdLine.getValue((Option)this.outputLocationOpt)) : new File(this.inputLocation.getParentFile(), "tiled");
            String tileDim = (String)this.cmdLine.getValue((Option)this.tileDimOpt);
            String[] pairs = tileDim.split(",");
            this.numTileX = Integer.parseInt(pairs[0]);
            this.numTileY = Integer.parseInt(pairs[1]);
            if (this.cmdLine.hasOption((Option)this.priorityOpt)) {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue((Option)this.priorityOpt));
            }
            return true;
        }
        return false;
    }

    public File getInputLocation() {
        return this.inputLocation;
    }

    public void setInputLocation(File inputLocation) {
        this.inputLocation = inputLocation;
    }

    public int getNumTileX() {
        return this.numTileX;
    }

    public void setNumTileX(int numTileX) {
        this.numTileX = numTileX;
    }

    public int getNumTileY() {
        return this.numTileY;
    }

    public void setNumTileY(int numTileY) {
        this.numTileY = numTileY;
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
    }
}

