/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.imagemosaic;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import it.geosolutions.utils.progress.ProgressManager;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.feature.type.TextualAttributeType;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.resources.CRSUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public class MosaicIndexBuilder
extends ProgressManager
implements Runnable,
ProcessingEventListener {
    private int numberOfLevels;
    private double[][] resolutionLevels;
    private int numFiles;
    private static final Logger LOG = Logger.getLogger(MosaicIndexBuilder.class.toString());
    private static final String versionNumber = "0.2";
    private static final double EPS = 0.01;
    private final DefaultOption locationOpt;
    private String locationPath;
    private final DefaultOption wildcardOpt;
    private String wildcardString = "*.*";
    private DefaultOption nameOpt;
    private String indexName = "index";
    private boolean mustConvertToRGB = false;
    private ColorModel actualCM = null;
    private ColorModel defaultCM = null;
    private SampleModel defaultSM = null;
    private SampleModel actualSM = null;
    private GeneralEnvelope globEnvelope = null;
    private GeneralEnvelope envelope = null;
    private byte[][] defaultPalette = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private CoordinateReferenceSystem actualCRS = null;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;

    private void recurse(List allFiles, String locationPath) {
        File dir = new File(locationPath);
        WildcardFilter fileFilter = new WildcardFilter(this.wildcardString);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        File[] dirs = dir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        int filesLength = files.length;
        for (int i = 0; i < filesLength; ++i) {
            allFiles.add(files[i]);
        }
        int dirsLength = dirs.length;
        for (int i = 0; i < dirsLength; ++i) {
            this.recurse(allFiles, locationPath + '/' + dirs[i].getName());
        }
    }

    public void run() {
        try {
            boolean append = true;
            FileHandler handler = new FileHandler(this.locationPath + "/error.txt", append);
            handler.setLevel(Level.SEVERE);
            LOG.addHandler(handler);
        }
        catch (SecurityException el) {
            this.fireException(el);
            return;
        }
        catch (IOException el) {
            this.fireException(el);
            return;
        }
        HashSet<String> skipFiles = new HashSet<String>(Arrays.asList(this.indexName + ".shp", this.indexName + ".dbf", this.indexName + ".shx", this.indexName + ".prj", "error.txt", "error.txt.lck", this.indexName + ".properties"));
        ShapefileDataStore index = null;
        FeatureWriter fw = null;
        Feature feature = null;
        DefaultTransaction t = new DefaultTransaction();
        PrecisionModel precMod = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory geomFactory = new GeometryFactory(precMod);
        try {
            index = new ShapefileDataStore(new File(this.locationPath + "/" + this.indexName + ".shp").toURL());
        }
        catch (MalformedURLException ex) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            this.fireException(ex);
            return;
        }
        boolean skipFeature = false;
        double resX = 0.0;
        double resY = 0.0;
        boolean doneSomething = false;
        ArrayList files = new ArrayList(25);
        this.recurse(files, this.locationPath);
        this.numFiles = files.size();
        String validFileName = null;
        Iterator filesIt = files.iterator();
        for (int i = 0; i < this.numFiles; ++i) {
            StringBuffer message;
            File fileBeingProcessed = (File)filesIt.next();
            if (this.getStopThread()) {
                message = new StringBuffer("Stopping requested at file  ").append(i).append(" of ").append(this.numFiles).append(" files");
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
                return;
            }
            try {
                validFileName = fileBeingProcessed.getCanonicalPath();
            }
            catch (IOException e1) {
                this.fireException(e1);
                return;
            }
            validFileName = validFileName.replace('\\', '/');
            validFileName = validFileName.substring(this.locationPath.length() + 1, fileBeingProcessed.getAbsolutePath().length());
            if (skipFiles.contains(validFileName)) continue;
            message = new StringBuffer("Now indexing file ").append(validFileName);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(message.toString());
            }
            this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
            try {
                double[] res;
                AbstractGridFormat format;
                ImageInputStream inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                inStream.mark();
                Iterator<ImageReader> it = ImageIO.getImageReaders(inStream);
                if (!it.hasNext()) {
                    message = new StringBuffer("Skipped file ").append(files.get(i)).append(":No ImageIO readeres avalaible.");
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                    continue;
                }
                ImageReader r = it.next();
                r.setInput(inStream);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Getting a reader");
                }
                if ((format = (AbstractGridFormat)GridFormatFinder.findFormat(files.get(i))) == null) {
                    message = new StringBuffer("Skipped file ").append(files.get(i)).append(": File format is not supported.");
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                    continue;
                }
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)format.getReader(files.get(i));
                this.envelope = reader.getOriginalEnvelope();
                this.actualCRS = reader.getCrs();
                ImageTypeSpecifier its = r.getImageTypes(0).next();
                if (this.globEnvelope == null) {
                    this.defaultCM = its.getColorModel();
                    if (this.defaultCM instanceof IndexColorModel) {
                        IndexColorModel icm = (IndexColorModel)this.defaultCM;
                        int numBands = this.defaultCM.getNumColorComponents();
                        this.defaultPalette = new byte[3][icm.getMapSize()];
                        icm.getReds(this.defaultPalette[0]);
                        icm.getGreens(this.defaultPalette[0]);
                        icm.getBlues(this.defaultPalette[0]);
                        if (numBands == 4) {
                            icm.getAlphas(this.defaultPalette[0]);
                        }
                    }
                    this.defaultSM = its.getSampleModel();
                    this.defaultCRS = this.actualCRS;
                    this.globEnvelope = new GeneralEnvelope(this.envelope);
                    r.reset();
                    inStream.reset();
                    r.setInput(inStream);
                    this.numberOfLevels = r.getNumImages(true);
                    this.resolutionLevels = new double[2][this.numberOfLevels];
                    res = this.getResolution(this.envelope, new Rectangle(r.getWidth(0), r.getHeight(0)), this.defaultCRS);
                    resX = res[0];
                    resY = res[1];
                    this.resolutionLevels[0][0] = res[0];
                    this.resolutionLevels[1][0] = res[1];
                    if (this.numberOfLevels > 1) {
                        for (int k = 0; k < this.numberOfLevels; ++k) {
                            res = this.getResolution(this.envelope, new Rectangle(r.getWidth(k), r.getHeight(k)), this.defaultCRS);
                            this.resolutionLevels[0][k] = res[0];
                            this.resolutionLevels[1][k] = res[1];
                        }
                    }
                    GeometricAttributeType refGeom = new GeometricAttributeType("the_geom", class$com$vividsolutions$jts$geom$Polygon == null ? MosaicIndexBuilder.class$("com.vividsolutions.jts.geom.Polygon") : class$com$vividsolutions$jts$geom$Polygon, true, null, this.defaultCRS, null);
                    TextualAttributeType locationAttribute = new TextualAttributeType("location", true, 1, 1, (Object)"none", null);
                    FeatureTypeFactory builder = FeatureTypeBuilder.newInstance((String)"index");
                    builder.setDefaultGeometry((GeometryAttributeType)refGeom);
                    builder.addType((AttributeType)locationAttribute);
                    FeatureType ftType = null;
                    try {
                        ftType = builder.getFeatureType();
                    }
                    catch (SchemaException e) {
                        if (LOG.isLoggable(Level.SEVERE)) {
                            LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        this.fireEvent(e.getLocalizedMessage(), 0.0);
                        return;
                    }
                    index.createSchema(ftType);
                    fw = index.getFeatureWriter(index.getTypeNames()[0], (Transaction)t);
                } else {
                    this.globEnvelope.add(this.envelope);
                    this.actualCM = its.getColorModel();
                    this.actualSM = its.getSampleModel();
                    boolean bl = i > 0 ? !CRSUtilities.equalsIgnoreMetadata(this.defaultCRS, this.actualCRS) : (skipFeature = false);
                    if (skipFeature) {
                        LOG.warning("Skipping image " + files.get(i) + " because CRSs do not match.");
                    }
                    if (skipFeature = this.checkColorModels(this.defaultCM, this.defaultPalette, this.actualCM)) {
                        LOG.warning("Skipping image " + files.get(i) + " because color models do not match.");
                    }
                    if (Math.abs((resX - (res = this.getResolution(this.envelope, new Rectangle(r.getWidth(0), r.getHeight(0)), this.defaultCRS))[0]) / resX) > 0.01 || Math.abs(resY - res[1]) > 0.01) {
                        LOG.warning("Skipping image " + files.get(i) + " because resolutions does not match.");
                        skipFeature = true;
                    }
                }
                if (!skipFeature) {
                    feature = fw.next();
                    feature.setAttribute(0, (Object)geomFactory.toGeometry((com.vividsolutions.jts.geom.Envelope)new ReferencedEnvelope((Envelope)this.envelope, this.actualCRS)));
                    feature.setAttribute(1, (Object)validFileName);
                    fw.write();
                    message = new StringBuffer("Done with file ").append(files.get(i));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(message.toString());
                    }
                    message.append('\n');
                    this.fireEvent(message.toString(), (double)(i + 1) * 99.0 / (double)this.numFiles);
                    doneSomething = true;
                    continue;
                }
                skipFeature = false;
                continue;
            }
            catch (IOException e) {
                this.fireException(e);
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.fireException(e);
                break;
            }
            catch (IllegalAttributeException e) {
                this.fireException((Exception)((Object)e));
                break;
            }
        }
        try {
            if (fw != null) {
                fw.close();
            }
            t.commit();
            t.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.createPropertiesFiles(this.globEnvelope, doneSomething);
    }

    private void createPropertiesFiles(GeneralEnvelope globEnvelope, boolean doneSomething) {
        if (this.numFiles > 0 && doneSomething) {
            StringBuffer message = new StringBuffer("Creating final properties file ");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(message.toString());
            }
            this.fireEvent(message.toString(), 99.9);
            Properties properties = new Properties();
            properties.setProperty("NumFiles", Integer.toString(this.numFiles));
            properties.setProperty("Envelope2D", Double.toString(globEnvelope.getMinimum(0)) + "," + Double.toString(globEnvelope.getMinimum(1)) + " " + Double.toString(globEnvelope.getMaximum(0)) + "," + Double.toString(globEnvelope.getMaximum(1)));
            properties.setProperty("LevelsNum", Integer.toString(this.numberOfLevels));
            StringBuffer levels = new StringBuffer();
            for (int k = 0; k < this.numberOfLevels; ++k) {
                levels.append(Double.toString(this.resolutionLevels[0][k])).append(",").append(Double.toString(this.resolutionLevels[1][k]));
                if (k >= this.numberOfLevels - 1) continue;
                levels.append(" ");
            }
            properties.setProperty("Levels", levels.toString());
            properties.setProperty("Name", this.indexName);
            properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
            try {
                properties.store(new BufferedOutputStream(new FileOutputStream(this.locationPath + "/" + this.indexName + ".properties")), "");
            }
            catch (FileNotFoundException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                this.fireEvent(e.getLocalizedMessage(), 0.0);
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                this.fireEvent(e.getLocalizedMessage(), 0.0);
            }
            message = new StringBuffer("Done!!!");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        } else {
            StringBuffer message = new StringBuffer("No file to process!!!");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        }
    }

    private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
        if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
            ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
            ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
            return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !defCCM.getColorSpace().equals(actualCCM.getColorSpace()) || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
        }
        if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
            IndexColorModel defICM = (IndexColorModel)defaultCM;
            IndexColorModel actualICM = (IndexColorModel)actualCM;
            if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                return true;
            }
            if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                this.mustConvertToRGB = true;
                return false;
            }
            int numBands = actualICM.getNumColorComponents();
            byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
            actualICM.getReds(defaultPalette[0]);
            actualICM.getGreens(defaultPalette[0]);
            actualICM.getBlues(defaultPalette[0]);
            if (numBands == 4) {
                actualICM.getAlphas(defaultPalette[0]);
            }
            block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                for (int j = 0; j < numBands; ++j) {
                    if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                    this.mustConvertToRGB = true;
                    continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public MosaicIndexBuilder() {
        this.helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").create();
        this.versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").create();
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.arguments.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where files are located").withRequired(true).create();
        this.wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.arguments.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
        this.nameOpt = this.optionBuilder.withShortName("name").withLongName("index_name").withArgument(this.arguments.withName("name").withMinimum(0).withMaximum(1).create()).withDescription("name for the index file").withRequired(false).create();
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.arguments.withName("priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.cmdOpts.add(this.helpOpt);
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.locationOpt);
        this.cmdOpts.add(this.wildcardOpt);
        this.cmdOpts.add(this.nameOpt);
        this.cmdOpts.add(this.priorityOpt);
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 1, 10);
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand("MosaicIndexBuilder");
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter("MosaicIndexBuilder - GeoSolutions S.a.s (C) 2006 - v " + versionNumber);
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption(this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    public static void main(String[] args) {
        MosaicIndexBuilder mosaicIndexBuilder = new MosaicIndexBuilder();
        mosaicIndexBuilder.addProcessingEventListener(mosaicIndexBuilder);
        if (mosaicIndexBuilder.parseArgs(args)) {
            Thread t = new Thread((Runnable)mosaicIndexBuilder, "MosaicIndexBuilder");
            t.setPriority(mosaicIndexBuilder.priority);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOG.fine("Exiting...");
        }
    }

    private boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine != null && this.cmdLine.hasOption((Option)this.versionOpt)) {
            System.out.print("MosaicIndexBuilder - GeoSolutions S.a.s (C) 2006 - v" + versionNumber);
            System.exit(1);
        } else if (this.cmdLine != null) {
            this.locationPath = (String)this.cmdLine.getValue((Option)this.locationOpt);
            File inDir = new File(this.locationPath);
            if (!inDir.isDirectory()) {
                LOG.severe("Provided input dir does not exist or is not a dir!");
                return false;
            }
            try {
                this.locationPath = inDir.getCanonicalPath();
                this.locationPath = this.locationPath.replace('\\', '/');
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return false;
            }
            if (this.cmdLine.hasOption((Option)this.wildcardOpt)) {
                this.wildcardString = (String)this.cmdLine.getValue((Option)this.wildcardOpt);
            }
            if (this.cmdLine.hasOption((Option)this.nameOpt)) {
                this.indexName = (String)this.cmdLine.getValue((Option)this.nameOpt);
            }
            if (this.cmdLine.hasOption((Option)this.priorityOpt)) {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue((Option)this.priorityOpt));
            }
            return true;
        }
        return false;
    }

    private double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null) {
                CoordinateReferenceSystem crs2D = CRSUtilities.getCRS2D(envelope.getCoordinateReferenceSystem());
                boolean longitudeFirst = !GridGeometry2D.swapXY((CoordinateSystem)crs2D.getCoordinateSystem());
                requestedRes = new double[]{envelope.getLength(longitudeFirst ? 0 : 1) / dim.getWidth(), envelope.getLength(longitudeFirst ? 1 : 0) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
    }

    public void getNotification(ProcessingEvent event) {
        LOG.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOG.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public final void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
        File inDir = new File(locationPath);
        if (!inDir.isDirectory()) {
            LOG.severe("Provided input dir does not exist or is not a dir!");
            throw new IllegalArgumentException("Provided input dir does not exist or is not a dir!");
        }
        try {
            locationPath = inDir.getCanonicalPath();
            locationPath = locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public double getResolutionX() {
        return this.resolutionLevels[0][0];
    }

    public double getResolutionY() {
        return this.resolutionLevels[1][0];
    }
}

