/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.imageoverviews;

import it.geosolutions.utils.DefaultWriteProgressListener;
import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import it.geosolutions.utils.progress.ProgressManager;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RecyclingTileFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.geotools.resources.image.ImageUtilities;

public class OverviewsEmbedder
extends ProgressManager
implements Runnable,
ProcessingEventListener {
    private final OverviewsEmbedderWriteProgressListener writeProgressListener = new OverviewsEmbedderWriteProgressListener();
    public static final long DEFAULT_TILE_CHACHE_SIZE = 0x4000000L;
    public final boolean DEFAULT_IMAGEIO_CACHING_BEHAVIOUR = false;
    public final int DEFAULT_THREAD_PRIORITY = 5;
    public static final Interpolation DEFAULT_INTERPOLATION = Interpolation.getInstance((int)0);
    public static final float[] DEFAULT_KERNEL_GAUSSIAN = new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f};
    public static final BorderExtender DEFAULT_BORDER_EXTENDER = BorderExtender.createInstance((int)1);
    private static List scalingAlgorithms = new ArrayList(4);
    private static final String versionNumber = "0.2";
    private DefaultOption locationOpt;
    private DefaultOption tileDimOpt;
    private DefaultOption scaleAlgorithmOpt;
    private DefaultOption wildcardOpt;
    private DefaultOption tileCacheSizeOpt;
    private DefaultOption numStepsOpt;
    private DefaultOption scaleFactorOpt;
    private int tileW = -1;
    private int tileH = -1;
    private String scaleAlgorithm;
    private static final Logger LOGGER;
    public final int DEFAULT_RESOLUTION_STEPS = 5;
    private boolean useImageIOCache = false;
    private BorderExtender borderExtender = DEFAULT_BORDER_EXTENDER;
    private int downsampleStep;
    private long tileCacheSize = 0x4000000L;
    private float[] lowPassFilter = DEFAULT_KERNEL_GAUSSIAN;
    private String sourcePath;
    private Interpolation interp = DEFAULT_INTERPOLATION;
    private int numSteps;
    private String wildcardString = "*.*";
    private volatile int fileBeingProcessed;
    private volatile int overviewInProcess;

    public OverviewsEmbedder() {
        this.helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").withRequired(false).create();
        this.versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").withRequired(false).create();
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source").withArgument(this.arguments.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Source can be a single file or  directory ");
                }
                File source = new File((String)args.get(0));
                if (!source.exists()) {
                    throw new InvalidArgumentException("The provided source is invalid! ");
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.arguments.withName("t").withMinimum(0).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(false).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.arguments.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.arguments.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
        this.numStepsOpt = this.optionBuilder.withShortName("n").withLongName("num_steps").withArgument(this.arguments.withName("n").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int steps = Integer.parseInt((String)args.get(0));
                if (steps <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.arguments.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.arguments.withName("thread_priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.tileCacheSizeOpt = this.optionBuilder.withShortName("c").withLongName("cache_size").withArgument(this.arguments.withName("c").withMinimum(0).withMaximum(1).create()).withDescription("tile cache sized").withRequired(false).create();
        this.cmdOpts.add(this.locationOpt);
        this.cmdOpts.add(this.tileDimOpt);
        this.cmdOpts.add(this.scaleFactorOpt);
        this.cmdOpts.add(this.scaleAlgorithmOpt);
        this.cmdOpts.add(this.numStepsOpt);
        this.cmdOpts.add(this.wildcardOpt);
        this.cmdOpts.add(this.priorityOpt);
        this.cmdOpts.add(this.tileCacheSizeOpt);
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.helpOpt);
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 0, 9);
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand("OverviewsEmbedder");
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter("OverviewsEmbedder - GeoSolutions S.a.s (C) 2006 - v " + versionNumber);
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption(this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    private ImageLayout tile(int tileWidth, int tileHeight, int tileGrdiOffseX, int tileGrdiOffseY, Interpolation interp) {
        ImageLayout layout = new ImageLayout();
        layout.setTileGridXOffset(tileGrdiOffseX);
        layout.setTileGridYOffset(tileGrdiOffseY);
        layout.setValid(16);
        layout.setValid(32);
        layout.setTileWidth(tileWidth);
        layout.setTileHeight(tileHeight);
        layout.setValid(128);
        layout.setValid(64);
        return layout;
    }

    private void settingJAIHints() {
        ImageIO.setUseCache(this.useImageIOCache);
        JAI jaiDef = JAI.getDefaultInstance();
        TileCache cache = jaiDef.getTileCache();
        cache.setMemoryCapacity(this.tileCacheSize * 1024L * 1024L);
        jaiDef.setRenderingHint(JAI.KEY_INTERPOLATION, (Object)this.interp);
        jaiDef.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        jaiDef.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)Boolean.TRUE);
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        jaiDef.setRenderingHint(JAI.KEY_BORDER_EXTENDER, (Object)this.borderExtender);
    }

    private RenderedOp subsample(RenderedOp src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)this.interp);
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
    }

    public int getDownsampleStep() {
        return this.downsampleStep;
    }

    public void setDownsampleStep(int downsampleWH) {
        this.downsampleStep = downsampleWH;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public int getTileHeight() {
        return this.tileH;
    }

    public void setTileHeight(int tileHeight) {
        this.tileH = tileHeight;
    }

    public int getTileWidth() {
        return this.tileW;
    }

    public void setTileWidth(int tileWidth) {
        this.tileW = tileWidth;
    }

    private RenderedOp filteredSubsample(RenderedImage src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)this.lowPassFilter);
        pb.setParameter("Interpolation", (Object)this.interp);
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb);
    }

    private RenderedOp scaleAverage(RenderedImage src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("SubsampleAverage");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Double(1.0 / (double)this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Double(1.0 / (double)this.downsampleStep));
        return JAI.create((String)"SubsampleAverage", (ParameterBlock)pb);
    }

    public void setBorderExtender(BorderExtender borderExtender) {
        this.borderExtender = borderExtender;
    }

    public void setInterp(Interpolation interp) {
        this.interp = interp;
    }

    public void setTileCacheSize(long tileCacheSize) {
        this.tileCacheSize = tileCacheSize;
    }

    public void setUseImageIOCache(boolean useImageIOCache) {
        this.useImageIOCache = useImageIOCache;
    }

    public float[] getLowPassFilter() {
        return this.lowPassFilter;
    }

    public void setLowPassFilter(float[] lowPassFilter) {
        this.lowPassFilter = lowPassFilter;
    }

    public void run() {
        try {
            StringBuffer message;
            File[] files;
            this.settingJAIHints();
            File dir = new File(this.sourcePath);
            int numFiles = 1;
            if (dir.isDirectory()) {
                WildcardFilter fileFilter = new WildcardFilter(this.wildcardString);
                files = dir.listFiles((FileFilter)fileFilter);
                numFiles = files.length;
                if (numFiles <= 0) {
                    message = new StringBuffer("No files to process!");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), 100.0);
                }
            } else {
                files = new File[]{dir};
            }
            this.fileBeingProcessed = 0;
            while (this.fileBeingProcessed < numFiles) {
                message = new StringBuffer("Managing file  ").append(this.fileBeingProcessed).append(" of ").append(files[this.fileBeingProcessed]).append(" files");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                if (this.getStopThread()) {
                    message = new StringBuffer("Stopping requested at file  ").append(this.fileBeingProcessed).append(" of ").append(numFiles).append(" files");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                ImageInputStream stream = ImageIO.createImageInputStream(files[this.fileBeingProcessed]);
                stream.mark();
                Iterator<ImageReader> it = ImageIO.getImageReaders(stream);
                if (!it.hasNext()) {
                    return;
                }
                ImageReader reader = it.next();
                stream.reset();
                stream.mark();
                reader.setInput(stream);
                ImageLayout layout = null;
                int actualTileW = reader.getTileWidth(0);
                int actualTileH = reader.getTileHeight(0);
                if (reader.isImageTiled(0) && actualTileH != this.tileH && actualTileW != this.tileW && this.tileH != -1 && this.tileW != -1) {
                    message = new StringBuffer("Retiling image  ").append(this.fileBeingProcessed);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    layout = this.tile(this.tileW, this.tileH, 0, 0, this.interp);
                }
                stream.reset();
                reader.dispose();
                ImageOutputStream streamOut = ImageIO.createImageOutputStream(files[this.fileBeingProcessed]);
                if (streamOut == null) {
                    message = new StringBuffer("Unable to acquire an ImageOutputStream for the file ").append(files[this.fileBeingProcessed].toString());
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                ImageWriter writer = ImageIO.getImageWriter(reader);
                writer.setOutput(streamOut);
                writer.addIIOWriteProgressListener(this.writeProgressListener);
                ImageWriteParam param = writer.getDefaultWriteParam();
                if (!param.canWriteTiles()) {
                    message = new StringBuffer("This format do not support tiling!");
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                if (!writer.canInsertImage(1)) {
                    message = new StringBuffer("This format do not support overviews!");
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                if (this.tileH != -1 & this.tileW != -1) {
                    param.setTilingMode(2);
                    param.setTiling(this.tileW, this.tileH, 0, 0);
                } else {
                    param.setTilingMode(2);
                    param.setTiling(actualTileW, actualTileH, 0, 0);
                }
                RenderingHints newHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                ParameterBlock pbjRead = new ParameterBlock();
                pbjRead.add(ImageIO.createImageInputStream(files[this.fileBeingProcessed]));
                pbjRead.add(new Integer(0));
                pbjRead.add(Boolean.FALSE);
                pbjRead.add(Boolean.FALSE);
                pbjRead.add(Boolean.FALSE);
                pbjRead.add(null);
                pbjRead.add(null);
                pbjRead.add(null);
                pbjRead.add(null);
                RenderedOp currentImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
                message = new StringBuffer("Reaad original image  ").append(this.fileBeingProcessed);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                this.overviewInProcess = 0;
                while (this.overviewInProcess < this.numSteps) {
                    if (this.overviewInProcess > 0) {
                        stream = ImageIO.createImageInputStream(files[this.fileBeingProcessed]);
                        pbjRead = new ParameterBlock();
                        pbjRead.add(stream);
                        pbjRead.add(new Integer(this.overviewInProcess));
                        pbjRead.add(Boolean.FALSE);
                        pbjRead.add(Boolean.FALSE);
                        pbjRead.add(Boolean.FALSE);
                        pbjRead.add(null);
                        pbjRead.add(null);
                        pbjRead.add(null);
                        pbjRead.add(null);
                        currentImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
                        streamOut = ImageIO.createImageOutputStream(files[this.fileBeingProcessed]);
                        writer = ImageIO.getImageWriter(reader);
                        writer.setOutput(streamOut);
                        writer.addIIOWriteProgressListener(this.writeProgressListener);
                        param = writer.getDefaultWriteParam();
                    }
                    message = new StringBuffer("Subsampling step ").append(this.overviewInProcess).append(" of image  ").append(this.fileBeingProcessed);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    if (currentImage.getWidth() / this.downsampleStep <= 0 || currentImage.getHeight() / this.downsampleStep <= 0) break;
                    if (this.scaleAlgorithm.equalsIgnoreCase("avg")) {
                        currentImage = this.scaleAverage((RenderedImage)currentImage);
                    } else if (this.scaleAlgorithm.equalsIgnoreCase("filt")) {
                        currentImage = this.filteredSubsample((RenderedImage)currentImage);
                    }
                    if (this.scaleAlgorithm.equalsIgnoreCase("bil")) {
                        currentImage = this.bilinear(currentImage);
                    }
                    if (this.scaleAlgorithm.equalsIgnoreCase("nn")) {
                        currentImage = this.subsample(currentImage);
                    }
                    if (this.scaleAlgorithm.equalsIgnoreCase("bic")) {
                        currentImage = this.bicubic(currentImage);
                    }
                    writer.writeInsert(this.overviewInProcess + 1, new IIOImage((RenderedImage)currentImage, null, null), param);
                    message = new StringBuffer("Step ").append(this.overviewInProcess).append(" of image  ").append(this.fileBeingProcessed).append(" done!");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    JAI.getDefaultInstance().getTileCache().flush();
                    streamOut.flush();
                    streamOut.close();
                    writer.dispose();
                    currentImage.dispose();
                    stream.close();
                    ++this.overviewInProcess;
                }
                message = new StringBuffer("Done with  image  ").append(this.fileBeingProcessed);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(this.fileBeingProcessed + 1) * 100.0 / (double)numFiles);
                ++this.fileBeingProcessed;
            }
        }
        catch (IOException e) {
            this.fireException(e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Done!!!");
        }
    }

    private RenderedOp bilinear(RenderedOp src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)new InterpolationBilinear());
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb);
    }

    private RenderedOp bicubic(RenderedOp src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)new InterpolationBicubic(2));
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb);
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    private boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine != null && this.cmdLine.hasOption((Option)this.versionOpt)) {
            LOGGER.fine("OverviewsEmbedder - GeoSolutions S.a.s (C) 2006 - v" + versionNumber);
            System.exit(1);
        } else if (this.cmdLine != null) {
            this.sourcePath = (String)this.cmdLine.getValue((Option)this.locationOpt);
            if (this.cmdLine.hasOption((Option)this.tileDimOpt)) {
                String tileDim = (String)this.cmdLine.getValue((Option)this.tileDimOpt);
                String[] pairs = tileDim.split(",");
                this.tileW = Integer.parseInt(pairs[0]);
                this.tileH = Integer.parseInt(pairs[1]);
            }
            String scaleF = (String)this.cmdLine.getValue((Option)this.scaleFactorOpt);
            this.downsampleStep = Integer.parseInt(scaleF);
            if (this.cmdLine.hasOption((Option)this.wildcardOpt)) {
                this.wildcardString = (String)this.cmdLine.getValue((Option)this.wildcardOpt);
            }
            this.scaleAlgorithm = (String)this.cmdLine.getValue((Option)this.scaleAlgorithmOpt);
            if (this.scaleAlgorithm == null) {
                this.scaleAlgorithm = "nn";
            }
            this.numSteps = Integer.parseInt((String)this.cmdLine.getValue((Option)this.numStepsOpt));
            if (this.cmdLine.hasOption((Option)this.priorityOpt)) {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue((Option)this.priorityOpt));
            }
            if (this.cmdLine.hasOption((Option)this.tileCacheSizeOpt)) {
                this.tileCacheSize = Integer.parseInt((String)this.cmdLine.getValue((Option)this.tileCacheSizeOpt));
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        OverviewsEmbedder overviewsEmbedder = new OverviewsEmbedder();
        overviewsEmbedder.addProcessingEventListener(overviewsEmbedder);
        if (overviewsEmbedder.parseArgs(args)) {
            Thread t = new Thread((Runnable)overviewsEmbedder, "OverviewsEmbedder");
            t.setPriority(overviewsEmbedder.priority);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to parse command line arguments, exiting...");
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("bic");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        LOGGER = Logger.getLogger(OverviewsEmbedder.class.toString());
    }

    private class OverviewsEmbedderWriteProgressListener
    extends DefaultWriteProgressListener {
        private OverviewsEmbedderWriteProgressListener() {
        }

        public void imageComplete(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent("Started with writing out overview number " + ((double)OverviewsEmbedder.this.overviewInProcess + 1.0), (double)(OverviewsEmbedder.this.overviewInProcess + 1 / OverviewsEmbedder.this.numSteps) * 100.0);
        }

        public void imageProgress(ImageWriter source, float percentageDone) {
            OverviewsEmbedder.this.fireEvent("Writing out overview " + (OverviewsEmbedder.this.overviewInProcess + 1), (double)((float)(OverviewsEmbedder.this.overviewInProcess / OverviewsEmbedder.this.numSteps) + percentageDone / (float)(100 * OverviewsEmbedder.this.numSteps)) * 100.0);
        }

        public void imageStarted(ImageWriter source, int imageIndex) {
            OverviewsEmbedder.this.fireEvent("Completed writing out overview number " + (OverviewsEmbedder.this.overviewInProcess + 1), (double)(OverviewsEmbedder.this.overviewInProcess / OverviewsEmbedder.this.numSteps) * 100.0);
        }

        public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
            OverviewsEmbedder.this.fireEvent("Warning at overview " + (OverviewsEmbedder.this.overviewInProcess + 1), 0.0);
        }

        public void writeAborted(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent("Aborted writing process.", 100.0);
        }
    }
}

