/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.imagepyramid;

import it.geosolutions.utils.coveragetiler.CoverageTiler;
import it.geosolutions.utils.imagemosaic.MosaicIndexBuilder;
import it.geosolutions.utils.imagepyramid.PyramidLayerBuilder;
import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import it.geosolutions.utils.progress.ProgressManager;
import java.awt.RenderingHints;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import javax.media.jai.TileCache;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFinder;
import org.geotools.geometry.GeneralEnvelope;

public class PyramidBuilder
extends ProgressManager
implements Runnable,
ProcessingEventListener {
    public static final long DEFAULT_TILE_CHACHE_SIZE = 0x2000000L;
    public final boolean DEFAULT_IMAGEIO_CACHING_BEHAVIOUR = false;
    public final int DEFAULT_THREAD_PRIORITY = 5;
    public static final Interpolation DEFAULT_INTERPOLATION = Interpolation.getInstance((int)0);
    public static final float[] DEFAULT_KERNEL_GAUSSIAN = new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f};
    public static final BorderExtender DEFAULT_BORDER_EXTENDER = BorderExtender.createInstance((int)1);
    private static List scalingAlgorithms = new ArrayList(4);
    private static final String versionNumber = "0.2";
    private DefaultOption locationOpt;
    private DefaultOption outputLocationOpt;
    private File outputLocation;
    private DefaultOption tileDimOpt;
    private DefaultOption scaleAlgorithmOpt;
    private DefaultOption tileCacheSizeOpt;
    private DefaultOption numStepsOpt;
    private DefaultOption scaleFactorOpt;
    private DefaultOption overwriteOpt;
    private int tileW = -1;
    private int tileH = -1;
    private String scaleAlgorithm;
    private static final Logger LOGGER;
    private boolean useImageIOCache = false;
    private BorderExtender borderExtender = DEFAULT_BORDER_EXTENDER;
    private int scaleFactor;
    private long tileCacheSize = 0x2000000L;
    private File inputLocation;
    private String name;
    private DefaultOption nameOpt;
    private Interpolation interp = DEFAULT_INTERPOLATION;
    private int numSteps;
    private boolean exceptionOccurred = false;
    private boolean overwriteOutputDirs = false;
    private double currStep = 0.0;
    private double totalSteps = 0.0;
    private ProcessingEventListener slaveToolsListener = new ProcessingEventListener(){

        public void getNotification(ProcessingEvent event) {
            PyramidBuilder.this.fireEvent(event.getMessage(), PyramidBuilder.this.currStep / PyramidBuilder.this.totalSteps * 100.0 + event.getPercentage() / PyramidBuilder.this.totalSteps);
        }

        public void exceptionOccurred(ExceptionEvent event) {
            PyramidBuilder.this.fireException(event.getMessage(), event.getPercentage(), event.getException());
            PyramidBuilder.this.exceptionOccurred = true;
        }
    };
    private GeneralEnvelope envelope;
    private double[][] resolutions;

    public PyramidBuilder() {
        this.helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").withRequired(false).create();
        this.versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").withRequired(false).create();
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source").withArgument(this.arguments.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Source can be a single file or directory ");
                }
                File source = new File((String)args.get(0));
                if (!source.exists()) {
                    throw new InvalidArgumentException("The provided source is invalid! ");
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.nameOpt = this.optionBuilder.withShortName("name").withLongName("pyramid_name").withArgument(this.arguments.withName("name").withMinimum(0).withMaximum(1).create()).withDescription("name for the pyramid property file").withRequired(false).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.arguments.withName("t").withMinimum(0).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(false).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.arguments.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.numStepsOpt = this.optionBuilder.withShortName("n").withLongName("num_steps").withArgument(this.arguments.withName("n").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int steps = Integer.parseInt((String)args.get(0));
                if (steps <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.arguments.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.arguments.withName("thread_priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.tileCacheSizeOpt = this.optionBuilder.withShortName("c").withLongName("cache_size").withArgument(this.arguments.withName("c").withMinimum(0).withMaximum(1).create()).withDescription("tile cache sized").withRequired(false).create();
        this.overwriteOpt = this.optionBuilder.withShortName("w").withLongName("overwrite").withDescription("completely wipe out existing layer dirs before proceeding.").withRequired(false).create();
        this.cmdOpts.add(this.locationOpt);
        this.cmdOpts.add(this.tileDimOpt);
        this.cmdOpts.add(this.scaleFactorOpt);
        this.cmdOpts.add(this.scaleAlgorithmOpt);
        this.cmdOpts.add(this.numStepsOpt);
        this.cmdOpts.add(this.priorityOpt);
        this.cmdOpts.add(this.tileCacheSizeOpt);
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.helpOpt);
        this.cmdOpts.add(this.overwriteOpt);
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 0, 9);
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand("PyramidBuilder");
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter("PyramidBuilder - GeoSolutions S.a.s (C) 2006 - v " + versionNumber);
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption(this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    private void settingJAIHints() {
        ImageIO.setUseCache(this.useImageIOCache);
        JAI jaiDef = JAI.getDefaultInstance();
        TileCache cache = jaiDef.getTileCache();
        cache.setMemoryCapacity(this.tileCacheSize);
        jaiDef.setRenderingHint(JAI.KEY_INTERPOLATION, (Object)this.interp);
        jaiDef.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        jaiDef.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)Boolean.TRUE);
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        jaiDef.setRenderingHint(JAI.KEY_BORDER_EXTENDER, (Object)this.borderExtender);
    }

    public void run() {
        this.settingJAIHints();
        AbstractGridFormat format = (AbstractGridFormat)GridFormatFinder.findFormat((Object)this.inputLocation);
        if (format == null) {
            String message = "Could not find a format for this coverage";
            this.fireException(message, 0.0, new IOException(message));
            return;
        }
        AbstractGridCoverage2DReader inReader = (AbstractGridCoverage2DReader)format.getReader((Object)this.inputLocation);
        if (inReader == null) {
            String message = "Unable to instantiate a reader for this coverage";
            this.fireException(message, 0.0, new IOException(message));
            return;
        }
        this.envelope = inReader.getOriginalEnvelope();
        GeneralGridRange range = inReader.getOriginalGridRange();
        int numTileX = (int)Math.ceil(range.getLength(0) / this.tileW);
        int numtileY = (int)Math.ceil(range.getLength(1) / this.tileH);
        inReader.dispose();
        if (!this.outputLocation.exists() && !this.outputLocation.mkdir()) {
            String message = "Could not create output directory: " + this.outputLocation;
            this.fireException(message, 0.0, new IOException(message));
            return;
        }
        this.totalSteps = (this.numSteps + 1) * 2;
        this.currStep = 1.0;
        File outputDir = new File(this.outputLocation, "0");
        if (!this.checkLayerDir(outputDir)) {
            return;
        }
        this.resolutions = new double[2][this.numSteps + 1];
        this.tileInput(numTileX, numtileY, outputDir);
        if (this.exceptionOccurred) {
            return;
        }
        this.currStep += 1.0;
        double[] resolution = this.mosaicLevel(0);
        this.resolutions[0][0] = resolution[0];
        this.resolutions[1][0] = resolution[1];
        if (this.exceptionOccurred) {
            return;
        }
        this.currStep += 1.0;
        int currLevel = this.scaleFactor;
        int prevLevel = 0;
        for (int step = 0; step < this.numSteps; ++step) {
            File prevLevelDirectory = new File(this.outputLocation, String.valueOf(prevLevel));
            File currLevelDirectory = new File(this.outputLocation, String.valueOf(currLevel));
            if (!this.checkLayerDir(currLevelDirectory)) {
                return;
            }
            this.buildNewLayer(prevLevelDirectory, currLevelDirectory);
            if (this.exceptionOccurred) {
                return;
            }
            this.currStep += 1.0;
            resolution = this.mosaicLevel(currLevel);
            this.resolutions[0][step + 1] = resolution[0];
            this.resolutions[1][step + 1] = resolution[1];
            if (this.exceptionOccurred) {
                return;
            }
            this.currStep += 1.0;
            prevLevel = currLevel;
            currLevel *= this.scaleFactor;
        }
        this.fireEvent("Creating final properties file ", 99.9);
        this.createPropertiesFiles();
        if (!this.exceptionOccurred) {
            this.fireEvent("Done!!!", 100.0);
        }
    }

    private boolean checkLayerDir(File outputDir) {
        if (!outputDir.exists()) {
            return true;
        }
        if (!this.overwriteOutputDirs) {
            this.fireException(new IOException("Layer directory " + outputDir + " already exist. Use -w to force its deletion"));
            return false;
        }
        try {
            FileUtils.deleteDirectory((File)outputDir);
        }
        catch (IOException e) {
            this.fireException(e);
            return false;
        }
        return true;
    }

    private void tileInput(int numTileX, int numtileY, File outputDir) {
        CoverageTiler tiler = new CoverageTiler();
        tiler.addProcessingEventListener(this.slaveToolsListener);
        tiler.setInputLocation(this.inputLocation);
        tiler.setOutputLocation(outputDir);
        tiler.setNumTileX(numTileX);
        tiler.setNumTileY(numtileY);
        tiler.run();
        tiler.removeAllProcessingEventListeners();
    }

    private void buildNewLayer(File prevLevelDirectory, File currLevelDirectory) {
        PyramidLayerBuilder layerBuilder = new PyramidLayerBuilder();
        layerBuilder.addProcessingEventListener(this.slaveToolsListener);
        layerBuilder.setInputLocation(new File(prevLevelDirectory, this.name + ".shp"));
        layerBuilder.setOutputLocation(currLevelDirectory);
        layerBuilder.setScaleAlgorithm(this.scaleAlgorithm);
        layerBuilder.setScaleFactor(this.scaleFactor);
        layerBuilder.setTileH(this.tileH);
        layerBuilder.setTileW(this.tileW);
        layerBuilder.run();
        layerBuilder.removeAllProcessingEventListeners();
    }

    private double[] mosaicLevel(int level) {
        MosaicIndexBuilder builder = new MosaicIndexBuilder();
        builder.addProcessingEventListener(this.slaveToolsListener);
        builder.setLocationPath(new File(this.outputLocation, String.valueOf(level)).getAbsolutePath());
        builder.setIndexName(this.name);
        builder.run();
        builder.removeAllProcessingEventListeners();
        return new double[]{builder.getResolutionX(), builder.getResolutionY()};
    }

    private void createPropertiesFiles() {
        Properties properties = new Properties();
        properties.setProperty("Envelope2D", Double.toString(this.envelope.getMinimum(0)) + "," + Double.toString(this.envelope.getMinimum(1)) + " " + Double.toString(this.envelope.getMaximum(0)) + "," + Double.toString(this.envelope.getMaximum(1)));
        properties.setProperty("LevelsNum", Integer.toString(this.numSteps + 1));
        StringBuffer levels = new StringBuffer();
        StringBuffer levelDirs = new StringBuffer();
        for (int i = 0; i < this.numSteps + 1; ++i) {
            levels.append(Double.toString(this.resolutions[0][i])).append(",").append(Double.toString(this.resolutions[1][i]));
            levelDirs.append(i == 0 ? "0" : Integer.toString((int)Math.pow(this.scaleFactor, i)));
            if (i >= this.numSteps) continue;
            levels.append(" ");
            levelDirs.append(" ");
        }
        properties.setProperty("Levels", levels.toString());
        properties.setProperty("LevelsDirs", levelDirs.toString());
        properties.setProperty("Name", this.name);
        try {
            properties.store(new BufferedOutputStream(new FileOutputStream(new File(this.outputLocation, this.name + ".properties"))), "");
            File prjFile = new File(this.outputLocation, this.name + ".prj");
            BufferedWriter out = new BufferedWriter(new FileWriter(prjFile));
            out.write(this.envelope.getCoordinateReferenceSystem().toWKT());
            out.close();
        }
        catch (FileNotFoundException e) {
            this.fireException(e);
        }
        catch (IOException e) {
            this.fireException(e);
        }
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    private boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine != null && this.cmdLine.hasOption((Option)this.versionOpt)) {
            LOGGER.fine("OverviewsEmbedder - GeoSolutions S.a.s (C) 2006 - v" + versionNumber);
            System.exit(1);
        } else if (this.cmdLine != null) {
            this.inputLocation = new File((String)this.cmdLine.getValue((Option)this.locationOpt));
            this.outputLocation = this.cmdLine.hasOption((Option)this.outputLocationOpt) ? new File((String)this.cmdLine.getValue((Option)this.outputLocationOpt)) : new File(this.inputLocation.getParentFile(), "pyramid");
            this.name = this.cmdLine.hasOption((Option)this.nameOpt) ? (String)this.cmdLine.getValue((Option)this.nameOpt) : "pyramid";
            this.overwriteOutputDirs = this.cmdLine.hasOption((Option)this.overwriteOpt);
            if (this.cmdLine.hasOption((Option)this.tileDimOpt)) {
                String tileDim = (String)this.cmdLine.getValue((Option)this.tileDimOpt);
                String[] pairs = tileDim.split(",");
                this.tileW = Integer.parseInt(pairs[0]);
                this.tileH = Integer.parseInt(pairs[1]);
            }
            String scaleF = (String)this.cmdLine.getValue((Option)this.scaleFactorOpt);
            this.scaleFactor = Integer.parseInt(scaleF);
            this.scaleAlgorithm = (String)this.cmdLine.getValue((Option)this.scaleAlgorithmOpt);
            if (this.scaleAlgorithm == null) {
                this.scaleAlgorithm = "nn";
            }
            this.numSteps = Integer.parseInt((String)this.cmdLine.getValue((Option)this.numStepsOpt));
            if (this.cmdLine.hasOption((Option)this.priorityOpt)) {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue((Option)this.priorityOpt));
            }
            if (this.cmdLine.hasOption((Option)this.tileCacheSizeOpt)) {
                this.tileCacheSize = Integer.parseInt((String)this.cmdLine.getValue((Option)this.tileCacheSizeOpt));
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        PyramidBuilder builder = new PyramidBuilder();
        builder.addProcessingEventListener(builder);
        if (builder.parseArgs(args)) {
            Thread t = new Thread((Runnable)builder, "PyramidBuilder");
            t.setPriority(builder.priority);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to parse command line arguments, exiting...");
        }
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("bic");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        LOGGER = Logger.getLogger(PyramidBuilder.class.toString());
    }
}

