/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.imagepyramid;

import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import it.geosolutions.utils.progress.ProgressManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.FilteredSubsample;
import org.geotools.coverage.processing.operation.Scale;
import org.geotools.coverage.processing.operation.SubsampleAverage;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.spatialschema.geometry.Envelope;

public class PyramidLayerBuilder
extends ProgressManager
implements Runnable,
ProcessingEventListener {
    private static List scalingAlgorithms = new ArrayList(4);
    private static List outputFormats;
    private static final Logger LOGGER;
    private static final String versionNumber = "0.2";
    private static final Hints LENIENT_HINT;
    private static final FilteredSubsample filteredSubsampleFactory;
    private static final SubsampleAverage subsampleAvgFactory;
    private static final Scale scaleFactory;
    private DefaultOption inputLocationOpt;
    private DefaultOption outputLocationOpt;
    private DefaultOption tileDimOpt;
    private DefaultOption scaleAlgorithmOpt;
    private DefaultOption tileCacheSizeOpt;
    private DefaultOption outFormatOpt;
    private double tileW;
    private double tileH;
    private File inputLocation;
    private File outputLocation;
    private String scaleAlgorithm;
    private String outputFormat;
    private int tileCacheSize;
    private DefaultOption scaleFactorOpt;
    private int scaleFactor;

    public PyramidLayerBuilder() {
        this.helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").withRequired(false).create();
        this.versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").withRequired(false).create();
        this.inputLocationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.arguments.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one location can be chosen");
                }
                File source = new File((String)args.get(0));
                if (!source.isFile() || !source.exists()) {
                    throw new InvalidArgumentException("The provided source is invalid! ");
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.outputLocationOpt = this.optionBuilder.withShortName("d").withLongName("dest_directory").withArgument(this.arguments.withName("destination").withMinimum(0).withMaximum(1).create()).withDescription("output directory, if none is provided, the \"tiled\" directory will be used").withRequired(false).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.arguments.withName("t").withMinimum(1).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(true).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.arguments.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.arguments.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.arguments.withName("thread_priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.outFormatOpt = this.optionBuilder.withShortName("o").withLongName("out_format").withArgument(this.arguments.withName("o").withMinimum(0).withMaximum(1).withDescription("output format").withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one output format at a time can be specified");
                }
                if (!outputFormats.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("output format").withRequired(false).create();
        this.tileCacheSizeOpt = this.optionBuilder.withShortName("c").withLongName("cache_size").withArgument(this.arguments.withName("c").withMinimum(0).withMaximum(1).create()).withDescription("tile cache sized").withRequired(false).create();
        this.cmdOpts.add(this.inputLocationOpt);
        this.cmdOpts.add(this.tileDimOpt);
        this.cmdOpts.add(this.scaleFactorOpt);
        this.cmdOpts.add(this.scaleAlgorithmOpt);
        this.cmdOpts.add(this.outFormatOpt);
        this.cmdOpts.add(this.priorityOpt);
        this.cmdOpts.add(this.tileCacheSizeOpt);
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.helpOpt);
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 0, 9);
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand("PyramidLayerBuilder");
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter("PyramidLayerBuilder - GeoSolutions S.a.s (C) 2006 - v " + versionNumber);
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption(this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        PyramidLayerBuilder pyramidBuilder = new PyramidLayerBuilder();
        pyramidBuilder.addProcessingEventListener(pyramidBuilder);
        if (pyramidBuilder.parseArgs(args)) {
            Thread t = new Thread((Runnable)pyramidBuilder, "PyramidBuilder");
            t.setPriority(pyramidBuilder.priority);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.fine("Exiting...");
        }
    }

    private boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine != null && this.cmdLine.hasOption((Option)this.versionOpt)) {
            LOGGER.fine("PyramidBuilder - GeoSolutions S.a.s (C) 2006 - v" + versionNumber);
            System.exit(1);
        } else if (this.cmdLine != null) {
            this.inputLocation = new File((String)this.cmdLine.getValue((Option)this.inputLocationOpt));
            String tileDim = (String)this.cmdLine.getValue((Option)this.tileDimOpt);
            String[] pairs = tileDim.split(",");
            this.tileW = Integer.parseInt(pairs[0]);
            this.tileH = Integer.parseInt(pairs[1]);
            String scaleF = (String)this.cmdLine.getValue((Option)this.scaleFactorOpt);
            this.scaleFactor = Integer.parseInt(scaleF);
            this.outputLocation = this.cmdLine.hasOption((Option)this.outputLocationOpt) ? new File((String)this.cmdLine.getValue((Option)this.outputLocationOpt)) : new File(this.inputLocation.getParentFile(), String.valueOf(this.scaleFactor));
            this.scaleAlgorithm = (String)this.cmdLine.getValue((Option)this.scaleAlgorithmOpt);
            if (this.scaleAlgorithm == null) {
                this.scaleAlgorithm = "nn";
            }
            this.outputFormat = (String)this.cmdLine.getValue((Option)this.outFormatOpt);
            if (this.cmdLine.hasOption((Option)this.priorityOpt)) {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue((Option)this.priorityOpt));
            }
            if (this.cmdLine.hasOption((Option)this.tileCacheSizeOpt)) {
                this.tileCacheSize = Integer.parseInt((String)this.cmdLine.getValue((Option)this.tileCacheSizeOpt));
                JAI.getDefaultInstance().getTileCache().setMemoryCapacity((long)(this.tileCacheSize * 1024 * 1024));
            }
            return true;
        }
        return false;
    }

    public void run() {
        StringBuffer message = new StringBuffer("Requested scale factor is ").append(this.scaleFactor);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        message = new StringBuffer("Acquiring a mosaic reader to mosaic ").append(this.inputLocation);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        ImageMosaicReader inReader = null;
        try {
            inReader = new ImageMosaicReader((Object)this.inputLocation, new Hints(Hints.IGNORE_COVERAGE_OVERVIEW, Boolean.TRUE));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.fireException(e);
            return;
        }
        if (!this.outputLocation.exists()) {
            this.outputLocation.mkdir();
        }
        GeneralEnvelope envelope = inReader.getOriginalEnvelope();
        message = new StringBuffer("Original envelope is ").append(envelope.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        GeneralGridRange range = inReader.getOriginalGridRange();
        message = new StringBuffer("Original range is ").append(range.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        double newWidth = (double)range.getLength(0) * 1.0 / (double)this.scaleFactor;
        double newHeight = (double)range.getLength(1) * 1.0 / (double)this.scaleFactor;
        if (this.tileW > newWidth) {
            this.tileW = newWidth;
        }
        if (this.tileH > newHeight) {
            this.tileH = newHeight;
        }
        message = new StringBuffer("New dimension is (W,H)==(").append(newWidth).append(",").append(newHeight).append(")");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        int newCols = (int)Math.floor(newWidth / this.tileW);
        int newRows = (int)Math.floor(newHeight / this.tileH);
        boolean hasRemainingColum = newWidth % this.tileW != 0.0;
        boolean hasRemainingRow = newHeight % this.tileH != 0.0;
        double remainingWidth = hasRemainingColum ? newWidth - this.tileW * (double)newCols : this.tileW;
        double remainingHeight = hasRemainingRow ? newHeight - this.tileH * (double)newRows : this.tileH;
        message = new StringBuffer("New matrix dimension is (cols,rows)==(").append(newCols).append(",").append(newRows).append(")");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        double minx = envelope.getMinimum(0);
        double miny = envelope.getMinimum(1);
        double maxx = envelope.getMaximum(0);
        double maxy = envelope.getMaximum(1);
        double _maxx = 0.0;
        double _maxy = 0.0;
        double _minx = 0.0;
        double _miny = 0.0;
        GridCoverage2D gc = null;
        int preScaleSteps = 0;
        int tempScale = this.scaleFactor;
        while ((tempScale /= 2) > 0) {
            ++preScaleSteps;
        }
        boolean doPrescaleSteps = false;
        if (Math.pow(2.0, preScaleSteps) == (double)this.scaleFactor) {
            --preScaleSteps;
        }
        double finalScale = (double)this.scaleFactor / Math.pow(2.0, preScaleSteps);
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)LENIENT_HINT);
        InterpolationNearest interpolation = null;
        ParameterValueGroup subsamplingParams = null;
        if (this.scaleAlgorithm.equalsIgnoreCase("nn")) {
            subsamplingParams = processor.getOperation("Scale").getParameters();
            interpolation = new InterpolationNearest();
            doPrescaleSteps = true;
        } else if (this.scaleAlgorithm.equalsIgnoreCase("filt")) {
            subsamplingParams = processor.getOperation("FilteredSubsample").getParameters();
            interpolation = new InterpolationNearest();
            boolean bl = doPrescaleSteps = this.scaleFactor % 2 == 0;
            if (!doPrescaleSteps) {
                finalScale = this.scaleFactor;
            }
        } else if (this.scaleAlgorithm.equalsIgnoreCase("bil")) {
            subsamplingParams = processor.getOperation("Scale").getParameters();
            interpolation = new InterpolationBilinear();
            doPrescaleSteps = true;
        } else if (this.scaleAlgorithm.equalsIgnoreCase("avg")) {
            subsamplingParams = processor.getOperation("SubsampleAverage").getParameters();
            interpolation = new InterpolationNearest();
            boolean bl = doPrescaleSteps = this.scaleFactor % 2 == 0;
            if (!doPrescaleSteps) {
                finalScale = this.scaleFactor;
            }
        } else {
            throw new IllegalArgumentException("The provided scale algorithm is not availaible");
        }
        double totalNumberOfFile = (newRows += hasRemainingRow ? 1 : 0) * (newCols += hasRemainingColum ? 1 : 0);
        double tileGeoWidth = envelope.getLength(0) / (double)newCols;
        double tileGeoHeight = envelope.getLength(1) / (double)newRows;
        ParameterValue noFakeTileParameter = (ParameterValue)ImageMosaicFormat.DONT_CREATE_EMPTY_TILES.createValue();
        noFakeTileParameter.setValue(true);
        for (int i = 0; i < newRows; ++i) {
            for (int j = 0; j < newCols; ++j) {
                File fileOut;
                _maxx = minx + (double)(j + 1) * tileGeoWidth;
                _minx = minx + (double)j * tileGeoWidth;
                _maxy = miny + (double)(i + 1) * tileGeoHeight;
                _miny = miny + (double)i * tileGeoHeight;
                if (_maxx > maxx) {
                    _maxx = maxx;
                }
                if (_maxy > maxy) {
                    _maxy = maxy;
                }
                if ((fileOut = new File(this.outputLocation, "mosaic" + "_" + Integer.toString(i * newCols + j) + "." + "tiff")).exists()) {
                    fileOut.delete();
                }
                message = new StringBuffer("Preparing tile (col,row)==(").append(j).append(",").append(i).append(") to file ").append(fileOut);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                ParameterValue gg = (ParameterValue)ImageMosaicFormat.READ_GRIDGEOMETRY2D.createValue();
                GeneralEnvelope cropEnvelope = new GeneralEnvelope(new double[]{_minx, _miny}, new double[]{_maxx, _maxy});
                cropEnvelope.setCoordinateReferenceSystem(inReader.getCrs());
                gg.setValue((Object)new GridGeometry2D((GridRange)new GeneralGridRange(new Rectangle(0, 0, 800, 800)), (Envelope)cropEnvelope));
                message = new StringBuffer("Reading with grid envelope ").append(cropEnvelope.toString());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                try {
                    gc = (GridCoverage2D)inReader.read(new GeneralParameterValue[]{gg, noFakeTileParameter});
                    if (gc == null) {
                        continue;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    this.fireEvent(e.getLocalizedMessage(), 0.0);
                    return;
                }
                ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
                param.parameter("Source").setValue((Object)gc);
                param.parameter("ConserveEnvelope").setValue(true);
                param.parameter("Envelope").setValue((Object)cropEnvelope);
                GridCoverage2D cropped = (GridCoverage2D)processor.doOperation(param);
                GeneralGridRange newGridrange = new GeneralGridRange(new Rectangle((int)Math.round(tileGeoWidth * (double)newCols), (int)Math.round(tileGeoHeight * (double)newRows)));
                GridGeometry2D scaledGridGeometry = new GridGeometry2D((GridRange)newGridrange, (Envelope)cropEnvelope);
                param = processor.getOperation("Resample").getParameters();
                param.parameter("Source").setValue((Object)cropped);
                param.parameter("CoordinateReferenceSystem").setValue((Object)inReader.getCrs());
                param.parameter("GridGeometry").setValue((Object)scaledGridGeometry);
                param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
                gc = (GridCoverage2D)processor.doOperation(param);
                if (doPrescaleSteps && LOGGER.isLoggable(Level.FINE)) {
                    message = new StringBuffer("Pre scaling...");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                }
                for (int k = 0; k < preScaleSteps && doPrescaleSteps; ++k) {
                    param = filteredSubsampleFactory.getParameters();
                    param.parameter("source").setValue((Object)gc);
                    param.parameter("scaleX").setValue((Object)new Integer(2));
                    param.parameter("scaleY").setValue((Object)new Integer(2));
                    param.parameter("qsFilterArray").setValue((Object)new float[]{1.0f});
                    param.parameter("Interpolation").setValue((Object)new InterpolationBilinear());
                    gc = (GridCoverage2D)filteredSubsampleFactory.doOperation(param, null);
                }
                message = new StringBuffer("Scaling...");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), 0.0);
                if (this.scaleAlgorithm.equalsIgnoreCase("nn")) {
                    param = processor.getOperation("Scale").getParameters();
                    param.parameter("Source").setValue((Object)gc);
                    param.parameter("xScale").setValue((Object)new Float(1.0 / finalScale));
                    param.parameter("yScale").setValue((Object)new Float(1.0 / finalScale));
                    param.parameter("xTrans").setValue((Object)new Float(0.0f));
                    param.parameter("yTrans").setValue((Object)new Float(0.0f));
                    param.parameter("Interpolation").setValue((Object)Interpolation.getInstance((int)1));
                    gc = (GridCoverage2D)scaleFactory.doOperation(param, null);
                } else if (this.scaleAlgorithm.equalsIgnoreCase("filt")) {
                    param = (ParameterValueGroup)subsamplingParams.clone();
                    param.parameter("source").setValue((Object)gc);
                    param.parameter("scaleX").setValue((Object)new Integer((int)finalScale));
                    param.parameter("scaleY").setValue((Object)new Integer((int)finalScale));
                    param.parameter("qsFilterArray").setValue((Object)new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f});
                    param.parameter("Interpolation").setValue((Object)new InterpolationNearest());
                    gc = (GridCoverage2D)filteredSubsampleFactory.doOperation(param, null);
                } else if (this.scaleAlgorithm.equalsIgnoreCase("bil")) {
                    param = processor.getOperation("Scale").getParameters();
                    param.parameter("Source").setValue((Object)gc);
                    param.parameter("xScale").setValue((Object)new Float(1.0 / finalScale));
                    param.parameter("yScale").setValue((Object)new Float(1.0 / finalScale));
                    param.parameter("xTrans").setValue((Object)new Float(0.0f));
                    param.parameter("yTrans").setValue((Object)new Float(0.0f));
                    param.parameter("Interpolation").setValue((Object)Interpolation.getInstance((int)1));
                    gc = (GridCoverage2D)scaleFactory.doOperation(param, null);
                } else if (this.scaleAlgorithm.equalsIgnoreCase("avg")) {
                    param = processor.getOperation("SubsampleAverage").getParameters();
                    param.parameter("Source").setValue((Object)gc);
                    param.parameter("scaleX").setValue((Object)new Double(1.0 / finalScale));
                    param.parameter("scaleY").setValue((Object)new Double(1.0 / finalScale));
                    param.parameter("Interpolation").setValue((Object)interpolation);
                    gc = (GridCoverage2D)subsampleAvgFactory.doOperation(param, null);
                } else {
                    throw new IllegalArgumentException("The provided scale algorithm is not availaible");
                }
                message = new StringBuffer("Writing out...");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                try {
                    GeoTiffFormat geoTiffFormat = new GeoTiffFormat();
                    GeoTiffWriteParams wp = new GeoTiffWriteParams();
                    wp.setCompressionMode(2);
                    wp.setCompressionType("LZW");
                    wp.setCompressionQuality(1.0f);
                    wp.setTilingMode(2);
                    wp.setTiling(256, 256);
                    ParameterValueGroup params = geoTiffFormat.getWriteParameters();
                    params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
                    GeoTiffWriter writerWI = new GeoTiffWriter((Object)fileOut);
                    writerWI.write((GridCoverage)gc, params.values().toArray(new GeneralParameterValue[1]));
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    this.fireEvent(e.getLocalizedMessage(), 0.0);
                    return;
                }
            }
        }
        message = new StringBuffer("Done...");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 100.0);
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public final void setInputLocation(File inputLocation) {
        this.inputLocation = inputLocation;
    }

    public final void setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
    }

    public final String getOutputFormat() {
        return this.outputFormat;
    }

    public final void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public final String getScaleAlgorithm() {
        return this.scaleAlgorithm;
    }

    public final void setScaleAlgorithm(String scaleAlgorithm) {
        this.scaleAlgorithm = scaleAlgorithm;
    }

    public final int getScaleFactor() {
        return this.scaleFactor;
    }

    public final void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public File getInputLocation() {
        return this.inputLocation;
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    public final int getTileCacheSize() {
        return this.tileCacheSize;
    }

    public final void setTileCacheSize(int tileCacheSize) {
        this.tileCacheSize = tileCacheSize;
    }

    public final double getTileH() {
        return this.tileH;
    }

    public final void setTileH(int tileH) {
        this.tileH = tileH;
    }

    public final double getTileW() {
        return this.tileW;
    }

    public final void setTileW(int tileW) {
        this.tileW = tileW;
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        outputFormats = new ArrayList(6);
        outputFormats.add("tiff");
        outputFormats.add("tif");
        outputFormats.add("gtiff");
        outputFormats.add("gtif");
        outputFormats.add("png");
        outputFormats.add("jpeg");
        LOGGER = Logger.getLogger(PyramidLayerBuilder.class.toString());
        LENIENT_HINT = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
        filteredSubsampleFactory = new FilteredSubsample();
        subsampleAvgFactory = new SubsampleAverage();
        scaleFactory = new Scale();
    }
}

