/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.utils.progress;

import it.geosolutions.utils.progress.ExceptionEvent;
import it.geosolutions.utils.progress.ProcessingEvent;
import it.geosolutions.utils.progress.ProcessingEventListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;

public abstract class ProgressManager {
    protected final List cmdOpts = new ArrayList(5);
    protected final Parser cmdParser = new Parser();
    protected final ArgumentBuilder arguments = new ArgumentBuilder();
    protected final boolean sendDelayedMessages = false;
    private ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
    private volatile boolean stopThread = false;
    private List notificationListeners = new ArrayList();
    private static int DEFAULT_PRIORITY = 5;
    protected final DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
    protected Group optionsGroup;
    protected CommandLine cmdLine;
    protected Option helpOpt;
    protected DefaultOption priorityOpt;
    protected int priority = DEFAULT_PRIORITY;
    protected DefaultOption versionOpt;

    public final synchronized void addProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.add(listener);
    }

    public final synchronized void removeProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.remove(listener);
    }

    public final synchronized void removeAllProcessingEventListeners() {
        this.notificationListeners.clear();
    }

    protected synchronized void fireEvent(String string, double percentage) {
        String newLine = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer("Thread Name ");
        message.append(Thread.currentThread().getName()).append(newLine);
        message.append(this.getClass().toString()).append(newLine).append(string);
        ProcessingEvent evt = new ProcessingEvent(this, string, percentage);
        ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
        eventLauncher.setEvent(evt, this.notificationListeners.toArray());
        this.sendEvent(eventLauncher);
    }

    protected void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        eventLauncher.run();
    }

    protected synchronized void fireException(String string, double percentage, Exception ex) {
        String newLine = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer("Thread Name ");
        message.append(Thread.currentThread().getName()).append(newLine);
        message.append(this.getClass().toString()).append(newLine).append(string);
        ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
        ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
        eventLauncher.setEvent(evt, this.notificationListeners.toArray());
        this.sendEvent(eventLauncher);
    }

    protected synchronized void fireException(Exception ex) {
        this.fireException(ExceptionEvent.getMessageFromException(ex), -1.0, ex);
    }

    public final boolean getStopThread() {
        return this.stopThread;
    }

    public final void stopThread() {
        this.stopThread = true;
    }

    public void dispose() {
        this.removeAllProcessingEventListeners();
    }

    public abstract void run();

    protected static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            this.listeners = listeners;
            this.event = evt;
        }

        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }
}

