/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.wfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.geotools.catalog.AbstractGeoResource;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveDelta;
import org.geotools.catalog.Service;
import org.geotools.catalog.defaults.DefaultGeoResourceInfo;
import org.geotools.catalog.defaults.DefaultResolveChangeEvent;
import org.geotools.catalog.defaults.DefaultResolveDelta;
import org.geotools.catalog.wfs.WFSService;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.ows.FeatureSetDescription;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.feature.FeatureType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.ProgressListener;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSGeoResource
extends AbstractGeoResource {
    WFSService parent;
    String typename = null;
    private GeoResourceInfo info;

    private WFSGeoResource() {
    }

    public WFSGeoResource(WFSService parent, String typename) {
        this.parent = parent;
        this.typename = typename;
    }

    public URI getIdentifier() {
        try {
            return new URI(this.parent.getIdentifier().toString() + "#" + this.typename);
        }
        catch (URISyntaxException e) {
            return this.parent.getIdentifier();
        }
    }

    public Resolve.Status getStatus() {
        return this.parent.getStatus();
    }

    public Throwable getMessage() {
        return this.parent.getMessage();
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(Service.class)) {
            return this.parent;
        }
        if (adaptee.isAssignableFrom(WFSDataStore.class)) {
            return this.parent.resolve(adaptee, monitor);
        }
        if (adaptee.isAssignableFrom(GeoResource.class)) {
            return this;
        }
        if (adaptee.isAssignableFrom(GeoResourceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(FeatureStore.class)) {
            FeatureSource fs = this.parent.getDS().getFeatureSource(this.typename);
            if (fs instanceof FeatureStore) {
                return fs;
            }
            if (adaptee.isAssignableFrom(FeatureSource.class)) {
                return this.parent.getDS().getFeatureSource(this.typename);
            }
        }
        return null;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(GeoResourceInfo.class) || adaptee.isAssignableFrom(FeatureStore.class) || adaptee.isAssignableFrom(FeatureSource.class) || adaptee.isAssignableFrom(WFSDataStore.class) || adaptee.isAssignableFrom(Service.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoResourceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null && this.getStatus() != Resolve.Status.BROKEN) {
            WFSService.MyWFSDataStore myWFSDataStore = this.parent.getDS();
            synchronized (myWFSDataStore) {
                if (this.info == null) {
                    this.info = new IGeoResourceWFSInfo();
                }
            }
            DefaultResolveDelta delta = new DefaultResolveDelta((Resolve)((Object)this), ResolveDelta.Kind.CHANGED);
            DefaultResolveChangeEvent event = new DefaultResolveChangeEvent((Object)this, ResolveChangeEvent.Type.POST_CHANGE, (ResolveDelta)delta);
            ((Catalog)this.parent(monitor).parent(monitor)).fire((ResolveChangeEvent)event);
        }
        return this.info;
    }

    class IGeoResourceWFSInfo
    extends DefaultGeoResourceInfo {
        CoordinateReferenceSystem crs = null;

        IGeoResourceWFSInfo() throws IOException {
            FeatureType ft = WFSGeoResource.this.parent.getDS().getSchema(WFSGeoResource.this.typename);
            List fts = WFSGeoResource.this.parent.getDS().getCapabilities().getFeatureTypes();
            FeatureSetDescription fsd = null;
            if (fts != null) {
                Iterator i = fts.iterator();
                while (i.hasNext() && fsd == null) {
                    FeatureSetDescription t = (FeatureSetDescription)i.next();
                    if (t == null || !WFSGeoResource.this.typename.equals(t.getName())) continue;
                    fsd = t;
                }
            }
            this.bounds = new ReferencedEnvelope(fsd.getLatLongBoundingBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.description = fsd.getAbstract();
            try {
                this.crs = ft.getDefaultGeometry().getCoordinateSystem();
            }
            catch (Exception e) {
                this.crs = DefaultGeographicCRS.WGS84;
            }
            this.name = WFSGeoResource.this.typename;
            this.schema = ft.getNamespace();
            this.title = fsd.getTitle();
            this.keywords = new String[]{"wfs", WFSGeoResource.this.typename, ft.getNamespace().toString()};
        }

        public CoordinateReferenceSystem getCRS() {
            if (this.crs != null) {
                return this.crs;
            }
            return super.getCRS();
        }
    }
}

