/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.wfs;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.geotools.catalog.AbstractService;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveDelta;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultResolveChangeEvent;
import org.geotools.catalog.defaults.DefaultResolveDelta;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.catalog.wfs.WFSGeoResource;
import org.geotools.data.DataStore;
import org.geotools.data.ows.WFSCapabilities;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.util.ProgressListener;
import org.geotools.xml.wfs.WFSSchema;
import org.xml.sax.SAXException;

public class WFSService
extends AbstractService {
    private URI uri = null;
    private Map params = null;
    private List members = null;
    private ServiceInfo info = null;
    private Throwable msg = null;
    private MyWFSDataStore ds = null;

    public WFSService(Catalog parent, URI uri, Map params) {
        super(parent);
        this.uri = uri;
        this.params = params;
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(ServiceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return this.members(monitor);
        }
        if (adaptee.isAssignableFrom(WFSDataStore.class)) {
            return this.getDS();
        }
        return null;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(ServiceInfo.class) || adaptee.isAssignableFrom(List.class) || adaptee.isAssignableFrom(WFSDataStore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List members(ProgressListener monitor) throws IOException {
        if (this.members == null) {
            MyWFSDataStore myWFSDataStore = this.getDS();
            synchronized (myWFSDataStore) {
                if (this.members == null) {
                    this.members = new LinkedList();
                    String[] typenames = this.ds.getTypeNames();
                    if (typenames != null) {
                        for (int i = 0; i < typenames.length; ++i) {
                            this.members.add(new WFSGeoResource(this, typenames[i]));
                        }
                    }
                }
            }
        }
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo(ProgressListener monitor) throws IOException {
        this.getDS();
        if (this.info == null && this.ds != null) {
            MyWFSDataStore myWFSDataStore = this.ds;
            synchronized (myWFSDataStore) {
                if (this.info == null) {
                    this.info = new IServiceWFSInfo(this.ds);
                }
            }
            Catalog parent = (Catalog)this.parent(monitor);
            if (parent != null) {
                DefaultResolveDelta delta = new DefaultResolveDelta((Resolve)((Object)this), ResolveDelta.Kind.CHANGED);
                DefaultResolveChangeEvent event = new DefaultResolveChangeEvent((Object)this, ResolveChangeEvent.Type.POST_CHANGE, (ResolveDelta)delta);
                parent.fire((ResolveChangeEvent)event);
            }
        }
        return this.info;
    }

    public Map getConnectionParams() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyWFSDataStore getDS() throws IOException {
        if (this.ds == null) {
            Class clazz = MyWFSDataStore.class;
            synchronized (clazz) {
                MyWFSDataStoreFactory dsf;
                if (this.ds == null && (dsf = new MyWFSDataStoreFactory()).canProcess(this.params)) {
                    try {
                        this.ds = (MyWFSDataStore)((Object)dsf.createDataStore(this.params));
                    }
                    catch (IOException e) {
                        this.msg = e;
                        throw e;
                    }
                }
            }
            Catalog parent = (Catalog)this.parent(null);
            if (parent != null) {
                DefaultResolveDelta delta = new DefaultResolveDelta((Resolve)((Object)this), ResolveDelta.Kind.CHANGED);
                DefaultResolveChangeEvent event = new DefaultResolveChangeEvent((Object)this, ResolveChangeEvent.Type.POST_CHANGE, (ResolveDelta)delta);
                parent.fire((ResolveChangeEvent)event);
            }
        }
        return this.ds;
    }

    public Resolve.Status getStatus() {
        return this.msg != null ? Resolve.Status.BROKEN : (this.ds == null ? Resolve.Status.NOTCONNECTED : Resolve.Status.CONNECTED);
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URI getIdentifier() {
        return this.uri;
    }

    private class IServiceWFSInfo
    extends DefaultServiceInfo {
        private WFSCapabilities caps = null;

        IServiceWFSInfo(MyWFSDataStore resource) {
            try {
                this.caps = resource.getCapabilities();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.caps = null;
            }
        }

        public String getAbstract() {
            return this.caps == null ? null : (this.caps.getService() == null ? null : this.caps.getService().get_abstract());
        }

        public Icon getIcon() {
            return null;
        }

        public String[] getKeywords() {
            return this.caps == null ? null : (this.caps.getService() == null ? null : this.caps.getService().getKeywordList());
        }

        public URI getSchema() {
            return WFSSchema.NAMESPACE;
        }

        public String getDescription() {
            return WFSService.this.getIdentifier().toString();
        }

        public URI getSource() {
            return WFSService.this.getIdentifier();
        }

        public String getTitle() {
            return this.caps == null || this.caps.getService() == null ? (WFSService.this.getIdentifier() == null ? "BROKEN" : WFSService.this.getIdentifier().toString()) : this.caps.getService().getTitle();
        }
    }

    static class MyWFSDataStore
    extends WFSDataStore {
        MyWFSDataStore(URL host, Boolean protocol, String username, String password, int timeout, int buffer, boolean tryGZIP) throws SAXException, IOException {
            super(host, protocol, username, password, timeout, buffer, tryGZIP);
        }

        public WFSCapabilities getCapabilities() {
            return this.capabilities;
        }

        protected static URL createGetCapabilitiesRequest(URL host) {
            return WFSDataStore.createGetCapabilitiesRequest(host);
        }
    }

    private static class MyWFSDataStoreFactory
    extends WFSDataStoreFactory {
        private MyWFSDataStoreFactory() {
        }

        public DataStore createNewDataStore(Map params) throws IOException {
            Boolean b;
            Integer i;
            URL host = (URL)URL.lookUp(params);
            Boolean protocol = (Boolean)PROTOCOL.lookUp(params);
            String pass = null;
            String user = null;
            int timeout = 3000;
            int buffer = 10;
            boolean tryGZIP = true;
            if (params.containsKey(MyWFSDataStoreFactory.TIMEOUT.key) && (i = (Integer)TIMEOUT.lookUp(params)) != null) {
                timeout = i;
            }
            if (params.containsKey(MyWFSDataStoreFactory.BUFFER_SIZE.key) && (i = (Integer)BUFFER_SIZE.lookUp(params)) != null) {
                buffer = i;
            }
            if (params.containsKey(MyWFSDataStoreFactory.TRY_GZIP.key) && (b = (Boolean)TRY_GZIP.lookUp(params)) != null) {
                tryGZIP = b;
            }
            if (params.containsKey(MyWFSDataStoreFactory.USERNAME.key)) {
                user = (String)USERNAME.lookUp(params);
            }
            if (params.containsKey(MyWFSDataStoreFactory.PASSWORD.key)) {
                pass = (String)PASSWORD.lookUp(params);
            }
            if (user == null && pass != null || pass == null && user != null) {
                throw new IOException("Username / password cannot be null");
            }
            MyWFSDataStore ds = null;
            try {
                ds = new MyWFSDataStore(host, protocol, user, pass, timeout, buffer, tryGZIP);
                this.cache.put(params, ds);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            return ds;
        }
    }
}

