/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.wfs;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFactory;
import org.geotools.catalog.wfs.WFSService;
import org.geotools.data.wfs.WFSDataStoreFactory;

public class WFSServiceFactory
implements ServiceFactory {
    private static WFSDataStoreFactory wfsDSFactory;

    public static WFSDataStoreFactory getWFSDSFactory() {
        if (wfsDSFactory == null) {
            wfsDSFactory = new WFSDataStoreFactory();
        }
        return wfsDSFactory;
    }

    public Service createService(Catalog parent, URI id, Map params) {
        if (params == null || !params.containsKey(WFSDataStoreFactory.URL.key)) {
            return null;
        }
        try {
            if (id == null) {
                URL base = (URL)params.get(WFSDataStoreFactory.URL.key);
                base = base == null ? null : WFSService.MyWFSDataStore.createGetCapabilitiesRequest(base);
                return new WFSService(parent, new URI(base.toExternalForm()), params);
            }
            return new WFSService(parent, id, params);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Map createParams(URI uri) {
        URL url;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (!WFSServiceFactory.isWFS(url)) {
            return null;
        }
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(WFSDataStoreFactory.URL.key, url);
        return params;
    }

    public boolean canProcess(URI uri) {
        try {
            URL url = uri.toURL();
            return WFSServiceFactory.isWFS(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static final boolean isWFS(URL url) {
        String PATH = url.getPath();
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=") != -1) {
            return QUERY.toUpperCase().indexOf("SERVICE=WFS") != -1;
        }
        if (PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WFS") != -1) {
            return true;
        }
        return true;
    }
}

