/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.visitor.DuplicatorFilterVisitor;

public interface Action {
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 4;

    public int getType();

    public Filter getFilter();

    public String getTypeName();

    public static class InsertAction
    implements Action {
        private final Feature feature;

        public InsertAction(Feature f) {
            Feature feature;
            try {
                feature = f.getFeatureType().duplicate(f);
            }
            catch (IllegalAttributeException e) {
                Logger.getLogger("org.geotools.data.wfs").warning("Failed to duplicate feature:" + f);
                feature = f;
            }
            this.feature = feature;
        }

        public int getType() {
            return 1;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public String getTypeName() {
            return this.feature == null ? null : this.feature.getFeatureType().getTypeName();
        }

        public Filter getFilter() {
            return this.feature.getID() == null ? null : FilterFactoryFinder.createFilterFactory().createFidFilter(this.feature.getID());
        }

        public String toString() {
            return "INSERT " + this.feature;
        }
    }

    public static class DeleteAction
    implements Action {
        private final Filter filter;
        private final String typeName;

        public DeleteAction(String typeName, Filter f) {
            DuplicatorFilterVisitor visitor = new DuplicatorFilterVisitor(FilterFactoryFinder.createFilterFactory(), false);
            f.accept((FilterVisitor)visitor);
            this.filter = (Filter)visitor.getCopy();
            this.typeName = typeName;
        }

        public int getType() {
            return 4;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String toString() {
            return "REMOVE " + this.filter;
        }
    }

    public static class UpdateAction
    implements Action {
        private final Filter filter;
        private final Map properties;
        private final String typeName;

        public UpdateAction(String typeName, Filter f, Map properties) {
            DuplicatorFilterVisitor visitor = new DuplicatorFilterVisitor(FilterFactoryFinder.createFilterFactory(), false);
            f.accept((FilterVisitor)visitor);
            this.filter = (Filter)visitor.getCopy();
            this.properties = new HashMap(properties);
            this.typeName = typeName;
        }

        public int getType() {
            return 2;
        }

        public Object getProperty(String name) {
            return this.properties == null ? null : this.properties.get(name);
        }

        public String[] getPropertyNames() {
            return this.properties == null ? new String[]{} : this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
        }

        public Map getProperties() {
            return this.properties == null ? null : new HashMap(this.properties);
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void update(Feature feature) {
            if (!this.filter.contains(feature)) {
                throw new IllegalArgumentException(feature + "is not affected by this update, only call update on features that" + "the Action applies to!");
            }
            String[] propNames = this.getPropertyNames();
            for (int j = 0; j < propNames.length; ++j) {
                try {
                    feature.setAttribute(propNames[j], this.getProperty(propNames[j]));
                    continue;
                }
                catch (IllegalAttributeException e) {
                    NoSuchElementException ee = new NoSuchElementException(e.getMessage());
                    ee.initCause(e);
                    throw ee;
                }
            }
        }

        public String toString() {
            return "UPDATE " + this.filter + " " + this.properties;
        }
    }
}

