/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;

public class FidFilterVisitor
implements FilterVisitor {
    private Stack current = new Stack();
    private Map fidMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FidFilterVisitor(Map fidMap) {
        this.fidMap = fidMap;
    }

    public void visit(Filter filter) {
        if (filter instanceof FidFilter) {
            FidFilter ff = (FidFilter)filter;
            this.visit(ff);
        } else if (filter instanceof LogicFilter) {
            LogicFilter lf = (LogicFilter)filter;
            this.visit(lf);
        } else {
            this.current.push(filter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visit(LogicFilter filter) {
        void var3_3;
        int stop = this.current.size();
        Iterator iter = filter.getFilterIterator();
        while (iter.hasNext()) {
            ((Filter)iter.next()).accept(this);
        }
        switch (filter.getFilterType()) {
            case 2: {
                Filter newFilter = (Filter)this.current.pop();
                while (this.current.size() > stop) {
                    newFilter = newFilter.and((Filter)this.current.pop());
                }
                break;
            }
            case 1: {
                Filter newFilter = (Filter)this.current.pop();
                while (this.current.size() > stop) {
                    newFilter = newFilter.or((Filter)this.current.pop());
                }
                break;
            }
            case 3: {
                if (!$assertionsDisabled && this.current.size() - stop != 1) {
                    throw new AssertionError();
                }
                Filter newFilter = (Filter)this.current.pop();
                newFilter = newFilter.not();
                break;
            }
            default: {
                throw new IllegalArgumentException("Bug in FidFilterVisitor.  " + filter + " was not correctly handled by visitor");
            }
        }
        this.current.push(var3_3);
    }

    public void visit(FidFilter filter) {
        String[] fids = filter.getFids();
        FidFilter newFilter = FilterFactoryFinder.createFilterFactory().createFidFilter();
        for (int i = 0; i < fids.length; ++i) {
            String target = this.getFinalFid(fids[i]);
            newFilter.addFid(target);
        }
        this.current.push(newFilter);
    }

    public synchronized String getFinalFid(String fid) {
        String finalFid = (String)this.fidMap.get(fid);
        if (finalFid == null) {
            return fid;
        }
        return finalFid;
    }

    public void visit(BetweenFilter filter) {
        this.current.push(filter);
    }

    public void visit(CompareFilter filter) {
        this.current.push(filter);
    }

    public void visit(GeometryFilter filter) {
        this.current.push(filter);
    }

    public void visit(LikeFilter filter) {
        this.current.push(filter);
    }

    public void visit(NullFilter filter) {
        this.current.push(filter);
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(MathExpression expression) {
    }

    public void visit(FunctionExpression expression) {
    }

    public Filter getProcessedFilter() {
        if (!$assertionsDisabled && this.current.size() != 1) {
            throw new AssertionError();
        }
        return (Filter)this.current.peek();
    }

    static {
        $assertionsDisabled = !FidFilterVisitor.class.desiredAssertionStatus();
    }
}

