/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.StrictWFSStrategy;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSStrategy;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;

public class MapServerWFSStrategy
extends StrictWFSStrategy
implements WFSStrategy {
    public MapServerWFSStrategy(WFSDataStore store) {
        super(store);
    }

    protected FeatureReader createFeatureReader(Transaction transaction, Query query) throws IOException {
        return new MapServerWFSFeatureReader(transaction, query, COMPLIANCE_LEVEL);
    }

    protected class MapServerWFSFeatureReader
    extends StrictWFSStrategy.StrictFeatureReader {
        public MapServerWFSFeatureReader(Transaction transaction, Query query, Integer level) throws IOException {
            super(MapServerWFSStrategy.this, transaction, query, level);
        }

        protected void init(Transaction transaction, Query query, Integer level) throws IOException {
            Query query2;
            Filter filter = query.getFilter();
            if (filter == Filter.NONE) {
                FilterFactory fac = FilterFactoryFinder.createFilterFactory();
                try {
                    String attName = MapServerWFSStrategy.this.store.getSchema(query.getTypeName()).getDefaultGeometry().getName();
                    GeometryFilter newFilter = fac.createGeometryFilter((short)4);
                    newFilter.addLeftGeometry(fac.createBBoxExpression(MapServerWFSStrategy.this.store.getBounds((Query)new DefaultQuery(query.getTypeName()))));
                    newFilter.addRightGeometry(fac.createAttributeExpression(attName));
                    query2 = new DefaultQuery(query.getTypeName(), query.getNamespace(), (Filter)newFilter, query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
                }
                catch (IllegalFilterException e) {
                    query2 = query;
                }
            } else {
                query2 = query;
            }
            super.init(transaction, query2, level);
        }
    }
}

