/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.logging.Level;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.ows.FeatureSetDescription;
import org.geotools.data.ows.WFSCapabilities;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.WFSStrategy;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.xml.sax.SAXException;

class NonStrictWFSStrategy
implements WFSStrategy {
    protected WFSDataStore store;

    public NonStrictWFSStrategy(WFSDataStore store) {
        this.store = store;
    }

    public FeatureReader getFeatureReader(Query query2, Transaction transaction) throws IOException {
        Filter[] filters1;
        DefaultQuery query = new DefaultQuery(query2);
        Filter processedFilter = this.store.processFilter(query.getFilter());
        query.setFilter(processedFilter);
        Filter[] filters = filters1 = this.store.splitFilters((Query)query, transaction);
        Filter serverFilter = filters[0];
        Filter postFilter = filters[1];
        CoordinateReferenceSystem dataCRS = this.clipBBox((Query)query, serverFilter);
        query.setFilter(serverFilter);
        FeatureReader reader = this.createFeatureReader(transaction, (Query)query);
        if (reader.hasNext()) {
            if (reader.getFeatureType() != null) {
                reader = this.wrapWithFilteringFeatureReader(postFilter, reader, processedFilter);
                reader = this.applyReprojectionDecorator(reader, (Query)query, dataCRS);
                return reader;
            }
            throw new IOException("There are features but no feature type ... odd");
        }
        return new EmptyFeatureReader(this.store.getSchema(query.getTypeName()));
    }

    protected FeatureReader wrapWithFilteringFeatureReader(Filter postFilter, FeatureReader reader, Filter processedFilter) {
        if (!postFilter.equals(Filter.NONE)) {
            return new FilteringFeatureReader(reader, postFilter);
        }
        return reader;
    }

    protected FeatureReader createFeatureReader(Transaction transaction, Query query) throws IOException {
        Data data = this.createFeatureReaderPOST(query, transaction);
        if (data.reader == null) {
            data = this.createFeatureReaderGET(query, transaction);
        }
        if (data.reader == null && data.saxException != null) {
            throw new IOException(data.saxException.toString());
        }
        if (data.reader == null && data.ioException != null) {
            throw data.ioException;
        }
        return data.reader;
    }

    protected Data createFeatureReaderPOST(Query query, Transaction transaction) {
        Data data = new Data();
        if ((this.store.protocol & 1) == 1) {
            try {
                data.reader = this.store.getFeatureReaderPost(query, transaction);
                if (data.reader != null) {
                    data.reader.hasNext();
                }
            }
            catch (SAXException e) {
                data.reader = null;
                WFSDataStoreFactory.logger.warning(e.toString());
                data.saxException = e;
            }
            catch (IOException e) {
                data.reader = null;
                WFSDataStoreFactory.logger.warning(e.toString());
                data.ioException = e;
            }
        }
        return data;
    }

    protected Data createFeatureReaderGET(Query query, Transaction transaction) {
        Data data = new Data();
        if ((this.store.protocol & 2) == 2) {
            try {
                data.reader = this.store.getFeatureReaderGet(query, transaction);
                if (data.reader != null) {
                    data.reader.hasNext();
                }
            }
            catch (SAXException e) {
                data.reader = null;
                WFSDataStoreFactory.logger.warning(e.toString());
                data.saxException = e;
            }
            catch (IOException e) {
                data.reader = null;
                WFSDataStoreFactory.logger.warning(e.toString());
                data.ioException = e;
            }
        }
        return data;
    }

    protected FeatureReader applyReprojectionDecorator(FeatureReader reader, Query query, CoordinateReferenceSystem dataCRS) {
        FeatureReader tmp = reader;
        if (query.getCoordinateSystem() != null && !query.getCoordinateSystem().equals(reader.getFeatureType().getDefaultGeometry().getCoordinateSystem())) {
            try {
                reader = new ForceCoordinateSystemFeatureReader(reader, query.getCoordinateSystem());
            }
            catch (SchemaException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
                reader = tmp;
            }
        } else if (reader.getFeatureType().getDefaultGeometry() != null && dataCRS != null && reader.getFeatureType().getDefaultGeometry().getCoordinateSystem() == null) {
            try {
                reader = new ForceCoordinateSystemFeatureReader(reader, dataCRS);
            }
            catch (SchemaException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
                reader = tmp;
            }
        }
        return reader;
    }

    protected CoordinateReferenceSystem clipBBox(Query query, Filter serverFilter) {
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.store.capabilities, query.getTypeName());
        Envelope maxbbox = null;
        CoordinateReferenceSystem dataCRS = null;
        if (fsd.getSRS() != null) {
            try {
                dataCRS = CRS.decode((String)fsd.getSRS());
                MathTransform toDataCRS = CRS.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)dataCRS);
                maxbbox = JTS.transform((Envelope)fsd.getLatLongBoundingBox(), null, (MathTransform)toDataCRS, (int)10);
            }
            catch (FactoryException e) {
                WFSDataStoreFactory.logger.warning(e.getMessage());
                maxbbox = null;
            }
            catch (MismatchedDimensionException e) {
                WFSDataStoreFactory.logger.warning(e.getMessage());
                maxbbox = null;
            }
            catch (TransformException e) {
                WFSDataStoreFactory.logger.warning(e.getMessage());
                maxbbox = null;
            }
        } else {
            maxbbox = fsd.getLatLongBoundingBox();
        }
        if (maxbbox != null) {
            PostPreProcessFilterSplittingVisitor.WFSBBoxFilterVisitor clipVisitor = new PostPreProcessFilterSplittingVisitor.WFSBBoxFilterVisitor(maxbbox);
            serverFilter.accept((FilterVisitor)clipVisitor);
        } else {
            WFSDataStoreFactory.logger.log(Level.FINE, "Unable to clip your query against the latlongboundingbox element");
        }
        return dataCRS;
    }

    protected class Data {
        IOException ioException;
        SAXException saxException;
        FeatureReader reader;

        protected Data() {
        }
    }
}

