/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.NonStrictWFSStrategy;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterVisitor;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.filter.FilterEncodingPreProcessor;

class StrictWFSStrategy
extends NonStrictWFSStrategy {
    protected static final Integer COMPLIANCE_LEVEL = XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MEDIUM;

    public StrictWFSStrategy(WFSDataStore store) {
        super(store);
    }

    protected FeatureReader wrapWithFilteringFeatureReader(Filter postFilter, FeatureReader reader, Filter processedFilter) {
        FilterEncodingPreProcessor visitor = new FilterEncodingPreProcessor(COMPLIANCE_LEVEL);
        processedFilter.accept((FilterVisitor)visitor);
        if (visitor.requiresPostProcessing()) {
            return new FilteringFeatureReader(reader, processedFilter);
        }
        return new FilteringFeatureReader(reader, postFilter);
    }

    protected FeatureReader createFeatureReader(Transaction transaction, Query query) throws IOException {
        return new StrictFeatureReader(transaction, query, COMPLIANCE_LEVEL);
    }

    protected class StrictFeatureReader
    implements FeatureReader {
        private FeatureReader delegate;
        protected Filter filter;
        private Query query;
        private Transaction transaction;
        private Set foundFids = new HashSet();
        private Feature next;

        public StrictFeatureReader(Transaction transaction, Query query, Integer level) throws IOException {
            this.init(transaction, query, level);
        }

        protected void init(Transaction transaction, Query query, Integer level) throws IOException {
            FilterEncodingPreProcessor visitor = new FilterEncodingPreProcessor(level);
            query.getFilter().accept((FilterVisitor)visitor);
            this.transaction = transaction;
            if (visitor.requiresPostProcessing() && query.getPropertyNames() != Query.ALL_NAMES) {
                FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
                query.getFilter().accept((FilterVisitor)attributeExtractor);
                HashSet<String> properties = new HashSet<String>(attributeExtractor.getAttributeNameSet());
                properties.addAll(Arrays.asList(query.getPropertyNames()));
                this.query = new DefaultQuery(query.getTypeName(), query.getFilter(), query.getMaxFeatures(), properties.toArray(new String[0]), query.getHandle());
            } else {
                this.query = query;
            }
            this.filter = visitor.getFilter();
            DefaultQuery nonFidQuery = new DefaultQuery(query);
            FidFilter fidFilter = visitor.getFidFilter();
            nonFidQuery.setFilter((Filter)fidFilter);
            this.delegate = fidFilter.getFids().length > 0 ? StrictWFSStrategy.super.createFeatureReader(transaction, (Query)nonFidQuery) : this.nextReader();
        }

        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        public FeatureType getFeatureType() {
            return this.delegate.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (this.delegate == null) {
                return false;
            }
            if (!this.delegate.hasNext()) {
                this.delegate.close();
                this.delegate = null;
                this.delegate = this.nextReader();
                if (this.delegate == null) {
                    return false;
                }
            }
            try {
                while (this.next == null) {
                    if (!this.delegate.hasNext()) {
                        return false;
                    }
                    this.next = this.delegate.next();
                    if (!this.foundFids.contains(this.next.getID())) continue;
                    this.next = null;
                }
            }
            catch (IllegalAttributeException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return this.next != null;
        }

        private FeatureReader nextReader() throws IOException {
            if (this.filter == null || this.filter == Filter.ALL) {
                return null;
            }
            DefaultQuery query2 = new DefaultQuery(this.query);
            query2.setFilter(this.filter);
            FeatureReader nextReader = StrictWFSStrategy.super.createFeatureReader(this.transaction, (Query)query2);
            this.filter = null;
            return nextReader;
        }

        public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Feature tmp = this.next;
            this.foundFids.add(tmp.getID());
            this.next = null;
            return tmp;
        }
    }
}

