/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.ows.FeatureSetDescription;
import org.geotools.data.ows.WFSCapabilities;
import org.geotools.data.wfs.FidFilterVisitor;
import org.geotools.data.wfs.LogInputStream;
import org.geotools.data.wfs.LogWriterDecorator;
import org.geotools.data.wfs.MapServerWFSStrategy;
import org.geotools.data.wfs.StrictWFSStrategy;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.WFSFeatureReader;
import org.geotools.data.wfs.WFSFeatureSource;
import org.geotools.data.wfs.WFSFeatureStore;
import org.geotools.data.wfs.WFSFeatureType;
import org.geotools.data.wfs.WFSStrategy;
import org.geotools.data.wfs.WFSTransactionAccessor;
import org.geotools.data.wfs.WFSTransactionState;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.DocumentFactory;
import org.geotools.xml.DocumentWriter;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLComplexTypes;
import org.geotools.xml.gml.WFSFeatureTypeTransformer;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.wfs.WFSSchema;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.xml.sax.SAXException;

public class WFSDataStore
extends AbstractDataStore {
    protected WFSCapabilities capabilities = null;
    protected static final int AUTO_PROTOCOL = 3;
    protected static final int POST_PROTOCOL = 1;
    protected static final int GET_PROTOCOL = 2;
    protected int protocol = 3;
    protected Authenticator auth = null;
    private int bufferSize = 10;
    private int timeout = 10000;
    private final boolean tryGZIP;
    protected WFSStrategy strategy;
    private boolean lenient;
    private String[] typeNames = null;
    private Map featureTypeCache = new HashMap();
    private Map fidMap = new HashMap();
    private Map xmlSchemaCache = new HashMap();

    private WFSDataStore() {
        this.tryGZIP = true;
    }

    protected WFSDataStore(URL host, Boolean protocol, String username, String password, int timeout, int buffer, boolean tryGZIP) throws SAXException, IOException {
        this(host, protocol, username, password, timeout, buffer, tryGZIP, false);
    }

    protected WFSDataStore(URL host, Boolean protocol, String username, String password, int timeout, int buffer, boolean tryGZIP, boolean lenient) throws SAXException, IOException {
        super(true);
        this.lenient = lenient;
        if (username != null && password != null) {
            this.auth = new WFSAuthenticator(username, password);
        }
        this.protocol = protocol == null ? 3 : (protocol != false ? 1 : 2);
        this.timeout = timeout;
        this.bufferSize = buffer;
        this.tryGZIP = tryGZIP;
        this.findCapabilities(host);
        this.determineCorrectStrategy(host);
    }

    private void determineCorrectStrategy(URL host) {
        this.strategy = host.toString().indexOf("mapserv") != -1 ? new MapServerWFSStrategy(this) : new StrictWFSStrategy(this);
    }

    private void findCapabilities(URL host) throws SAXException, IOException {
        Object t = null;
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("DocumentFactory_VALIDATION_HINT", Boolean.FALSE);
        try {
            HttpURLConnection hc = this.getConnection(host, this.auth, false);
            InputStream is = this.getInputStream(hc);
            t = DocumentFactory.getInstance((InputStream)is, hints, (Level)WFSDataStoreFactory.logger.getLevel());
        }
        catch (Throwable e) {
            HttpURLConnection hc = this.getConnection(WFSDataStore.createGetCapabilitiesRequest(host), this.auth, false);
            InputStream is = this.getInputStream(hc);
            t = DocumentFactory.getInstance((InputStream)is, hints, (Level)WFSDataStoreFactory.logger.getLevel());
        }
        if (!(t instanceof WFSCapabilities)) {
            throw new SAXException("The specified URL Should have returned a 'WFSCapabilities' object. Returned a " + (t == null ? "null value." : t.getClass().getName() + " instance."));
        }
        this.capabilities = (WFSCapabilities)((Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection getConnection(URL url, Authenticator auth, boolean isPost) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (isPost) {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "text/xml, application/xml");
        } else {
            connection.setRequestMethod("GET");
        }
        connection.setDoInput(true);
        if (auth != null) {
            Class clazz = Authenticator.class;
            synchronized (clazz) {
                Authenticator.setDefault(auth);
                connection.connect();
                Authenticator.setDefault(null);
            }
        }
        if (this.tryGZIP) {
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        return connection;
    }

    protected static URL createGetCapabilitiesRequest(URL host) {
        if (host == null) {
            return null;
        }
        String url = host.toString();
        if (host.getQuery() == null) {
            url = url + "?SERVICE=WFS&VERSION=1.0.0&REQUEST=GetCapabilities";
        } else {
            String t = host.getQuery().toUpperCase();
            if (t.indexOf("SERVICE") == -1) {
                url = url + "&SERVICE=WFS";
            }
            if (t.indexOf("VERSION") == -1) {
                url = url + "&VERSION=1.0.0";
            }
            if (t.indexOf("REQUEST") == -1) {
                url = url + "&REQUEST=GetCapabilities";
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            WFSDataStoreFactory.logger.warning(e.toString());
            return host;
        }
    }

    public String[] getTypeNames() {
        if (this.typeNames == null) {
            List l = this.capabilities.getFeatureTypes();
            this.typeNames = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                this.typeNames[i] = ((FeatureSetDescription)l.get(i)).getName();
            }
        }
        return this.typeNames;
    }

    public FeatureType getSchema(String typeName) throws IOException {
        if (this.featureTypeCache.containsKey(typeName)) {
            return (FeatureType)this.featureTypeCache.get(typeName);
        }
        FeatureType t = null;
        SAXException sax = null;
        IOException io = null;
        if ((this.protocol & 1) == 1 && t == null) {
            try {
                t = this.getSchemaPost(typeName);
            }
            catch (SAXException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
                sax = e;
            }
            catch (IOException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
                io = e;
            }
        }
        if ((this.protocol & 2) == 2 && t == null) {
            try {
                t = this.getSchemaGet(typeName);
            }
            catch (SAXException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
                sax = e;
            }
            catch (IOException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
                io = e;
            }
        }
        if (t == null && sax != null) {
            throw new IOException(sax.toString());
        }
        if (t == null && io != null) {
            throw io;
        }
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.capabilities, typeName);
        String crsName = null;
        String ftName = null;
        if (fsd != null) {
            crsName = fsd.getSRS();
            ftName = fsd.getName();
            try {
                if (crsName != null) {
                    CoordinateReferenceSystem crs = CRS.decode((String)crsName);
                    t = WFSFeatureTypeTransformer.transform(t, crs);
                }
            }
            catch (FactoryException e) {
                WFSDataStoreFactory.logger.warning(e.getMessage());
            }
            catch (SchemaException e) {
                WFSDataStoreFactory.logger.warning(e.getMessage());
            }
        }
        if (ftName != null) {
            try {
                t = FeatureTypeBuilder.newFeatureType((AttributeType[])t.getAttributeTypes(), (String)(ftName == null ? typeName : ftName), (URI)t.getNamespace(), (boolean)t.isAbstract(), (FeatureType[])t.getAncestors(), (GeometryAttributeType)t.getDefaultGeometry());
            }
            catch (SchemaException e1) {
                WFSDataStoreFactory.logger.warning(e1.getMessage());
            }
        }
        try {
            URL url = this.getDescribeFeatureTypeURLGet(typeName);
            if (url != null) {
                t = new WFSFeatureType(t, new URI(url.toString()));
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (t != null) {
            this.featureTypeCache.put(typeName, t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureType getSchemaGet(String typeName) throws SAXException, IOException {
        Schema schema;
        URL getUrl = this.getDescribeFeatureTypeURLGet(typeName);
        Logger.getLogger("org.geotools.data.communication").fine("Output: " + getUrl);
        if (getUrl == null) {
            return null;
        }
        HttpURLConnection hc = this.getConnection(getUrl, this.auth, false);
        InputStream is = this.getInputStream(hc);
        try {
            schema = SchemaFactory.getInstance(null, (InputStream)is);
        }
        finally {
            is.close();
        }
        return WFSDataStore.parseDescribeFeatureTypeResponse(typeName, schema);
    }

    private URL getDescribeFeatureTypeURLGet(String typeName) throws MalformedURLException {
        URL getUrl = this.capabilities.getDescribeFeatureType().getGet();
        Logger.getLogger("org.geotools.data.communication").fine("Output: " + getUrl);
        if (getUrl == null) {
            return null;
        }
        String query = getUrl.getQuery();
        query = query == null ? null : query.toUpperCase();
        String url = getUrl.toString();
        if (query == null || "".equals(query)) {
            if (url == null || !url.endsWith("?")) {
                url = url + "?";
            }
            url = url + "SERVICE=WFS";
        } else if (query.indexOf("SERVICE=WFS") == -1) {
            url = url + "&SERVICE=WFS";
        }
        if (query == null || query.indexOf("VERSION") == -1) {
            url = url + "&VERSION=1.0.0";
        }
        if (query == null || query.indexOf("REQUEST") == -1) {
            url = url + "&REQUEST=DescribeFeatureType";
        }
        url = url + "&TYPENAME=" + typeName;
        getUrl = new URL(url);
        return getUrl;
    }

    static FeatureType parseDescribeFeatureTypeResponse(String typeName, Schema schema) throws SAXException {
        Element[] elements = schema.getElements();
        if (elements == null) {
            return null;
        }
        Element element = null;
        String ttname = typeName.substring(typeName.indexOf(":") + 1);
        for (int i = 0; i < elements.length && element == null; ++i) {
            if (!typeName.equals(elements[i].getName()) && !ttname.equals(elements[i].getName())) continue;
            element = elements[i];
        }
        if (element == null) {
            return null;
        }
        FeatureType ft = GMLComplexTypes.createFeatureType(element);
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureType getSchemaPost(String typeName) throws IOException, SAXException {
        Schema schema;
        URL postUrl = this.capabilities.getDescribeFeatureType().getPost();
        if (postUrl == null) {
            return null;
        }
        HttpURLConnection hc = this.getConnection(postUrl, this.auth, true);
        Writer osw = this.getOutputStream(hc);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("DocumentWriter_BASE_ELEMENT", WFSSchema.getInstance().getElements()[1]);
        List l = this.capabilities.getFeatureTypes();
        Iterator it = l.iterator();
        URI uri = null;
        while (it.hasNext() && uri == null) {
            FeatureSetDescription fsd = (FeatureSetDescription)it.next();
            if (!typeName.equals(fsd.getName())) continue;
            uri = fsd.getNamespace();
        }
        if (uri != null) {
            hints.put("DocumentWriter_SCHEMA_ORDER", new String[]{WFSSchema.NAMESPACE.toString(), uri.toString()});
        }
        try {
            DocumentWriter.writeDocument((Object)new String[]{typeName}, (Schema)WFSSchema.getInstance(), (Writer)osw, hints);
        }
        catch (OperationNotSupportedException e) {
            WFSDataStoreFactory.logger.warning(e.getMessage());
            throw new SAXException(e);
        }
        osw.flush();
        osw.close();
        InputStream is = this.getInputStream(hc);
        try {
            schema = SchemaFactory.getInstance(null, (InputStream)is);
        }
        finally {
            is.close();
        }
        return WFSDataStore.parseDescribeFeatureTypeResponse(typeName, schema);
    }

    protected FeatureReader getFeatureReaderGet(Query request, Transaction transaction) throws UnsupportedEncodingException, IOException, SAXException {
        FeatureType featureType;
        URL getUrl = this.capabilities.getGetFeature().getGet();
        if (getUrl == null) {
            return null;
        }
        String query = getUrl.getQuery();
        query = query == null ? null : query.toUpperCase();
        String url = getUrl.toString();
        if (query == null || "".equals(query)) {
            if (url == null || !url.endsWith("?")) {
                url = url + "?";
            }
            url = url + "SERVICE=WFS";
        } else if (query.indexOf("SERVICE=WFS") == -1) {
            url = url + "&SERVICE=WFS";
        }
        if (query == null || query.indexOf("VERSION") == -1) {
            url = url + "&VERSION=1.0.0";
        }
        if (query == null || query.indexOf("REQUEST") == -1) {
            url = url + "&REQUEST=GetFeature";
        }
        if (request != null) {
            if (request.getMaxFeatures() != Integer.MAX_VALUE) {
                url = url + "&MAXFEATURES=" + request.getMaxFeatures();
            }
            if (request.getFilter() != null) {
                if (request.getFilter().getFilterType() == 4) {
                    String bb = this.printBBoxGet((GeometryFilter)request.getFilter(), request.getTypeName());
                    if (bb != null) {
                        url = url + "&BBOX=" + URLEncoder.encode(bb, "UTF-8");
                    }
                } else if (request.getFilter().getFilterType() == 22) {
                    FidFilter ff = (FidFilter)request.getFilter();
                    if (ff.getFids() != null && ff.getFids().length > 0) {
                        url = url + "&FEATUREID=" + ff.getFids()[0];
                        for (int i = 1; i < ff.getFids().length; ++i) {
                            url = url + "," + ff.getFids()[i];
                        }
                    }
                } else if (request.getFilter() != Filter.NONE && request.getFilter() != Filter.ALL) {
                    url = url + "&FILTER=" + URLEncoder.encode(this.printFilter(request.getFilter()), "UTF-8");
                }
            }
        }
        url = url + "&TYPENAME=" + URLEncoder.encode(request.getTypeName(), "UTF-8");
        Logger.getLogger("org.geotools.data.wfs").fine(url);
        Logger.getLogger("org.geotools.data.communication").fine("Output: " + url);
        getUrl = new URL(url);
        HttpURLConnection hc = this.getConnection(getUrl, this.auth, false);
        InputStream is = this.getInputStream(hc);
        WFSTransactionState ts = null;
        if (transaction != Transaction.AUTO_COMMIT && (ts = (WFSTransactionState)transaction.getState((Object)this)) == null) {
            ts = new WFSTransactionState(this);
            transaction.putState((Object)this, ts);
        }
        WFSFeatureType schema = (WFSFeatureType)this.getSchema(request.getTypeName());
        try {
            featureType = DataUtilities.createSubType((FeatureType)schema.delegate, (String[])request.getPropertyNames(), (CoordinateReferenceSystem)request.getCoordinateSystem());
        }
        catch (SchemaException e) {
            featureType = schema.delegate;
        }
        WFSFeatureReader ft = WFSFeatureReader.getFeatureReader(is, this.bufferSize, this.timeout, ts, new WFSFeatureType(schema.delegate, schema.getSchemaURI(), this.lenient));
        if (!((Object)featureType).equals(ft.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            return new ReTypeFeatureReader((FeatureReader)((Object)ft), featureType, false);
        }
        return ft;
    }

    Writer getOutputStream(HttpURLConnection hc) throws IOException {
        OutputStream os = hc.getOutputStream();
        Writer w = new OutputStreamWriter(os);
        if (Logger.getLogger("org.geotools.data.wfs").isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, Logger.getLogger("org.geotools.data.wfs"), Level.FINE);
        }
        if (Logger.getLogger("org.geotools.data.communication").isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, Logger.getLogger("org.geotools.data.communication"), Level.FINE);
        }
        return w;
    }

    InputStream getInputStream(HttpURLConnection hc) throws IOException {
        InputStream is = hc.getInputStream();
        if (this.tryGZIP && hc.getContentEncoding() != null && hc.getContentEncoding().indexOf("gzip") != -1) {
            is = new GZIPInputStream(is);
        }
        is = new BufferedInputStream(is);
        if (WFSDataStoreFactory.logger.isLoggable(Level.FINE)) {
            is = new LogInputStream(is, WFSDataStoreFactory.logger, Level.FINE);
        }
        if (Logger.getLogger("org.geotools.data.communication").isLoggable(Level.FINE)) {
            is = new LogInputStream(is, Logger.getLogger("org.geotools.data.communication"), Level.FINE);
        }
        return is;
    }

    private String printFilter(Filter f) throws IOException, SAXException {
        HashMap<String, Element> hints = new HashMap<String, Element>();
        hints.put("DocumentWriter_BASE_ELEMENT", FilterSchema.getInstance().getElements()[2]);
        StringWriter w = new StringWriter();
        try {
            DocumentWriter.writeFragment((Object)f, (Schema)FilterSchema.getInstance(), (Writer)w, hints);
        }
        catch (OperationNotSupportedException e) {
            WFSDataStoreFactory.logger.warning(e.toString());
            throw new SAXException(e);
        }
        return w.toString();
    }

    private String printBBoxGet(GeometryFilter gf, String typename) throws IOException {
        Envelope e = null;
        if (gf.getLeftGeometry().getType() == 104) {
            e = ((Geometry)((LiteralExpression)gf.getLeftGeometry()).getLiteral()).getEnvelopeInternal();
        } else if (gf.getRightGeometry().getType() == 104) {
            LiteralExpression literal = (LiteralExpression)gf.getRightGeometry();
            Geometry geometry = (Geometry)literal.getLiteral();
            e = geometry.getEnvelopeInternal();
        } else {
            throw new IOException("Cannot encode BBOX:" + gf);
        }
        if (e == null || e.isNull()) {
            return null;
        }
        return e.getMinX() + "," + e.getMinY() + "," + e.getMaxX() + "," + e.getMaxY();
    }

    protected FeatureReader getFeatureReaderPost(Query query, Transaction transaction) throws SAXException, IOException {
        FeatureType featureType;
        URL postUrl = this.capabilities.getGetFeature().getPost();
        if (postUrl == null) {
            return null;
        }
        HttpURLConnection hc = this.getConnection(postUrl, this.auth, true);
        Writer w = this.getOutputStream(hc);
        HashMap<String, Element> hints = new HashMap<String, Element>();
        hints.put("DocumentWriter_BASE_ELEMENT", WFSSchema.getInstance().getElements()[2]);
        try {
            DocumentWriter.writeDocument((Object)query, (Schema)WFSSchema.getInstance(), (Writer)w, hints);
        }
        catch (OperationNotSupportedException e) {
            WFSDataStoreFactory.logger.warning(e.toString());
            throw new SAXException(e);
        }
        finally {
            w.flush();
            w.close();
        }
        InputStream is = this.getInputStream(hc);
        WFSTransactionState ts = null;
        if (transaction != Transaction.AUTO_COMMIT && (ts = (WFSTransactionState)transaction.getState((Object)this)) == null) {
            ts = new WFSTransactionState(this);
            transaction.putState((Object)this, ts);
        }
        WFSFeatureType schema = (WFSFeatureType)this.getSchema(query.getTypeName());
        try {
            featureType = DataUtilities.createSubType((FeatureType)schema.delegate, (String[])query.getPropertyNames(), (CoordinateReferenceSystem)query.getCoordinateSystem());
        }
        catch (SchemaException e) {
            featureType = schema.delegate;
        }
        WFSFeatureReader ft = WFSFeatureReader.getFeatureReader(is, this.bufferSize, this.timeout, ts, new WFSFeatureType(schema.delegate, schema.getSchemaURI(), this.lenient));
        if (!((Object)featureType).equals(ft.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            return new ReTypeFeatureReader((FeatureReader)((Object)ft), featureType, false);
        }
        return ft;
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getFeatureReader(typeName, (Query)new DefaultQuery(typeName));
    }

    protected FeatureReader getFeatureReader(String typeName, Query query) throws IOException {
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            DefaultQuery q = new DefaultQuery(typeName, query.getNamespace(), query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
            return this.getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
        }
        return this.getFeatureReader(query, Transaction.AUTO_COMMIT);
    }

    public FeatureReader getFeatureReader(Query query, Transaction transaction) throws IOException {
        return this.strategy.getFeatureReader(query, transaction);
    }

    protected Envelope getBounds(Query query) throws IOException {
        if (query == null || query.getTypeName() == null) {
            return super.getBounds(query);
        }
        List fts = this.capabilities.getFeatureTypes();
        Iterator i = fts.iterator();
        String queryName = query.getTypeName().substring(query.getTypeName().indexOf(":") + 1);
        while (i.hasNext()) {
            FeatureSetDescription fsd = (FeatureSetDescription)i.next();
            String fsdName = fsd.getName() == null ? null : fsd.getName().substring(fsd.getName().indexOf(":") + 1);
            if (!queryName.equals(fsdName)) continue;
            Envelope env = fsd.getLatLongBoundingBox();
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            try {
                return referencedEnvelope.transform(CRS.decode((String)fsd.getSRS()), true);
            }
            catch (NoSuchAuthorityCodeException e) {
                return referencedEnvelope;
            }
            catch (TransformException e) {
                return referencedEnvelope;
            }
            catch (FactoryException e) {
                return referencedEnvelope;
            }
        }
        return super.getBounds(query);
    }

    protected Filter[] splitFilters(Query q, Transaction t) throws IOException {
        if (q.getFilter() == null) {
            return new Filter[]{Filter.NONE, Filter.NONE};
        }
        if (q.getTypeName() == null || t == null) {
            return new Filter[]{Filter.NONE, q.getFilter()};
        }
        FeatureType ft = this.getSchema(q.getTypeName());
        List fts = this.capabilities.getFeatureTypes();
        boolean found = false;
        for (int i = 0; i < fts.size(); ++i) {
            String fsdName;
            if (fts.get(i) == null) continue;
            FeatureSetDescription fsd = (FeatureSetDescription)fts.get(i);
            if (ft.getTypeName().equals(fsd.getName())) {
                found = true;
                continue;
            }
            String string = fsdName = fsd.getName() == null ? null : fsd.getName().substring(fsd.getName().indexOf(":") + 1);
            if (!ft.getTypeName().equals(fsdName)) continue;
            found = true;
        }
        if (!found) {
            WFSDataStoreFactory.logger.warning("Could not find typeName: " + ft.getTypeName());
            return new Filter[]{Filter.NONE, q.getFilter()};
        }
        WFSTransactionState state = t == Transaction.AUTO_COMMIT ? null : (WFSTransactionState)t.getState((Object)this);
        WFSTransactionAccessor transactionAccessor = null;
        if (state != null) {
            transactionAccessor = new WFSTransactionAccessor(state.getActions(ft.getTypeName()));
        }
        PostPreProcessFilterSplittingVisitor wfsfv = new PostPreProcessFilterSplittingVisitor(this.capabilities.getFilterCapabilities(), ft, (ClientTransactionAccessor)transactionAccessor);
        q.getFilter().accept((FilterVisitor)wfsfv);
        Filter[] f = new Filter[]{wfsfv.getFilterPre(), wfsfv.getFilterPost()};
        return f;
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        try {
            return this.splitFilters((Query)new DefaultQuery(typeName, filter), Transaction.AUTO_COMMIT)[1];
        }
        catch (IOException e) {
            return filter;
        }
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.capabilities.getTransaction() != null) {
            return new WFSFeatureStore(this, typeName);
        }
        return new WFSFeatureSource(this, typeName);
    }

    public Filter processFilter(Filter filter) {
        FidFilterVisitor visitor = new FidFilterVisitor(this.fidMap);
        filter.accept(visitor);
        return visitor.getProcessedFilter();
    }

    public synchronized void addFidMapping(String original, String finalFid) {
        if (original == null) {
            throw new NullPointerException();
        }
        this.fidMap.put(original, finalFid);
    }

    private static class WFSAuthenticator
    extends Authenticator {
        private PasswordAuthentication pa;

        private WFSAuthenticator() {
        }

        public WFSAuthenticator(String user, String pass) {
            this.pa = new PasswordAuthentication(user, pass.toCharArray());
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pa;
        }
    }
}

