/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.wfs.WFSDataStore;
import org.xml.sax.SAXException;

public class WFSDataStoreFactory
extends AbstractDataStoreFactory {
    public static final DataStoreFactorySpi.Param URL = new DataStoreFactorySpi.Param("WFSDataStoreFactory:GET_CAPABILITIES_URL", URL.class, "Represents a URL to the getCapabilities document or a server instance.", true);
    public static final DataStoreFactorySpi.Param PROTOCOL = new DataStoreFactorySpi.Param("WFSDataStoreFactory:PROTOCOL", Boolean.class, "Sets a preference for the HTTP protocol to use when requesting WFS functionality. Set this value to Boolean.TRUE for POST, Boolean.FALSE for GET or NULL for AUTO", false);
    public static final DataStoreFactorySpi.Param USERNAME = new DataStoreFactorySpi.Param("WFSDataStoreFactory:USERNAME", String.class, "This allows the user to specify a username. This param should not be used without the PASSWORD param.", false);
    public static final DataStoreFactorySpi.Param PASSWORD = new DataStoreFactorySpi.Param("WFSDataStoreFactory:PASSWORD", String.class, "This allows the user to specify a username. This param should not be used without the USERNAME param.", false);
    public static final DataStoreFactorySpi.Param TIMEOUT = new DataStoreFactorySpi.Param("WFSDataStoreFactory:TIMEOUT", Integer.class, "This allows the user to specify a timeout in milliseconds. This param has a default value of 3000ms.", false);
    public static final DataStoreFactorySpi.Param BUFFER_SIZE = new DataStoreFactorySpi.Param("WFSDataStoreFactory:BUFFER_SIZE", Integer.class, "This allows the user to specify a buffer size in features. This param has a default value of 10 features.", false);
    public static final DataStoreFactorySpi.Param TRY_GZIP = new DataStoreFactorySpi.Param("WFSDataStoreFactory:TRY_GZIP", Boolean.class, "Indicates that datastore should use gzip to transfer data if the server supports it.  Default is true", false);
    public static final DataStoreFactorySpi.Param LENIENT = new DataStoreFactorySpi.Param("WFSDataStoreFactory:LENIENT", Boolean.class, "Indicates that datastore should do its best to create features from the provided data even if it does not accurately match the schema.  Errors will be logged but the parsing will continue if this is true.  Default is false", false);
    protected Map cache = new HashMap();
    protected static final Logger logger = WFSDataStoreFactory.logger();

    private static Logger logger() {
        Logger r = Logger.getLogger("org.geotools.data.wfs");
        return r;
    }

    public DataStore createDataStore(Map params) throws IOException {
        if (this.cache.containsKey(params)) {
            return (DataStore)this.cache.get(params);
        }
        return this.createNewDataStore(params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        Boolean b;
        Integer i;
        URL host = null;
        if (params.containsKey(WFSDataStoreFactory.URL.key)) {
            host = (URL)URL.lookUp(params);
        }
        Boolean protocol = null;
        if (params.containsKey(WFSDataStoreFactory.PROTOCOL.key)) {
            protocol = (Boolean)PROTOCOL.lookUp(params);
        }
        String pass = null;
        String user = null;
        int timeout = 3000;
        int buffer = 10;
        boolean tryGZIP = true;
        boolean lenient = false;
        if (params.containsKey(WFSDataStoreFactory.TIMEOUT.key) && (i = (Integer)TIMEOUT.lookUp(params)) != null) {
            timeout = i;
        }
        if (params.containsKey(WFSDataStoreFactory.BUFFER_SIZE.key) && (i = (Integer)BUFFER_SIZE.lookUp(params)) != null) {
            buffer = i;
        }
        if (params.containsKey(WFSDataStoreFactory.TRY_GZIP.key) && (b = (Boolean)TRY_GZIP.lookUp(params)) != null) {
            tryGZIP = b;
        }
        if (params.containsKey(WFSDataStoreFactory.LENIENT.key) && (b = (Boolean)LENIENT.lookUp(params)) != null) {
            lenient = b;
        }
        if (params.containsKey(WFSDataStoreFactory.USERNAME.key)) {
            user = (String)USERNAME.lookUp(params);
        }
        if (params.containsKey(WFSDataStoreFactory.PASSWORD.key)) {
            pass = (String)PASSWORD.lookUp(params);
        }
        if (user == null && pass != null || pass == null && user != null) {
            throw new IOException("Cannot define only one of USERNAME or PASSWORD, muct define both or neither");
        }
        WFSDataStore ds = null;
        try {
            ds = new WFSDataStore(host, protocol, user, pass, timeout, buffer, tryGZIP, lenient);
            this.cache.put(params, ds);
        }
        catch (SAXException e) {
            logger.warning(e.toString());
            throw new IOException(e.toString());
        }
        return ds;
    }

    public String getDescription() {
        return "The WFSDataStore represents a connection to a Web Feature Server. This connection provides access to the Features published by the server, and the ability to perform transactions on the server (when supported / allowed).";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{URL, PROTOCOL, USERNAME, PASSWORD, TIMEOUT, BUFFER_SIZE};
    }

    public boolean canProcess(Map params) {
        if (params == null) {
            return false;
        }
        if (!params.containsKey(WFSDataStoreFactory.URL.key)) {
            return false;
        }
        if (params.containsKey(WFSDataStoreFactory.USERNAME.key) ? !params.containsKey(WFSDataStoreFactory.PASSWORD.key) : params.containsKey(WFSDataStoreFactory.PASSWORD.key)) {
            return false;
        }
        if (params.containsKey(WFSDataStoreFactory.PROTOCOL.key)) {
            try {
                PROTOCOL.lookUp(params);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (params.containsKey(WFSDataStoreFactory.TIMEOUT.key)) {
            try {
                TIMEOUT.lookUp(params);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (params.containsKey(WFSDataStoreFactory.BUFFER_SIZE.key)) {
            try {
                BUFFER_SIZE.lookUp(params);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Web Feature Server";
    }

    public boolean isAvailable() {
        return true;
    }
}

