/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;

public class WFSFeatureSource
extends AbstractFeatureSource {
    protected WFSDataStore ds;
    protected String fname;

    protected WFSFeatureSource(WFSDataStore ds, String fname) {
        this.ds = ds;
        this.fname = fname;
    }

    public DataStore getDataStore() {
        return this.ds;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.ds.listenerManager.addFeatureListener((FeatureSource)((Object)this), listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.ds.listenerManager.removeFeatureListener((FeatureSource)((Object)this), listener);
    }

    public FeatureType getSchema() {
        try {
            return this.ds.getSchema(this.fname);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds(this.fname == null ? Query.ALL : new DefaultQuery(this.fname));
    }

    public Envelope getBounds(Query query) throws IOException {
        return this.ds.getBounds(this.namedQuery(query));
    }

    public FeatureCollection getFeatures() {
        return this.getFeatures((Query)new DefaultQuery(this.getSchema().getTypeName(), Filter.NONE));
    }

    public FeatureCollection getFeatures(Filter filter) {
        return this.getFeatures((Query)new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public FeatureCollection getFeatures(Query query) {
        return new DefaultFeatureResults((FeatureSource)((Object)this), query);
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public static class WFSFeatureResults
    extends DefaultFeatureResults
    implements FeatureResults {
        private WFSFeatureSource fs;
        private Query query;

        public WFSFeatureResults(WFSFeatureSource fs, Query query) {
            super((FeatureSource)((Object)fs), query);
            this.query = query;
            this.fs = fs;
        }

        public FeatureType getSchema() {
            return this.fs.getSchema();
        }

        public FeatureReader reader() throws IOException {
            return this.fs.ds.getFeatureReader(this.query, this.fs.getTransaction());
        }

        public Envelope getBounds() {
            try {
                return this.fs.getBounds(this.query);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getCount() throws IOException {
            return this.fs.getCount(this.query);
        }
    }
}

