/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.Action;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.WFSFeatureSource;
import org.geotools.data.wfs.WFSTransactionState;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSFeatureStore
extends WFSFeatureSource
implements FeatureStore {
    protected Transaction trans = Transaction.AUTO_COMMIT;

    public WFSFeatureStore(WFSDataStore ds, String typeName) {
        super(ds, typeName);
    }

    public Transaction getTransaction() {
        return this.trans;
    }

    public Set addFeatures(FeatureReader reader) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (reader.hasNext()) {
            try {
                Feature next = reader.next();
                features.add(next);
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        return this.addFeatures(DataUtilities.collection((Feature[])features.toArray(new Feature[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set addFeatures(FeatureCollection collection) throws IOException {
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState((Object)this.ds);
        HashSet<String> r = new HashSet<String>();
        AttributeType[] atrs = this.getSchema().getAttributeTypes();
        FeatureIterator iter = collection.features();
        try {
            Envelope bounds = null;
            while (iter.hasNext()) {
                try {
                    Feature newFeature;
                    try {
                        Feature f = iter.next();
                        newFeature = this.getSchema().create(f.getAttributes(new Object[this.getSchema().getAttributeCount()]), ts.nextFid(this.getSchema().getTypeName()));
                        r.add(newFeature.getID());
                    }
                    catch (IllegalAttributeException e) {
                        throw new IOException(e.getLocalizedMessage());
                    }
                    for (int i = 0; i < atrs.length; ++i) {
                        if (!(atrs[i] instanceof GeometryAttributeType)) continue;
                        Geometry g = (Geometry)newFeature.getAttribute(i);
                        CoordinateReferenceSystem cs = ((GeometryAttributeType)atrs[i]).getCoordinateSystem();
                        if (g == null) continue;
                        if (cs != null && !cs.getIdentifiers().isEmpty()) {
                            g.setUserData((Object)cs.getIdentifiers().iterator().next().toString());
                        }
                        if (bounds == null) {
                            bounds = new Envelope(g.getEnvelopeInternal());
                            continue;
                        }
                        bounds.expandToInclude(g.getEnvelopeInternal());
                    }
                    ts.addAction(this.getSchema().getTypeName(), new Action.InsertAction(newFeature));
                }
                catch (NoSuchElementException e) {
                    WFSDataStoreFactory.logger.warning(e.toString());
                    throw new IOException(e.toString());
                }
            }
            if (bounds == null) {
                ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), new Envelope(), false);
            } else {
                ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
            }
        }
        finally {
            iter.close();
        }
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
            String[] fids = ts.getFids(this.getSchema().getTypeName());
            r = new HashSet<String>(Arrays.asList(fids));
            return r;
        }
        return r;
    }

    public void removeFeatures(Filter filter2) throws IOException {
        Filter filter = this.ds.processFilter(filter2);
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState((Object)this.ds);
        ts.addAction(this.getSchema().getTypeName(), new Action.DeleteAction(this.getSchema().getTypeName(), filter));
        ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), new Envelope(), false);
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
        }
    }

    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter2) throws IOException {
        Filter filter = this.ds.processFilter(filter2);
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState((Object)this.ds);
        HashMap<String, Object> props = new HashMap<String, Object>();
        Envelope bounds = null;
        for (int i = 0; i < type.length; ++i) {
            if (type[i] instanceof GeometryAttributeType) {
                Geometry g = (Geometry)value[i];
                CoordinateReferenceSystem cs = ((GeometryAttributeType)type[i]).getCoordinateSystem();
                if (cs != null && !cs.getIdentifiers().isEmpty()) {
                    g.setUserData((Object)cs.getIdentifiers().iterator().next().toString());
                }
                g.setUserData((Object)cs.getIdentifiers().iterator().next().toString());
                if (cs != null && !cs.getIdentifiers().isEmpty()) {
                    g.setUserData((Object)cs.getIdentifiers().iterator().next().toString());
                }
                if (g == null) continue;
                if (bounds == null) {
                    bounds = new Envelope(g.getEnvelopeInternal());
                } else {
                    bounds.expandToInclude(g.getEnvelopeInternal());
                }
            }
            props.put(type[i].getName(), value[i]);
        }
        ts.addAction(this.getSchema().getTypeName(), new Action.UpdateAction(this.getSchema().getTypeName(), filter, props));
        if (bounds == null) {
            ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), new Envelope(), false);
        } else {
            ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
        }
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
        }
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeType[]{type}, new Object[]{value}, filter);
    }

    public void setFeatures(FeatureReader reader) throws IOException {
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState((Object)this.ds);
        ts.addAction(this.getSchema().getTypeName(), new Action.DeleteAction(this.getSchema().getTypeName(), Filter.NONE));
        Envelope bounds = null;
        while (reader.hasNext()) {
            try {
                Feature f = reader.next();
                AttributeType[] atrs = f.getFeatureType().getAttributeTypes();
                for (int i = 0; i < atrs.length; ++i) {
                    if (!(atrs[i] instanceof GeometryAttributeType)) continue;
                    Geometry g = (Geometry)f.getAttribute(i);
                    CoordinateReferenceSystem cs = ((GeometryAttributeType)atrs[i]).getCoordinateSystem();
                    if (cs != null && !cs.getIdentifiers().isEmpty()) {
                        g.setUserData((Object)cs.getIdentifiers().iterator().next().toString());
                    }
                    if (g == null) continue;
                    if (bounds == null) {
                        bounds = new Envelope(g.getEnvelopeInternal());
                        continue;
                    }
                    bounds.expandToInclude(g.getEnvelopeInternal());
                }
                ts.addAction(this.getSchema().getTypeName(), new Action.InsertAction(f));
            }
            catch (NoSuchElementException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
            }
            catch (IllegalAttributeException e) {
                WFSDataStoreFactory.logger.warning(e.toString());
            }
        }
        if (bounds == null) {
            ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), new Envelope(), false);
        } else {
            ((WFSDataStore)((Object)this.getDataStore())).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
        }
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
        }
    }

    public void setTransaction(Transaction transaction) {
        WFSTransactionState ts;
        if (transaction == null) {
            throw new NullPointerException("Should this not be Transaction.AutoCommit?");
        }
        this.trans = transaction;
        if (this.trans != Transaction.AUTO_COMMIT && (ts = (WFSTransactionState)this.trans.getState((Object)this.ds)) == null) {
            this.trans.putState((Object)this.ds, new WFSTransactionState(this.ds));
        }
    }
}

