/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.rmi.server.UID;
import java.util.logging.Level;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeature;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;

class WFSFeatureType
implements FeatureType {
    FeatureType delegate;
    private URI schemaURI;
    private boolean lenient;

    public WFSFeatureType(FeatureType delegate, URI schemaURI) {
        this(delegate, schemaURI, false);
    }

    public WFSFeatureType(FeatureType delegate, URI schemaURI, boolean lenient2) {
        this.delegate = delegate;
        this.schemaURI = schemaURI;
        this.lenient = lenient2;
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        if (this.lenient && this.delegate instanceof DefaultFeatureType) {
            WFSFeatureType schema = new WFSFeatureType(this.delegate, this.schemaURI);
            return new LenientFeature(schema, attributes, featureID);
        }
        return this.delegate.create(attributes, featureID);
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    boolean isLenient() {
        return this.lenient;
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.create(attributes, null);
    }

    public Feature duplicate(Feature original) throws IllegalAttributeException {
        if (original == null) {
            return null;
        }
        FeatureType featureType = original.getFeatureType();
        if (!((Object)featureType).equals(this)) {
            throw new IllegalAttributeException("Feature type " + featureType + " does not match " + this);
        }
        String id = original.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeType curAttType = this.getAttributeType(i);
            attributes[i] = curAttType.duplicate(original.getAttribute(i));
        }
        return featureType.create(attributes, id);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof WFSFeatureType)) {
            return false;
        }
        WFSFeatureType ft = (WFSFeatureType)arg0;
        return ((Object)this.delegate).equals(ft.delegate);
    }

    public int find(AttributeType type) {
        return this.delegate.find(type);
    }

    public int find(String attName) {
        return this.delegate.find(attName);
    }

    public FeatureType[] getAncestors() {
        return this.delegate.getAncestors();
    }

    public int getAttributeCount() {
        return this.delegate.getAttributeCount();
    }

    public AttributeType getAttributeType(int position) {
        return this.delegate.getAttributeType(position);
    }

    public AttributeType getAttributeType(String xPath) {
        return this.delegate.getAttributeType(xPath);
    }

    public AttributeType[] getAttributeTypes() {
        return this.delegate.getAttributeTypes();
    }

    public GeometryAttributeType getDefaultGeometry() {
        return this.delegate.getDefaultGeometry();
    }

    public URI getNamespace() {
        return this.delegate.getNamespace();
    }

    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    public boolean hasAttributeType(String xPath) {
        return this.delegate.hasAttributeType(xPath);
    }

    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public boolean isAbstract() {
        return this.delegate.isAbstract();
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.delegate.isDescendedFrom(type);
    }

    public boolean isDescendedFrom(URI nsURI, String typeName) {
        return this.delegate.isDescendedFrom(nsURI, typeName);
    }

    public URI getSchemaURI() {
        return this.schemaURI;
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static class LenientFeature
    implements SimpleFeature,
    Feature {
        protected String featureId;
        private final WFSFeatureType schema;
        private Object[] attributes;
        private Envelope bounds;
        private FeatureCollection parent;
        private int defaultGeomIndex = -1;
        private boolean constructing = true;

        protected LenientFeature(WFSFeatureType schema, Object[] attributes, String featureID) throws IllegalAttributeException, NullPointerException {
            if (schema == null) {
                throw new NullPointerException("schema");
            }
            this.schema = schema;
            this.featureId = featureID == null ? this.defaultID() : featureID;
            this.attributes = new Object[schema.getAttributeCount()];
            this.setAttributes(attributes);
            this.defaultGeomIndex = schema.find(schema.getDefaultGeometry());
            this.constructing = false;
        }

        protected LenientFeature(WFSFeatureType schema, Object[] attributes) throws IllegalAttributeException {
            this(schema, attributes, null);
        }

        String defaultID() {
            return "fid-" + new UID().toString().replace(':', '_');
        }

        public FeatureType getFeatureType() {
            return this.schema;
        }

        public String getID() {
            return this.featureId;
        }

        public Object[] getAttributes(Object[] array) {
            Object[] retArray = array == null ? new Object[this.attributes.length] : array;
            System.arraycopy(this.attributes, 0, retArray, 0, this.attributes.length);
            return retArray;
        }

        public Object getAttribute(String xPath) {
            int idx = this.schema.find(xPath);
            if (idx == -1) {
                return null;
            }
            return this.attributes[idx];
        }

        public Object getAttribute(int index) {
            return this.attributes[index];
        }

        public void setAttribute(int position, Object val) throws IllegalAttributeException {
            AttributeType type = this.schema.getAttributeType(position);
            try {
                if (val == null && !type.isNillable()) {
                    val = type.createDefaultValue();
                }
                Object parsed = type.parse(val);
                try {
                    type.validate(parsed);
                }
                catch (Throwable e) {
                    if (this.constructing) {
                        WFSDataStoreFactory.logger.logp(Level.WARNING, "LenientFeature", "setAttribute", "Illegal Argument but ignored since we are being lenient", e);
                    }
                    throw new IllegalAttributeException(type, val, e);
                }
                this.setAttributeValue(position, parsed);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalAttributeException(type, val, iae);
            }
        }

        protected void setAttributeValue(int position, Object val) {
            this.attributes[position] = val;
        }

        public void setAttributes(Object[] attributes) throws IllegalAttributeException {
            Object[] newAtts = attributes;
            if (attributes == null) {
                newAtts = new Object[this.attributes.length];
            }
            if (this.constructing) {
                Object[] tmp = this.assumeCorrectOrder(newAtts);
                newAtts = tmp == null ? this.greedyMatch(newAtts) : tmp;
            } else if (newAtts.length != this.attributes.length) {
                throw new IllegalAttributeException("Wrong number of attributes expected " + this.schema.getAttributeCount() + " got " + newAtts.length);
            }
            int ii = newAtts.length;
            for (int i = 0; i < ii; ++i) {
                this.setAttribute(i, newAtts[i]);
            }
        }

        private Object[] assumeCorrectOrder(Object[] newAtts) {
            Object[] tmp = new Object[this.schema.getAttributeCount()];
            for (int i = 0; i < newAtts.length && i < this.schema.getAttributeCount(); ++i) {
                Class<?> realClass;
                Object object = newAtts[i];
                AttributeType att = this.schema.getAttributeType(i);
                if (object == null) continue;
                Class requiredClass = att.getType();
                if (!requiredClass.isAssignableFrom(realClass = object.getClass())) {
                    return null;
                }
                tmp[i] = object;
            }
            return tmp;
        }

        private Object[] greedyMatch(Object[] newAtts) {
            Object[] relaxedAttrs = new Object[this.attributes.length];
            boolean inValid = false;
            for (int i = 0; i < newAtts.length; ++i) {
                Object object = newAtts[i];
                boolean found = false;
                if (object == null) continue;
                Class<?> realClass = object.getClass();
                for (int j = 0; j < this.schema.getAttributeCount(); ++j) {
                    AttributeType att = this.schema.getAttributeType(j);
                    Class requiredClass = att.getType();
                    if (relaxedAttrs[j] != null || !requiredClass.isAssignableFrom(realClass)) continue;
                    relaxedAttrs[j] = object;
                    found = true;
                    break;
                }
                if (found) continue;
                inValid = true;
            }
            newAtts = relaxedAttrs;
            if (inValid) {
                int i;
                StringBuffer buf = new StringBuffer();
                buf.append("WFSFeatureType#setAttributes(Object[]):");
                buf.append("\nAttributes were not correct for the feature Type:");
                buf.append(this.schema.getTypeName());
                buf.append(".  Made best guess:\n Recieved: ");
                for (i = 0; i < newAtts.length; ++i) {
                    Object object = newAtts[i];
                    buf.append(object == null ? "null" : object.toString());
                    buf.append(",");
                }
                buf.append("\nBest Guess: \n");
                for (i = 0; i < relaxedAttrs.length; ++i) {
                    Object object = relaxedAttrs[i];
                    buf.append(object == null ? "null" : object.toString());
                    buf.append(",");
                }
                WFSDataStoreFactory.logger.warning(buf.toString());
            }
            return newAtts;
        }

        public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
            int idx = this.schema.find(xPath);
            if (idx < 0) {
                throw new IllegalAttributeException("No attribute named " + xPath);
            }
            this.setAttribute(idx, attribute);
        }

        public Geometry getDefaultGeometry() {
            if (this.defaultGeomIndex == -1) {
                return null;
            }
            return (Geometry)this.attributes[this.defaultGeomIndex];
        }

        public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
            if (this.defaultGeomIndex < 0) {
                throw new IllegalAttributeException("Feature does not have geometry");
            }
            this.attributes[this.defaultGeomIndex] = geometry;
            this.bounds = null;
        }

        public int getNumberOfAttributes() {
            return this.attributes.length;
        }

        public Envelope getBounds() {
            if (this.bounds == null) {
                this.bounds = new Envelope();
                int n = this.schema.getAttributeCount();
                for (int i = 0; i < n; ++i) {
                    Envelope e;
                    Geometry g;
                    if (!(this.schema.getAttributeType(i) instanceof GeometryAttributeType) || (g = (Geometry)this.attributes[i]) == null || (e = g.getEnvelopeInternal()).isNull()) continue;
                    this.bounds.expandToInclude(e);
                }
            }
            return new Envelope(this.bounds);
        }

        public Object clone() {
            try {
                DefaultFeature clone = (DefaultFeature)super.clone();
                for (int i = 0; i < this.attributes.length; ++i) {
                    try {
                        clone.setAttribute(i, this.attributes[i]);
                        continue;
                    }
                    catch (IllegalAttributeException e1) {
                        throw new RuntimeException("The impossible has happened", e1);
                    }
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("The impossible has happened", e);
            }
        }

        public String toString() {
            String retString = "Feature[ id=" + this.getID() + " , ";
            FeatureType featType = this.getFeatureType();
            int n = this.attributes.length;
            for (int i = 0; i < n; ++i) {
                retString = retString + featType.getAttributeType(i).getName() + "=";
                retString = retString + this.attributes[i];
                if (i + 1 >= n) continue;
                retString = retString + " , ";
            }
            retString = retString + " ]";
            return retString;
        }

        public int hashCode() {
            return this.featureId.hashCode() * this.schema.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Feature)) {
                return false;
            }
            Feature feat = (Feature)obj;
            if (!((Object)feat.getFeatureType()).equals(this.schema)) {
                return false;
            }
            if (this.featureId == null && feat.getID() != null) {
                return false;
            }
            if (!this.featureId.equals(feat.getID())) {
                return false;
            }
            int ii = this.attributes.length;
            for (int i = 0; i < ii; ++i) {
                Object otherAtt = feat.getAttribute(i);
                if (this.attributes[i] == null) {
                    if (otherAtt == null) continue;
                    return false;
                }
                if (this.attributes[i].equals(otherAtt)) continue;
                if (this.attributes[i] instanceof Geometry && otherAtt instanceof Geometry) {
                    if (((Geometry)this.attributes[i]).equals((Geometry)otherAtt)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        public FeatureCollection getParent() {
            return this.parent;
        }

        public void setParent(FeatureCollection collection) {
            if (this.parent == null) {
                this.parent = collection;
            }
        }
    }
}

