/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.Action;
import org.geotools.data.wfs.LogWriterDecorator;
import org.geotools.data.wfs.TransactionResult;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.xml.DocumentFactory;
import org.geotools.xml.DocumentWriter;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.wfs.WFSSchema;
import org.xml.sax.SAXException;

public class WFSTransactionState
implements Transaction.State {
    private WFSDataStore ds = null;
    private Map fids = new HashMap();
    Map actionMap = new HashMap();
    private long latestFid = Long.MAX_VALUE;

    private WFSTransactionState() {
    }

    public WFSTransactionState(WFSDataStore ds) {
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransaction(Transaction transaction) {
        if (transaction != null) {
            Map map = this.actionMap;
            synchronized (map) {
                Map map2 = this.fids;
                synchronized (map2) {
                    this.fids.clear();
                }
                this.actionMap.clear();
            }
        }
    }

    public void addAuthorization(String AuthID) {
    }

    public String getLockId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        Map copiedActions;
        TransactionResult tr = null;
        Map map = this.actionMap;
        synchronized (map) {
            this.combineActions();
            copiedActions = this.copy(this.actionMap);
        }
        Iterator iter = copiedActions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List actions = (List)entry.getValue();
            String typeName = (String)entry.getKey();
            if (actions.isEmpty()) continue;
            if ((this.ds.protocol & 1) == 1 && tr == null) {
                try {
                    tr = this.commitPost(actions);
                }
                catch (OperationNotSupportedException e) {
                    WFSDataStoreFactory.logger.warning(e.toString());
                    tr = null;
                }
                catch (SAXException e) {
                    WFSDataStoreFactory.logger.warning(e.toString());
                    tr = null;
                }
            }
            if (tr == null) {
                throw new IOException("An error occured while committing.");
            }
            if (tr.getStatus() == 2) {
                throw new IOException(tr.getError().toString());
            }
            List newFids = tr.getInsertResult();
            int currentInsertIndex = 0;
            Iterator iter2 = actions.iterator();
            while (iter2.hasNext()) {
                Object action = iter2.next();
                if (!(action instanceof Action.InsertAction)) continue;
                Action.InsertAction insertAction = (Action.InsertAction)action;
                if (currentInsertIndex >= newFids.size()) {
                    Logger.getLogger("org.geotools.data.wfs").severe("Expected more fids to be returned by TransactionResponse!");
                    break;
                }
                this.ds.addFidMapping(insertAction.getFeature().getID(), (String)newFids.get(currentInsertIndex));
                ++currentInsertIndex;
            }
            Map map2 = this.fids;
            synchronized (map2) {
                this.fids.put(typeName, newFids.toArray(new String[0]));
            }
            if (currentInsertIndex != newFids.size()) {
                Logger.getLogger("org.geotools.data.wfs").severe("number of fids inserted do not match number of fids returned by Transaction Response.  Got:" + newFids.size() + " expected: " + currentInsertIndex);
            }
            map2 = this.actionMap;
            synchronized (map2) {
                ((List)this.actionMap.get(typeName)).removeAll(actions);
            }
        }
    }

    private Map copy(Map actionMap2) {
        HashMap newMap = new HashMap();
        Iterator entries = actionMap2.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            List list = (List)entry.getValue();
            newMap.put(entry.getKey(), new ArrayList(list));
        }
        return newMap;
    }

    private TransactionResult commitPost(List toCommit) throws OperationNotSupportedException, IOException, SAXException {
        URL postUrl = this.ds.capabilities.getTransaction().getPost();
        if (postUrl == null) {
            return null;
        }
        HttpURLConnection hc = this.ds.getConnection(postUrl, this.ds.auth, true);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("DocumentWriter_BASE_ELEMENT", WFSSchema.getInstance().getElements()[24]);
        HashSet<String> fts = new HashSet<String>();
        Iterator i = toCommit.iterator();
        while (i.hasNext()) {
            Action a = (Action)i.next();
            fts.add(a.getTypeName());
        }
        HashSet<String> ns = new HashSet<String>();
        ns.add(WFSSchema.NAMESPACE.toString());
        i = fts.iterator();
        while (i.hasNext()) {
            ns.add(this.ds.getSchema((String)i.next()).getNamespace().toString());
        }
        hints.put("DocumentWriter_SCHEMA_ORDER", ns.toArray(new String[ns.size()]));
        OutputStream os = hc.getOutputStream();
        Writer w = new OutputStreamWriter(os);
        if (Logger.getLogger("org.geotools.data.wfs").isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, Logger.getLogger("org.geotools.data.wfs"), Level.FINE);
        }
        if (Logger.getLogger("org.geotools.data.communication").isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, Logger.getLogger("org.geotools.data.communication"), Level.FINE);
        }
        DocumentWriter.writeDocument((Object)this, (Schema)WFSSchema.getInstance(), (Writer)w, hints);
        w.flush();
        w.close();
        InputStream is = this.ds.getInputStream(hc);
        hints = new HashMap();
        TransactionResult ft = (TransactionResult)DocumentFactory.getInstance((InputStream)is, hints, (Level)Level.WARNING);
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Map map = this.actionMap;
        synchronized (map) {
            this.actionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFids(String typeName) {
        Map map = this.fids;
        synchronized (map) {
            return (String[])this.fids.get(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String typeName, Action a) {
        Map map = this.actionMap;
        synchronized (map) {
            ArrayList<Action> list = (ArrayList<Action>)this.actionMap.get(typeName);
            if (list == null) {
                list = new ArrayList<Action>();
                this.actionMap.put(typeName, list);
            }
            list.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActions(String typeName) {
        Map map = this.actionMap;
        synchronized (map) {
            Collection collection = (Collection)this.actionMap.get(typeName);
            if (collection == null || collection.isEmpty()) {
                return new ArrayList();
            }
            return new ArrayList(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllActions() {
        Map map = this.actionMap;
        synchronized (map) {
            ArrayList all = new ArrayList();
            Iterator iter = this.actionMap.values().iterator();
            while (iter.hasNext()) {
                List actions = (List)iter.next();
                all.addAll(actions);
            }
            return all;
        }
    }

    protected void combineActions() {
        Iterator iter = this.actionMap.values().iterator();
        block0: while (iter.hasNext()) {
            List actions = (List)iter.next();
            this.removeFilterAllActions(actions);
            Action.InsertAction firstAction = null;
            while (firstAction == null || !actions.contains(firstAction)) {
                firstAction = this.findFirstInsertAction(actions);
                if (firstAction == null) continue block0;
                this.processInsertAction(actions, firstAction);
            }
            Action.InsertAction current = this.findFirstInsertAction(actions);
            while (current != null && firstAction != current) {
                this.processInsertAction(actions, current);
                current = this.findFirstInsertAction(actions);
            }
        }
    }

    private void removeFilterAllActions(List actions) {
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            Action element = (Action)iter.next();
            if (!Filter.ALL.equals(element.getFilter())) continue;
            iter.remove();
        }
    }

    private Action.InsertAction findFirstInsertAction(List actions) {
        int i = 0;
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            Object action = iter.next();
            if (action instanceof Action.InsertAction) {
                return (Action.InsertAction)action;
            }
            ++i;
        }
        return null;
    }

    private void processInsertAction(List actions, Action.InsertAction action) {
        int indexOf = actions.indexOf(action);
        while (indexOf + 1 < actions.size() && indexOf != -1) {
            this.moveUpdateAndMoveInsertAction(actions, indexOf, action);
            indexOf = actions.indexOf(action);
        }
    }

    private void moveUpdateAndMoveInsertAction(List actions, int i, Action.InsertAction action) {
        if (i + 1 < actions.size()) {
            Object nextAction = actions.get(i + 1);
            if (nextAction instanceof Action.DeleteAction) {
                this.handleDeleteAction(actions, i, action, (Action.DeleteAction)nextAction);
            } else if (nextAction instanceof Action.UpdateAction) {
                this.handleUpdateAction(actions, i, action, (Action.UpdateAction)nextAction);
            } else {
                this.swap(actions, i);
            }
        }
    }

    private void handleDeleteAction(List actions, int i, Action.InsertAction action, Action.DeleteAction deleteAction) {
        if (deleteAction.getFilter().contains(action.getFeature())) {
            actions.remove(i);
            if (deleteAction.getFilter() instanceof FidFilter && ((FidFilter)deleteAction.getFilter()).getFids().length == 1) {
                actions.remove(i);
            }
        } else {
            this.swap(actions, i);
        }
    }

    private int handleUpdateAction(List actions, int i, Action.InsertAction action, Action.UpdateAction updateAction) {
        if (updateAction.getFilter().contains(action.getFeature())) {
            updateAction.update(action.getFeature());
            if (updateAction.getFilter() instanceof FidFilter && ((FidFilter)updateAction.getFilter()).getFids().length == 1) {
                actions.remove(i + 1);
                return i;
            }
        }
        this.swap(actions, i);
        return i + 1;
    }

    private void swap(List actions, int i) {
        Object item = actions.remove(i);
        actions.add(i + 1, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextFid(String typeName) {
        long fid;
        WFSTransactionState wFSTransactionState = this;
        synchronized (wFSTransactionState) {
            fid = this.latestFid--;
        }
        return "new" + typeName + "." + fid;
    }
}

