/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.xml.gml.ChoiceAttributeType;
import org.geotools.xml.gml.ChoiceAttributeTypeImpl;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSFeatureTypeTransformer {
    public static FeatureType transform(FeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        FeatureTypeFactory factory = FeatureTypeBuilder.newInstance((String)schema.getTypeName());
        factory.setNamespace(schema.getNamespace());
        factory.setName(schema.getTypeName());
        GeometryAttributeType defaultGeometryType = null;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeType attributeType = schema.getAttributeType(i);
            if (attributeType instanceof ChoiceAttributeType.Geometry) {
                defaultGeometryType = WFSFeatureTypeTransformer.handleChoiceGeometryAttribute(schema, crs, (FeatureTypeBuilder)factory, defaultGeometryType, attributeType);
                continue;
            }
            if (attributeType instanceof GeometryAttributeType) {
                defaultGeometryType = WFSFeatureTypeTransformer.handleGeometryAttribute(schema, crs, (FeatureTypeBuilder)factory, defaultGeometryType, attributeType);
                continue;
            }
            factory.addType(attributeType);
        }
        factory.setDefaultGeometry(defaultGeometryType);
        return factory.getFeatureType();
    }

    private static GeometryAttributeType handleGeometryAttribute(FeatureType schema, CoordinateReferenceSystem crs, FeatureTypeBuilder factory, GeometryAttributeType defaultGeometryType, AttributeType attributeType) {
        GeometryAttributeType geometryType = (GeometryAttributeType)attributeType;
        GeometryAttributeType geometry = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)geometryType.getName(), (Class)geometryType.getType(), (boolean)geometryType.isNillable(), (int)0, (Object)geometryType.createDefaultValue(), (Object)crs);
        if (defaultGeometryType == null || geometryType == schema.getDefaultGeometry()) {
            defaultGeometryType = geometry;
        }
        factory.addType((AttributeType)geometry);
        return defaultGeometryType;
    }

    private static GeometryAttributeType handleChoiceGeometryAttribute(FeatureType schema, CoordinateReferenceSystem crs, FeatureTypeBuilder factory, GeometryAttributeType defaultGeometryType, AttributeType attributeType) {
        ChoiceAttributeType.Geometry geometryType = (ChoiceAttributeType.Geometry)attributeType;
        ChoiceAttributeTypeImpl.Geometry geometry = new ChoiceAttributeTypeImpl.Geometry(geometryType.getName(), geometryType.getChoices(), geometryType.getType(), geometryType.isNillable(), geometryType.getMinOccurs(), geometryType.getMaxOccurs(), geometryType.createDefaultValue(), crs, geometryType.getRestriction());
        if (defaultGeometryType == null || geometryType == schema.getDefaultGeometry()) {
            defaultGeometryType = geometry;
        }
        factory.addType((AttributeType)geometry);
        return defaultGeometryType;
    }
}

