/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.lineage;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.util.InternationalString;

public class ProcessStepImpl
extends MetadataEntity
implements ProcessStep {
    private static final long serialVersionUID = 4629429337326490722L;
    private InternationalString description;
    private InternationalString rationale;
    private long date;
    private Collection processors;
    private Collection sources;

    public ProcessStepImpl() {
    }

    public ProcessStepImpl(InternationalString description) {
        this.setDescription(description);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public InternationalString getRationale() {
        return this.rationale;
    }

    public synchronized void setRationale(InternationalString newValue) {
        this.checkWritePermission();
        this.rationale = newValue;
    }

    public synchronized Date getDate() {
        return this.date != Long.MIN_VALUE ? new Date(this.date) : null;
    }

    public synchronized void setDate(Date newValue) {
        this.checkWritePermission();
        this.date = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public synchronized Collection getProcessors() {
        this.processors = this.nonNullCollection(this.processors, ResponsibleParty.class);
        return this.processors;
    }

    public synchronized void setProcessors(Collection newValues) {
        this.processors = this.copyCollection(newValues, this.processors, ResponsibleParty.class);
    }

    public synchronized Collection getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public synchronized void setSources(Collection newValues) {
        this.sources = this.copyCollection(newValues, this.sources, Source.class);
    }

    protected void freeze() {
        super.freeze();
        this.description = (InternationalString)ProcessStepImpl.unmodifiable(this.description);
        this.rationale = (InternationalString)ProcessStepImpl.unmodifiable(this.rationale);
        this.processors = (Collection)ProcessStepImpl.unmodifiable(this.processors);
        this.sources = (Collection)ProcessStepImpl.unmodifiable(this.sources);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ProcessStepImpl that = (ProcessStepImpl)object;
            return Utilities.equals(this.description, that.description) && Utilities.equals(this.rationale, that.rationale) && this.date == that.date && Utilities.equals(this.processors, that.processors) && Utilities.equals(this.sources, that.sources);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1545475170;
        if (this.description != null) {
            code ^= this.description.hashCode();
        }
        if (this.rationale != null) {
            code ^= this.rationale.hashCode();
        }
        if (this.processors != null) {
            code ^= ((Object)this.processors).hashCode();
        }
        if (this.sources != null) {
            code ^= ((Object)this.sources).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.description);
    }
}

