/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.units.Unit;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class Parameters {
    private static final double EPS = 1.0E-8;
    public static ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup("empty", new GeneralParameterDescriptor[0]);

    public static boolean isValid(ParameterValue parameter) {
        ParameterDescriptor descriptor = (ParameterDescriptor)parameter.getDescriptor();
        Object value = parameter.getValue();
        Class<Void> type = value == null ? Void.TYPE : value.getClass();
        Class kind = descriptor.getValueClass();
        if (kind.isInstance(value)) {
            return false;
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (Parameters.isValidValue(Array.get(value, i), descriptor)) continue;
                return false;
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (Parameters.isValidValue(i.next(), descriptor)) continue;
                return false;
            }
        } else {
            Parameters.isValidValue(value, descriptor);
        }
        return true;
    }

    private static boolean isValidValue(Object value, ParameterDescriptor descriptor) {
        Class<Void> type = value == null ? Void.TYPE : value.getClass();
        Class expected = descriptor.getValueClass();
        Set validValues = descriptor.getValidValues();
        if (validValues != null && !validValues.contains(value)) {
            return false;
        }
        Comparable min = descriptor.getMinimumValue();
        if (min != null && min.compareTo(value) > 0) {
            return false;
        }
        Comparable max = descriptor.getMaximumValue();
        return max == null || max.compareTo(value) >= 0;
    }

    public static List search(GeneralParameterValue param, String name, int maxDepth) {
        ArrayList list = new ArrayList();
        Parameters.search(param, name, maxDepth, list);
        return list;
    }

    private static void search(GeneralParameterValue param, String name, int maxDepth, Collection list) {
        if (maxDepth >= 0) {
            if (AbstractIdentifiedObject.nameMatches(param.getDescriptor(), name)) {
                list.add(param);
            }
            if (maxDepth != 0 && param instanceof ParameterValueGroup) {
                Iterator it = ((ParameterValueGroup)param).values().iterator();
                while (it.hasNext()) {
                    Parameters.search((GeneralParameterValue)it.next(), name, maxDepth - 1, list);
                }
            }
        }
    }

    public static void copy(ParameterValueGroup source, ParameterValueGroup target) {
        Iterator it = source.values().iterator();
        while (it.hasNext()) {
            GeneralParameterValue param = (GeneralParameterValue)it.next();
            String name = param.getDescriptor().getName().getCode();
            if (param instanceof ParameterValueGroup) {
                Parameters.copy((ParameterValueGroup)param, target.addGroup(name));
                continue;
            }
            target.parameter(name).setValue(((ParameterValue)param).getValue());
        }
    }

    public static Map toNameValueMap(GeneralParameterValue parameters, Map destination) {
        if (destination == null) {
            destination = new LinkedHashMap<String, Object>();
        }
        if (parameters instanceof ParameterValue) {
            ParameterValue param = (ParameterValue)parameters;
            Object value = param.getValue();
            Object old = destination.put(param.getDescriptor().getName().getCode(), value);
            if (old != null && !old.equals(value)) {
                throw new IllegalArgumentException("Inconsistent value");
            }
        }
        if (parameters instanceof ParameterValueGroup) {
            ParameterValueGroup group = (ParameterValueGroup)parameters;
            Iterator it = group.values().iterator();
            while (it.hasNext()) {
                destination = Parameters.toNameValueMap((GeneralParameterValue)it.next(), destination);
            }
        }
        return destination;
    }

    public static boolean ensureSet(ParameterValueGroup parameters, String name, double value, Unit unit, boolean force) {
        ParameterValue parameter;
        try {
            parameter = parameters.parameter(name);
        }
        catch (ParameterNotFoundException ignore) {
            return false;
        }
        try {
            if (Math.abs(parameter.doubleValue(unit) / value - 1.0) <= 1.0E-8) {
                return false;
            }
        }
        catch (InvalidParameterTypeException exception) {
            return false;
        }
        catch (IllegalStateException exception) {
            parameter.setValue(value, unit);
            return true;
        }
        if (force) {
            parameter.setValue(value, unit);
        } else {
            LogRecord record = new LogRecord(Level.FINE, "Axis length mismatch.");
            record.setSourceClassName("Parameters");
            record.setSourceMethodName("ensureSet");
            Logger.getLogger("org.geotools.parameter").log(record);
        }
        return true;
    }
}

