/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public final class CRS {
    private static final Hints LENIENT = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;

    private CRS() {
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.transform(sourceCRS, targetCRS, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(lenient ? LENIENT : null);
        return factory.createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static MathTransform transform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.findMathTransform(sourceCRS, targetCRS);
    }

    public static MathTransform transform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(lenient ? LENIENT : null);
        return factory.createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static Set getSupportedCodes(String authority) {
        return DefaultAuthorityFactory.getSupportedCodes(authority);
    }

    public static Set getSupportedAuthorities(boolean returnAliases) {
        return DefaultAuthorityFactory.getSupportedAuthorities();
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(code, false);
    }

    public static CoordinateReferenceSystem decode(String code, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        code = code.trim().toUpperCase();
        return CRS.getAuthorityFactory(longitudeFirst).createCoordinateReferenceSystem(code);
    }

    public static CoordinateReferenceSystem parseWKT(String wkt) throws FactoryException {
        return FactoryFinder.getCRSFactory(null).createFromWKT(wkt);
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean longitudeFirst) throws FactoryRegistryException {
        CRSAuthorityFactory factory;
        if (FactoryFinder.updated) {
            FactoryFinder.updated = false;
            xyFactory = null;
            defaultFactory = null;
        }
        CRSAuthorityFactory cRSAuthorityFactory = factory = longitudeFirst ? xyFactory : defaultFactory;
        if (factory == null) {
            try {
                factory = new DefaultAuthorityFactory(longitudeFirst);
                if (longitudeFirst) {
                    xyFactory = factory;
                } else {
                    defaultFactory = factory;
                }
            }
            catch (NoSuchElementException exception) {
                throw new FactoryNotFoundException(null, exception);
            }
        }
        return factory;
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem crs) {
        CoordinateReferenceSystem sourceCRS;
        Envelope envelope = CRS.getGeographicEnvelope(crs);
        if (envelope != null && (sourceCRS = envelope.getUpperCorner().getCoordinateReferenceSystem()) != null) {
            try {
                crs = CRSUtilities.getCRS2D(crs);
                if (!CRS.equalsIgnoreMetadata(sourceCRS, crs)) {
                    GeneralEnvelope e = CRSUtilities.transform(CRS.transform(sourceCRS, crs, true), envelope);
                    e.setCoordinateReferenceSystem(crs);
                    envelope = e;
                }
            }
            catch (FactoryException exception) {
                envelope = null;
                Utilities.unexpectedException("org.geotools.referencing", "CRS", "getEnvelope", exception);
            }
            catch (TransformException exception) {
                envelope = null;
                Utilities.unexpectedException("org.geotools.referencing", "CRS", "getEnvelope", exception);
            }
        }
        return envelope;
    }

    private static Envelope getGeographicEnvelope(CoordinateReferenceSystem crs) {
        return CRSUtilities.getEnvelope(crs);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Envelope envelope = CRS.getGeographicEnvelope(crs);
        if (envelope != null) {
            try {
                return new GeographicBoundingBoxImpl(envelope);
            }
            catch (TransformException exception) {
                Utilities.unexpectedException("org.geotools.referencing", "CRS", "getGeographicBoundingBox", exception);
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        return CRSUtilities.equalsIgnoreMetadata(object1, object2);
    }

    public static String lookupIdentifier(CoordinateReferenceSystem ref, Set authorities, boolean fullScan) {
        if (authorities == null) {
            authorities = CRS.getSupportedAuthorities(false);
        }
        Iterator it = ref.getIdentifiers().iterator();
        while (it.hasNext()) {
            NamedIdentifier id = (NamedIdentifier)it.next();
            try {
                String identifier;
                CoordinateReferenceSystem crs = CRS.decode(id.toString());
                if (!CRS.equalsIgnoreMetadata(crs, ref) || (identifier = CRS.getSRSFromCRS(crs, authorities)) == null) continue;
                return identifier;
            }
            catch (Exception e) {
            }
        }
        try {
            String identifier;
            CoordinateReferenceSystem crs = CRS.decode(ref.getName().toString());
            if (CRS.equalsIgnoreMetadata(crs, ref) && (identifier = CRS.getSRSFromCRS(crs, authorities)) != null) {
                return identifier;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!fullScan) {
            return null;
        }
        Iterator itAuth = authorities.iterator();
        while (itAuth.hasNext()) {
            String authority = (String)itAuth.next();
            Set codes = CRS.getSupportedCodes(authority);
            Iterator itCodes = codes.iterator();
            while (itCodes.hasNext()) {
                String code = (String)itCodes.next();
                try {
                    CoordinateReferenceSystem crs = code.indexOf(":") == -1 ? CRS.decode(authority + ":" + code) : CRS.decode(code);
                    if (!CRS.equalsIgnoreMetadata(crs, ref)) continue;
                    return CRS.getSRSFromCRS(crs, Collections.singleton(authority));
                }
                catch (Exception e) {
                }
            }
        }
        return null;
    }

    private static String getSRSFromCRS(CoordinateReferenceSystem crs, Set authorities) {
        Iterator itAuth = authorities.iterator();
        while (itAuth.hasNext()) {
            String authority = (String)itAuth.next();
            String prefix = authority + ":";
            Iterator itIdent = crs.getIdentifiers().iterator();
            while (itIdent.hasNext()) {
                NamedIdentifier id = (NamedIdentifier)itIdent.next();
                String idName = id.toString();
                if (!idName.startsWith(prefix)) continue;
                return idName;
            }
        }
        return null;
    }
}

