/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.factory.BufferedAuthorityFactory;
import org.geotools.resources.Utilities;
import org.opengis.referencing.crs.CRSAuthorityFactory;

final class DefaultAuthorityFactory
extends BufferedAuthorityFactory
implements CRSAuthorityFactory {
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;

    DefaultAuthorityFactory(boolean longitudeFirst) {
        this(longitudeFirst ? new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE) : null);
    }

    private DefaultAuthorityFactory(Hints hints) {
        super(new AllAuthoritiesFactory(hints, FactoryFinder.getCRSAuthorityFactories(hints)));
    }

    static Set getSupportedCodes(String authority) {
        LinkedHashSet result = Collections.EMPTY_SET;
        boolean isSetCopied = false;
        Iterator i = FactoryFinder.getCRSAuthorityFactories(null).iterator();
        while (i.hasNext()) {
            Set codes;
            CRSAuthorityFactory factory = (CRSAuthorityFactory)i.next();
            if (!Citations.identifierMatches(factory.getAuthority(), authority)) continue;
            try {
                codes = factory.getAuthorityCodes(class$org$opengis$referencing$crs$CoordinateReferenceSystem == null ? DefaultAuthorityFactory.class$("org.opengis.referencing.crs.CoordinateReferenceSystem") : class$org$opengis$referencing$crs$CoordinateReferenceSystem);
            }
            catch (Exception exception) {
                Utilities.unexpectedException("org.geotools.referencing", "CRS", "getSupportedCodes", exception);
                continue;
            }
            if (codes == null || codes.isEmpty()) continue;
            if (result.isEmpty()) {
                result = codes;
                continue;
            }
            if (!isSetCopied) {
                result = new LinkedHashSet(result);
                isSetCopied = true;
            }
            result.addAll(codes);
        }
        return result;
    }

    static Set getSupportedAuthorities() {
        Set authorityFactories = FactoryFinder.getCRSAuthorityFactories(null);
        if (authorityFactories.size() == 0) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator i = authorityFactories.iterator();
        while (i.hasNext()) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)i.next();
            Collection identifiers = factory.getAuthority().getIdentifiers();
            if (identifiers.size() <= 0) continue;
            result.add((String)identifiers.iterator().next());
        }
        return result;
    }
}

