/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryPrinter;
import org.geotools.resources.Arguments;
import org.geotools.resources.LazySet;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;

public final class FactoryFinder {
    private static FactoryRegistry registry;
    private static Set authorityNames;
    static boolean updated;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(FactoryFinder.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DatumFactory.class, CSFactory.class, CRSFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CRSAuthorityFactory.class, MathTransformFactory.class, CoordinateOperationFactory.class, CoordinateOperationAuthorityFactory.class));
        }
        return registry;
    }

    public static synchronized void addAuthorityFactory(AuthorityFactory authority) {
        FactoryFinder.getServiceRegistry().registerServiceProvider(authority);
        authorityNames = null;
    }

    public static synchronized void removeAuthorityFactory(AuthorityFactory authority) {
        FactoryFinder.getServiceRegistry().deregisterServiceProvider(authority);
        authorityNames = null;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized Set getAuthorityNames() {
        if (authorityNames == null) {
            authorityNames = new LinkedHashSet();
            int i = 0;
            block6: while (true) {
                void var1_1;
                switch (i) {
                    case 0: {
                        Set factories = FactoryFinder.getCRSAuthorityFactories();
                        break;
                    }
                    case 1: {
                        Set factories = FactoryFinder.getCSAuthorityFactories();
                        break;
                    }
                    case 2: {
                        Set factories = FactoryFinder.getDatumAuthorityFactories();
                        break;
                    }
                    case 3: {
                        Set factories = FactoryFinder.getCoordinateOperationAuthorityFactories();
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                Iterator it = var1_1.iterator();
                while (it.hasNext()) {
                    Citation authority = ((AuthorityFactory)it.next()).getAuthority();
                    authorityNames.addAll(authority.getIdentifiers());
                }
                ++i;
            }
            authorityNames = Collections.unmodifiableSet(authorityNames);
        }
        return authorityNames;
    }

    private static synchronized Set getFactories(Class type, Hints hints) {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(type, null, hints));
    }

    private static synchronized Factory getFactory(Class type, Hints hints, Hints.Key key) throws FactoryRegistryException {
        return (Factory)FactoryFinder.getServiceRegistry().getServiceProvider(type, null, hints, key);
    }

    private static synchronized AuthorityFactory getAuthorityFactory(Class type, String authority, Hints hints, Hints.Key key) throws FactoryRegistryException {
        return (AuthorityFactory)FactoryFinder.getServiceRegistry().getServiceProvider(type, new AuthorityFilter(authority), hints, key);
    }

    public static DatumFactory getDatumFactory(Hints hints) throws FactoryRegistryException {
        return (DatumFactory)FactoryFinder.getFactory(DatumFactory.class, hints, Hints.DATUM_FACTORY);
    }

    public static Set getDatumFactories() {
        return FactoryFinder.getDatumFactories(null);
    }

    public static Set getDatumFactories(Hints hints) {
        return FactoryFinder.getFactories(DatumFactory.class, hints);
    }

    public static CSFactory getCSFactory(Hints hints) throws FactoryRegistryException {
        return (CSFactory)FactoryFinder.getFactory(CSFactory.class, hints, Hints.CS_FACTORY);
    }

    public static Set getCSFactories() {
        return FactoryFinder.getCSFactories(null);
    }

    public static Set getCSFactories(Hints hints) {
        return FactoryFinder.getFactories(CSFactory.class, hints);
    }

    public static CRSFactory getCRSFactory(Hints hints) throws FactoryRegistryException {
        return (CRSFactory)FactoryFinder.getFactory(CRSFactory.class, hints, Hints.CRS_FACTORY);
    }

    public static Set getCRSFactories() {
        return FactoryFinder.getCRSFactories(null);
    }

    public static Set getCRSFactories(Hints hints) {
        return FactoryFinder.getFactories(CRSFactory.class, hints);
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Hints hints) throws FactoryRegistryException {
        return (CoordinateOperationFactory)FactoryFinder.getFactory(CoordinateOperationFactory.class, hints, Hints.COORDINATE_OPERATION_FACTORY);
    }

    public static Set getCoordinateOperationFactories() {
        return FactoryFinder.getCoordinateOperationFactories(null);
    }

    public static Set getCoordinateOperationFactories(Hints hints) {
        return FactoryFinder.getFactories(CoordinateOperationFactory.class, hints);
    }

    public static DatumAuthorityFactory getDatumAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (DatumAuthorityFactory)FactoryFinder.getAuthorityFactory(DatumAuthorityFactory.class, authority, hints, Hints.DATUM_AUTHORITY_FACTORY);
    }

    public static Set getDatumAuthorityFactories() {
        return FactoryFinder.getDatumAuthorityFactories(null);
    }

    public static Set getDatumAuthorityFactories(Hints hints) {
        return FactoryFinder.getFactories(DatumAuthorityFactory.class, hints);
    }

    public static CSAuthorityFactory getCSAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (CSAuthorityFactory)FactoryFinder.getAuthorityFactory(CSAuthorityFactory.class, authority, hints, Hints.CS_AUTHORITY_FACTORY);
    }

    public static Set getCSAuthorityFactories() {
        return FactoryFinder.getCSAuthorityFactories(null);
    }

    public static Set getCSAuthorityFactories(Hints hints) {
        return FactoryFinder.getFactories(CSAuthorityFactory.class, hints);
    }

    public static CRSAuthorityFactory getCRSAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (CRSAuthorityFactory)FactoryFinder.getAuthorityFactory(CRSAuthorityFactory.class, authority, hints, Hints.CRS_AUTHORITY_FACTORY);
    }

    public static Set getCRSAuthorityFactories() {
        return FactoryFinder.getCRSAuthorityFactories(null);
    }

    public static Set getCRSAuthorityFactories(Hints hints) {
        return FactoryFinder.getFactories(CRSAuthorityFactory.class, hints);
    }

    public static CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (CoordinateOperationAuthorityFactory)FactoryFinder.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, authority, hints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
    }

    public static Set getCoordinateOperationAuthorityFactories() {
        return FactoryFinder.getCoordinateOperationAuthorityFactories(null);
    }

    public static Set getCoordinateOperationAuthorityFactories(Hints hints) {
        return FactoryFinder.getFactories(CoordinateOperationAuthorityFactory.class, hints);
    }

    public static MathTransformFactory getMathTransformFactory(Hints hints) throws FactoryRegistryException {
        return (MathTransformFactory)FactoryFinder.getFactory(MathTransformFactory.class, hints, Hints.MATH_TRANSFORM_FACTORY);
    }

    public static Set getMathTransformFactories() {
        return FactoryFinder.getMathTransformFactories(null);
    }

    public static Set getMathTransformFactories(Hints hints) {
        return FactoryFinder.getFactories(MathTransformFactory.class, hints);
    }

    public static synchronized boolean setVendorOrdering(String vendor1, String vendor2) {
        return FactoryFinder.getServiceRegistry().setOrdering(Factory.class, true, new VendorFilter(vendor1), new VendorFilter(vendor2));
    }

    public static synchronized boolean unsetVendorOrdering(String vendor1, String vendor2) {
        return FactoryFinder.getServiceRegistry().setOrdering(Factory.class, false, new VendorFilter(vendor1), new VendorFilter(vendor2));
    }

    public static synchronized boolean setAuthorityOrdering(String authority1, String authority2) {
        return FactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, true, new AuthorityFilter(authority1), new AuthorityFilter(authority2));
    }

    public static synchronized boolean unsetAuthorityOrdering(String authority1, String authority2) {
        return FactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, false, new AuthorityFilter(authority1), new AuthorityFilter(authority2));
    }

    public static synchronized void scanForPlugins() {
        authorityNames = null;
        if (registry != null) {
            registry.scanForPlugins();
        }
        updated = true;
    }

    public static synchronized void listProviders(Writer out, Locale locale) throws IOException {
        FactoryRegistry registry = FactoryFinder.getServiceRegistry();
        registry.getServiceProviders(DatumFactory.class);
        new FactoryPrinter().list(registry, out, locale);
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        try {
            FactoryFinder.listProviders(arguments.out, arguments.locale);
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
        }
    }

    static {
        $assertionsDisabled = !FactoryFinder.class.desiredAssertionStatus();
    }

    private static final class AuthorityFilter
    implements ServiceRegistry.Filter {
        private final String authority;

        public AuthorityFilter(String authority) {
            this.authority = authority;
        }

        public boolean filter(Object provider) {
            if (this.authority == null) {
                return false;
            }
            return Citations.identifierMatches(((AuthorityFactory)provider).getAuthority(), this.authority);
        }
    }

    private static final class VendorFilter
    implements ServiceRegistry.Filter {
        private final String vendor;

        public VendorFilter(String vendor) {
            this.vendor = vendor;
        }

        public boolean filter(Object provider) {
            return Citations.titleMatches(((Factory)provider).getVendor(), this.vendor);
        }
    }
}

