/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String[] LOCALIZABLES = new String[]{"anchorPoint", "scope"};
    private final InternationalString anchorPoint;
    private final long realizationEpoch;
    private final Extent validArea;
    private final InternationalString scope;

    public AbstractDatum(Datum datum) {
        super(datum);
        Date epoch = datum.getRealizationEpoch();
        this.realizationEpoch = epoch != null ? epoch.getTime() : Long.MIN_VALUE;
        this.validArea = datum.getValidArea();
        this.scope = datum.getScope();
        this.anchorPoint = datum.getAnchorPoint();
    }

    public AbstractDatum(Map properties) {
        this(properties, new HashMap());
    }

    private AbstractDatum(Map properties, Map subProperties) {
        super(properties, subProperties, LOCALIZABLES);
        this.anchorPoint = (InternationalString)subProperties.get("anchorPoint");
        Date realizationEpoch = (Date)subProperties.get("realizationEpoch");
        this.validArea = (Extent)subProperties.get("validArea");
        this.scope = (InternationalString)subProperties.get("scope");
        this.realizationEpoch = realizationEpoch != null ? realizationEpoch.getTime() : Long.MIN_VALUE;
    }

    public InternationalString getAnchorPoint() {
        return this.anchorPoint;
    }

    public Date getRealizationEpoch() {
        return this.realizationEpoch != Long.MIN_VALUE ? new Date(this.realizationEpoch) : null;
    }

    public Extent getValidArea() {
        return this.validArea;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    int getLegacyDatumType() {
        return 0;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (!compareMetadata) {
                return this.nameMatches(object.getName().getCode()) || AbstractDatum.nameMatches(object, this.getName().getCode());
            }
            AbstractDatum that = (AbstractDatum)object;
            return this.realizationEpoch == that.realizationEpoch && Utilities.equals(this.validArea, that.validArea) && Utilities.equals(this.anchorPoint, that.anchorPoint) && Utilities.equals(this.scope, that.scope);
        }
        return false;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.append(this.getLegacyDatumType());
        return Utilities.getShortClassName(this);
    }
}

