/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.units.Unit;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.InternationalString;

public class AllAuthoritiesFactory
extends AbstractAuthorityFactory
implements DatumAuthorityFactory,
CSAuthorityFactory,
CRSAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final Citation AUTHORITY = (Citation)((Object)new CitationImpl(Vocabulary.format(4)).unmodifiable());
    public static AllAuthoritiesFactory DEFAULT = new AllAuthoritiesFactory(null);
    private final Collection factories;
    private final char separator;
    private final Hints userHints;
    private static final Class[] AUTHORIZED_TYPES = new Class[]{CRSAuthorityFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CoordinateOperationAuthorityFactory.class};
    private static final int TYPE_COUNT = 4;
    static /* synthetic */ Class class$org$geotools$referencing$factory$AllAuthoritiesFactory;

    public AllAuthoritiesFactory(Hints hints) {
        this(hints, null);
    }

    public AllAuthoritiesFactory(Hints hints, Collection factories) {
        this(hints, factories, ':');
    }

    public AllAuthoritiesFactory(Hints hints, Collection factories, char separator) {
        super(50);
        this.separator = separator;
        this.userHints = new Hints((Map)hints);
        if (factories != null && !factories.isEmpty()) {
            Iterator it = factories.iterator();
            while (it.hasNext()) {
                Object factory = it.next();
                if (!(factory instanceof Factory)) continue;
                this.hints.putAll(((Factory)factory).getImplementationHints());
            }
            this.factories = AllAuthoritiesFactory.createFallbacks(factories);
        } else {
            this.factories = null;
        }
    }

    private static Collection createFallbacks(Collection factories) {
        int authorityCount = 0;
        Citation[] authorities = new Citation[factories.size()];
        List[] factoriesByType = new List[authorities.length * AUTHORIZED_TYPES.length];
        final IdentityHashMap<AuthorityFactory, Integer> positions = new IdentityHashMap<AuthorityFactory, Integer>();
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            int authorityBase;
            AuthorityFactory factory = (AuthorityFactory)it.next();
            Citation authority = factory.getAuthority();
            Integer old = positions.put(factory, new Integer(~positions.size()));
            if (old != null) {
                positions.put(factory, old);
                continue;
            }
            for (authorityBase = 0; authorityBase < authorityCount; ++authorityBase) {
                Citation candidate = authorities[authorityBase];
                if (!Citations.identifierMatches(candidate, authority)) continue;
                authority = candidate;
                break;
            }
            if (authorityBase == authorityCount) {
                authorities[authorityCount++] = authority;
            }
            authorityBase *= AUTHORIZED_TYPES.length;
            for (int i = 0; i < AUTHORIZED_TYPES.length; ++i) {
                Class type = AUTHORIZED_TYPES[i];
                if (!type.isInstance(factory)) continue;
                ArrayList<AuthorityFactory> forType = factoriesByType[authorityBase + i];
                if (forType == null) {
                    factoriesByType[authorityBase + i] = forType = new ArrayList<AuthorityFactory>();
                }
                forType.add(factory);
            }
        }
        ArrayList<AuthorityFactory> result = new ArrayList<AuthorityFactory>();
        for (int i = 0; i < factoriesByType.length; ++i) {
            List forType = factoriesByType[i];
            if (forType == null) continue;
            AuthorityFactory factory = (AuthorityFactory)forType.get(0);
            Integer position = (Integer)positions.get(factory);
            if (forType.size() != 1) {
                Class type = AUTHORIZED_TYPES[i % AUTHORIZED_TYPES.length];
                factory = FallbackAuthorityFactory.create(type, forType);
                if (position < 0) {
                    position = new Integer(~position.intValue());
                }
                if (positions.put(factory, position) != null) {
                    throw new AssertionError(factory);
                }
            } else {
                if (position >= 0) continue;
                positions.put(factory, new Integer(~position.intValue()));
            }
            result.add(factory);
        }
        result.trimToSize();
        Collections.sort(result, new Comparator(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public int compare(Object f1, Object f2) {
                int p1 = (Integer)positions.get(f1);
                int p2 = (Integer)positions.get(f2);
                if (!$assertionsDisabled && p1 < 0) {
                    throw new AssertionError(p1);
                }
                if (!$assertionsDisabled && p2 < 0) {
                    throw new AssertionError(p2);
                }
                return p1 - p2;
            }

            static {
                $assertionsDisabled = !(class$org$geotools$referencing$factory$AllAuthoritiesFactory == null ? (class$org$geotools$referencing$factory$AllAuthoritiesFactory = AllAuthoritiesFactory.class$("org.geotools.referencing.factory.AllAuthoritiesFactory")) : class$org$geotools$referencing$factory$AllAuthoritiesFactory).desiredAssertionStatus();
            }
        });
        return result;
    }

    public Citation getAuthority() {
        return AUTHORITY;
    }

    private String getAuthority(String code) throws NoSuchAuthorityCodeException {
        AllAuthoritiesFactory.ensureNonNull("code", code);
        int split = code.indexOf(this.separator);
        if (split >= 0) {
            return code.substring(0, split).trim();
        }
        throw new NoSuchAuthorityCodeException(Errors.format(182, code), Vocabulary.format(176), code);
    }

    private NoSuchAuthorityCodeException noSuchAuthority(String code, FactoryRegistryException cause) {
        String authority;
        try {
            authority = this.getAuthority(code);
        }
        catch (NoSuchAuthorityCodeException exception) {
            return exception;
        }
        NoSuchAuthorityCodeException exception = new NoSuchAuthorityCodeException(Errors.format(183, authority), authority, code);
        exception.initCause(cause);
        return exception;
    }

    private AuthorityFactory getAuthorityFactory(Class type, String authority) {
        if (this.factories != null) {
            Iterator it = this.factories.iterator();
            while (it.hasNext()) {
                AuthorityFactory factory = (AuthorityFactory)it.next();
                if (!type.isAssignableFrom(factory.getClass()) || !Citations.identifierMatches(factory.getAuthority(), authority)) continue;
                return factory;
            }
        }
        return null;
    }

    private DatumAuthorityFactory getDatumAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        String authority;
        DatumAuthorityFactory factory = (DatumAuthorityFactory)this.getAuthorityFactory(DatumAuthorityFactory.class, authority = this.getAuthority(code));
        if (factory == null) {
            try {
                factory = FactoryFinder.getDatumAuthorityFactory(authority, this.userHints);
            }
            catch (FactoryRegistryException cause) {
                throw this.noSuchAuthority(code, cause);
            }
        }
        return factory;
    }

    private CSAuthorityFactory getCSAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        String authority;
        CSAuthorityFactory factory = (CSAuthorityFactory)this.getAuthorityFactory(CSAuthorityFactory.class, authority = this.getAuthority(code));
        if (factory == null) {
            try {
                factory = FactoryFinder.getCSAuthorityFactory(authority, this.userHints);
            }
            catch (FactoryRegistryException cause) {
                throw this.noSuchAuthority(code, cause);
            }
        }
        return factory;
    }

    private CRSAuthorityFactory getCRSAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        String authority;
        CRSAuthorityFactory factory = (CRSAuthorityFactory)this.getAuthorityFactory(CRSAuthorityFactory.class, authority = this.getAuthority(code));
        if (factory == null) {
            try {
                factory = FactoryFinder.getCRSAuthorityFactory(authority, this.userHints);
            }
            catch (FactoryRegistryException cause) {
                throw this.noSuchAuthority(code, cause);
            }
        }
        return factory;
    }

    private CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        String authority;
        CoordinateOperationAuthorityFactory factory = (CoordinateOperationAuthorityFactory)this.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, authority = this.getAuthority(code));
        if (factory == null) {
            try {
                factory = FactoryFinder.getCoordinateOperationAuthorityFactory(authority, this.userHints);
            }
            catch (FactoryRegistryException cause) {
                throw this.noSuchAuthority(code, cause);
            }
        }
        return factory;
    }

    private AuthorityFactory getAuthorityFactory(String code, int type) throws NoSuchAuthorityCodeException {
        switch (type) {
            case 0: {
                return this.getCRSAuthorityFactory(code);
            }
            case 1: {
                return this.getDatumAuthorityFactory(code);
            }
            case 2: {
                return this.getCSAuthorityFactory(code);
            }
            case 3: {
                return this.getCoordinateOperationAuthorityFactory(code);
            }
        }
        throw new IllegalArgumentException(String.valueOf(type));
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        Iterator it = FactoryFinder.getAuthorityNames().iterator();
        while (it.hasNext()) {
            String authority = (String)it.next();
            StringBuffer code = new StringBuffer(authority);
            code.append(this.separator);
            int codeBase = code.length();
            code.append("all");
            String dummyCode = code.toString();
            for (int i = 0; i < 4; ++i) {
                AuthorityFactory factory;
                try {
                    factory = this.getAuthorityFactory(dummyCode, i);
                }
                catch (NoSuchAuthorityCodeException e) {
                    continue;
                }
                if (!done.add(factory)) continue;
                Iterator it2 = factory.getAuthorityCodes(type).iterator();
                while (it2.hasNext()) {
                    String candidate = ((String)it2.next()).trim();
                    if (candidate.length() < codeBase || Character.isLetterOrDigit(candidate.charAt(codeBase - 1)) || !authority.equalsIgnoreCase(candidate.substring(0, codeBase - 1))) {
                        code.setLength(codeBase);
                        code.append(candidate);
                        candidate = code.toString();
                    }
                    codes.add(candidate);
                }
            }
        }
        return codes;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        FactoryException failure = null;
        for (int type = 0; type < 4; ++type) {
            AuthorityFactory factory;
            try {
                factory = this.getAuthorityFactory(code, type);
            }
            catch (NoSuchAuthorityCodeException exception) {
                if (failure != null) continue;
                failure = exception;
                continue;
            }
            if (!done.add(factory)) continue;
            try {
                return factory.getDescriptionText(code);
            }
            catch (FactoryException exception) {
                if (failure != null && !(failure.getCause() instanceof FactoryRegistryException)) continue;
                failure = exception;
            }
        }
        if (failure == null) {
            failure = this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        throw failure;
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        FactoryException failure = null;
        for (int type = 0; type < 4; ++type) {
            AuthorityFactory factory;
            try {
                factory = this.getAuthorityFactory(code, type);
            }
            catch (NoSuchAuthorityCodeException exception) {
                if (failure != null) continue;
                failure = exception;
                continue;
            }
            if (!done.add(factory)) continue;
            try {
                return factory.createObject(code);
            }
            catch (FactoryException exception) {
                if (failure != null && !(failure.getCause() instanceof FactoryRegistryException)) continue;
                failure = exception;
            }
        }
        if (failure == null) {
            failure = this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        throw failure;
    }

    public Datum createDatum(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createDatum(code);
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createEngineeringDatum(code);
    }

    public ImageDatum createImageDatum(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createImageDatum(code);
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createVerticalDatum(code);
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createTemporalDatum(code);
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createGeodeticDatum(code);
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createEllipsoid(code);
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createPrimeMeridian(code);
    }

    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createCoordinateSystem(code);
    }

    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createCartesianCS(code);
    }

    public PolarCS createPolarCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createPolarCS(code);
    }

    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createCylindricalCS(code);
    }

    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createSphericalCS(code);
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createEllipsoidalCS(code);
    }

    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createVerticalCS(code);
    }

    public TimeCS createTimeCS(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createTimeCS(code);
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createCoordinateSystemAxis(code);
    }

    public Unit createUnit(String code) throws FactoryException {
        return this.getCSAuthorityFactory(code).createUnit(code);
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createCoordinateReferenceSystem(code);
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createCompoundCRS(code);
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createDerivedCRS(code);
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createEngineeringCRS(code);
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createGeographicCRS(code);
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createGeocentricCRS(code);
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createImageCRS(code);
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createProjectedCRS(code);
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createTemporalCRS(code);
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return this.getCRSAuthorityFactory(code).createVerticalCRS(code);
    }

    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.getCoordinateOperationAuthorityFactory(code).createCoordinateOperation(code);
    }

    public Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        String targetAuthority;
        String sourceAuthority = this.getAuthority(sourceCode);
        if (sourceAuthority.equals(targetAuthority = this.getAuthority(targetCode))) {
            return this.getCoordinateOperationAuthorityFactory(sourceCode).createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
        }
        return super.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
    }
}

