/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;
import org.geotools.referencing.factory.epsg.TableInfo;
import org.geotools.resources.Utilities;
import org.opengis.referencing.operation.Projection;

final class AuthorityCodes
extends AbstractSet
implements Serializable {
    private final FactoryUsingSQL factory;
    public final Class type;
    private final boolean isProjection;
    private transient java.util.Map asMap;
    final String sqlAll;
    private final String sqlSingle;
    private transient PreparedStatement queryAll;
    private transient PreparedStatement querySingle;
    private final Connection connection;
    private int size = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuthorityCodes(Connection connection, TableInfo table, Class type, FactoryUsingSQL factory) {
        this.factory = factory;
        this.connection = connection;
        StringBuffer buffer = new StringBuffer("SELECT ");
        buffer.append(table.codeColumn);
        if (table.nameColumn != null) {
            buffer.append(", ");
            buffer.append(table.nameColumn);
        }
        buffer.append(" FROM ");
        buffer.append(table.table);
        boolean hasWhere = false;
        Class tableType = table.type;
        if (table.typeColumn != null) {
            int i = table.subTypes.length;
            while (--i >= 0) {
                Class candidate = table.subTypes[i];
                if (!candidate.isAssignableFrom(type)) continue;
                buffer.append(hasWhere ? " OR " : " WHERE (");
                buffer.append(table.typeColumn);
                buffer.append(" LIKE '");
                buffer.append(table.typeNames[i]);
                buffer.append("%'");
                hasWhere = true;
                tableType = candidate;
            }
            if (hasWhere) {
                buffer.append(')');
            }
        }
        this.type = tableType;
        this.isProjection = Projection.class.isAssignableFrom(tableType);
        int length = buffer.length();
        buffer.append(" ORDER BY ");
        buffer.append(table.codeColumn);
        this.sqlAll = factory.adaptSQL(buffer.toString());
        buffer.setLength(length);
        buffer.append(hasWhere ? " AND " : " WHERE ");
        buffer.append(table.codeColumn);
        buffer.append(" = ?");
        this.sqlSingle = factory.adaptSQL(buffer.toString());
    }

    private ResultSet getAll() throws SQLException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.queryAll == null) {
            this.queryAll = this.connection.prepareStatement(this.sqlAll);
        }
        return this.queryAll.executeQuery();
    }

    private ResultSet getSingle(Object code) throws SQLException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.querySingle == null) {
            this.querySingle = this.connection.prepareStatement(this.sqlSingle);
        }
        this.querySingle.setString(1, code.toString());
        return this.querySingle.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcceptable(ResultSet results) throws SQLException {
        if (!this.isProjection) {
            return true;
        }
        String code = results.getString(1);
        FactoryUsingSQL factoryUsingSQL = this.factory;
        synchronized (factoryUsingSQL) {
            return this.factory.isProjection(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcceptable(String code) throws SQLException {
        if (!this.isProjection) {
            return true;
        }
        FactoryUsingSQL factoryUsingSQL = this.factory;
        synchronized (factoryUsingSQL) {
            return this.factory.isProjection(code);
        }
    }

    public synchronized boolean isEmpty() {
        if (this.size != -1) {
            return this.size == 0;
        }
        boolean empty = true;
        try {
            ResultSet results = this.getAll();
            while (results.next()) {
                if (!this.isAcceptable(results)) continue;
                empty = false;
                break;
            }
            results.close();
        }
        catch (SQLException exception) {
            AuthorityCodes.unexpectedException("isEmpty", exception);
        }
        this.size = empty ? 0 : -2;
        return empty;
    }

    public synchronized int size() {
        if (this.size >= 0) {
            return this.size;
        }
        int count = 0;
        try {
            ResultSet results = this.getAll();
            while (results.next()) {
                if (!this.isAcceptable(results)) continue;
                ++count;
            }
            results.close();
        }
        catch (SQLException exception) {
            AuthorityCodes.unexpectedException("size", exception);
        }
        this.size = count;
        return count;
    }

    public synchronized boolean contains(Object code) {
        boolean exists = false;
        if (code != null) {
            try {
                ResultSet results = this.getSingle(code);
                while (results.next()) {
                    if (!this.isAcceptable(results)) continue;
                    exists = true;
                    break;
                }
                results.close();
            }
            catch (SQLException exception) {
                AuthorityCodes.unexpectedException("contains", exception);
            }
        }
        return exists;
    }

    public synchronized java.util.Iterator iterator() {
        try {
            Iterator iterator = new Iterator(this.getAll());
            this.queryAll = null;
            return iterator;
        }
        catch (SQLException exception) {
            AuthorityCodes.unexpectedException("iterator", exception);
            return Collections.EMPTY_SET.iterator();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashSet(this);
    }

    protected synchronized void finalize() throws SQLException {
        if (this.querySingle != null) {
            this.querySingle.close();
            this.querySingle = null;
        }
        if (this.queryAll != null) {
            this.queryAll.close();
            this.queryAll = null;
        }
    }

    private static void unexpectedException(String method, SQLException exception) {
        AuthorityCodes.unexpectedException("AuthorityCodes", method, exception);
    }

    static void unexpectedException(String classe, String method, SQLException exception) {
        Utilities.unexpectedException("org.geotools.referencing.factory", classe, method, exception);
    }

    final java.util.Map asMap() {
        if (this.asMap == null) {
            this.asMap = new Map();
        }
        return this.asMap;
    }

    static {
        $assertionsDisabled = !AuthorityCodes.class.desiredAssertionStatus();
    }

    private final class Map
    extends AbstractMap {
        private Map() {
        }

        public int size() {
            return AuthorityCodes.this.size();
        }

        public boolean isEmpty() {
            return AuthorityCodes.this.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object code) {
            String value = null;
            if (code != null) {
                try {
                    AuthorityCodes authorityCodes = AuthorityCodes.this;
                    synchronized (authorityCodes) {
                        ResultSet results = AuthorityCodes.this.getSingle(code);
                        while (results.next()) {
                            if (!AuthorityCodes.this.isAcceptable(results)) continue;
                            value = results.getString(2);
                            break;
                        }
                        results.close();
                    }
                }
                catch (SQLException exception) {
                    AuthorityCodes.unexpectedException("get", exception);
                }
            }
            return value;
        }

        public boolean containsKey(Object key) {
            return AuthorityCodes.this.contains(key);
        }

        public Set keySet() {
            return AuthorityCodes.this;
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Iterator
    implements java.util.Iterator {
        private ResultSet results;
        private transient String next;

        Iterator(ResultSet results) throws SQLException {
            this.results = results;
            this.toNext();
        }

        private void toNext() throws SQLException {
            while (this.results.next()) {
                this.next = this.results.getString(1);
                if (!AuthorityCodes.this.isAcceptable(this.next)) continue;
                return;
            }
            this.finalize();
        }

        public boolean hasNext() {
            return this.results != null;
        }

        public Object next() {
            if (this.results == null) {
                throw new NoSuchElementException();
            }
            String current = this.next;
            try {
                this.toNext();
            }
            catch (SQLException exception) {
                this.results = null;
                AuthorityCodes.unexpectedException("AuthorityCodes.Iterator", "next", exception);
            }
            return current;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws SQLException {
            this.next = null;
            if (this.results != null) {
                PreparedStatement owner = (PreparedStatement)this.results.getStatement();
                this.results.close();
                this.results = null;
                AuthorityCodes authorityCodes = AuthorityCodes.this;
                synchronized (authorityCodes) {
                    if (AuthorityCodes.this.queryAll == null) {
                        AuthorityCodes.this.queryAll = owner;
                    } else {
                        owner.close();
                    }
                }
            }
        }
    }
}

